/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.distribution;

import org.apache.datasketches.memory.Memory;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.ArrayOfStringsNullSafeSerde;
import org.apache.druid.java.util.common.IAE;
import org.junit.Assert;
import org.junit.Test;

public class ArrayOfStringsNullSafeSerdeTest {
    private final ArrayOfStringsNullSafeSerde serde = new ArrayOfStringsNullSafeSerde();

    @Test
    public void testStringArray() {
        this.testSerde("abc", "def", "xyz");
        this.testSerde("abc", "123", "456.0");
    }

    @Test
    public void testSingletonArray() {
        this.testSerde("abc");
        this.testSerde("xyz");
    }

    @Test
    public void testEmptyArray() {
        this.testSerde(new String[0]);
    }

    @Test
    public void testArrayWithNullString() {
        this.testSerde(new String[]{null});
        this.testSerde("abc", null, "def");
        this.testSerde(null, null, null);
    }

    @Test
    public void testArrayWithEmptyString() {
        this.testSerde("");
        this.testSerde("abc", "def", "");
        this.testSerde("", "", "");
        this.testSerde("", null, "abc");
    }

    @Test
    public void testIllegalStrLength() {
        byte[] bytes = new byte[]{-2, -1, -1, -1};
        IAE exception = (IAE)Assert.assertThrows(IAE.class, () -> this.serde.deserializeFromMemory(Memory.wrap((byte[])bytes), 1));
        Assert.assertEquals((Object)"Illegal strLength [-2] at offset [4]. Must be -1, 0 or a positive integer.", (Object)exception.getMessage());
    }

    private void testSerde(String ... inputArray) {
        byte[] bytes = this.serde.serializeToByteArray(inputArray);
        Object[] deserialized = this.serde.deserializeFromMemory(Memory.wrap((byte[])bytes), inputArray.length);
        Assert.assertEquals((Object[])inputArray, (Object[])deserialized);
    }
}

