/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.concurrent.TaskThreadPriority;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.TaskToolboxFactory;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.overlord.TaskRunnerUtils;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.SegmentDescriptor;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class TestTaskRunner
implements TaskRunner,
QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(TestTaskRunner.class);
    private final ConcurrentHashMap<Integer, ListeningExecutorService> exec = new ConcurrentHashMap();
    private final Set<TestTaskRunnerWorkItem> runningItems = new ConcurrentSkipListSet<TestTaskRunnerWorkItem>();
    private final CopyOnWriteArrayList<Pair<TaskRunnerListener, Executor>> listeners = new CopyOnWriteArrayList();
    private final TaskToolboxFactory toolboxFactory;
    private final TaskConfig taskConfig;
    private final TaskLocation taskLocation;
    private volatile boolean stopping = false;

    public TestTaskRunner(TaskToolboxFactory toolboxFactory, TaskConfig taskConfig, TaskLocation taskLocation) {
        this.toolboxFactory = (TaskToolboxFactory)Preconditions.checkNotNull((Object)toolboxFactory, (Object)"toolboxFactory");
        this.taskConfig = taskConfig;
        this.taskLocation = taskLocation;
    }

    public List<Pair<Task, ListenableFuture<TaskStatus>>> restore() {
        return ImmutableList.of();
    }

    public void registerListener(TaskRunnerListener listener, Executor executor) {
        for (Pair<TaskRunnerListener, Executor> pair : this.listeners) {
            if (!((TaskRunnerListener)pair.lhs).getListenerId().equals(listener.getListenerId())) continue;
            throw new ISE("Listener [%s] already registered", new Object[]{listener.getListenerId()});
        }
        Pair listenerPair = Pair.of((Object)listener, (Object)executor);
        this.listeners.add((Pair<TaskRunnerListener, Executor>)listenerPair);
        log.info("Registered listener [%s]", new Object[]{listener.getListenerId()});
        for (TestTaskRunnerWorkItem item : this.runningItems) {
            TaskRunnerUtils.notifyLocationChanged((Iterable)ImmutableList.of((Object)listenerPair), (String)item.getTaskId(), (TaskLocation)item.getLocation());
        }
    }

    public void unregisterListener(String listenerId) {
        for (Pair<TaskRunnerListener, Executor> pair : this.listeners) {
            if (!((TaskRunnerListener)pair.lhs).getListenerId().equals(listenerId)) continue;
            this.listeners.remove(pair);
            log.info("Unregistered listener [%s]", new Object[]{listenerId});
            return;
        }
    }

    private static ListeningExecutorService buildExecutorService(int priority) {
        return MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)("test-task-runner-%d-priority-" + priority), (Integer)TaskThreadPriority.getThreadPriorityFromTaskPriority((int)priority)));
    }

    public void stop() {
        this.stopping = true;
        for (Map.Entry<Integer, ListeningExecutorService> entry : this.exec.entrySet()) {
            try {
                entry.getValue().shutdown();
            }
            catch (SecurityException ex) {
                throw new RuntimeException("I can't control my own threads!", ex);
            }
        }
        for (TestTaskRunnerWorkItem testTaskRunnerWorkItem : this.runningItems) {
            Task task = testTaskRunnerWorkItem.getTask();
            long start = System.currentTimeMillis();
            if (this.taskConfig.isRestoreTasksOnRestart() && task.canRestore()) {
                log.info("Starting graceful shutdown of task[%s].", new Object[]{task.getId()});
                try {
                    task.stopGracefully(this.taskConfig);
                    TaskStatus taskStatus = (TaskStatus)testTaskRunnerWorkItem.getResult().get(new Interval((ReadableInstant)DateTimes.utc((long)start), (ReadablePeriod)this.taskConfig.getGracefulShutdownTimeout()).toDurationMillis(), TimeUnit.MILLISECONDS);
                    log.info("Graceful shutdown of task[%s] finished in %,dms.", new Object[]{task.getId(), System.currentTimeMillis() - start});
                    TaskRunnerUtils.notifyStatusChanged(this.listeners, (String)task.getId(), (TaskStatus)taskStatus);
                    continue;
                }
                catch (Exception e) {
                    String errMsg = "Graceful shutdown of task aborted with exception, see task logs for more information";
                    TaskRunnerUtils.notifyStatusChanged(this.listeners, (String)task.getId(), (TaskStatus)TaskStatus.failure((String)task.getId(), (String)errMsg));
                    throw new RE((Throwable)e, "Graceful shutdown of task[%s] aborted with exception", new Object[]{task.getId()});
                }
            }
            TaskRunnerUtils.notifyStatusChanged(this.listeners, (String)task.getId(), (TaskStatus)TaskStatus.failure((String)task.getId(), (String)"Task failure while shutting down gracefully"));
        }
        for (Map.Entry entry : this.exec.entrySet()) {
            try {
                ((ListeningExecutorService)entry.getValue()).shutdownNow();
            }
            catch (SecurityException ex) {
                throw new RuntimeException("I can't control my own threads!", ex);
            }
        }
    }

    public ListenableFuture<TaskStatus> run(Task task) {
        TaskToolbox toolbox = this.toolboxFactory.build(task);
        Object taskPriorityObj = task.getContextValue("backgroundThreadPriority");
        int taskPriority = 0;
        try {
            taskPriority = taskPriorityObj == null ? 0 : Numbers.parseInt((Object)taskPriorityObj);
        }
        catch (NumberFormatException e) {
            log.error((Throwable)e, "Error parsing task priority [%s] for task [%s]", new Object[]{taskPriorityObj, task.getId()});
        }
        int finalTaskPriority = taskPriority;
        ListenableFuture statusFuture = this.exec.computeIfAbsent(taskPriority, k -> TestTaskRunner.buildExecutorService(finalTaskPriority)).submit((Callable)new TestTaskRunnerCallable(task, toolbox));
        final TestTaskRunnerWorkItem taskRunnerWorkItem = new TestTaskRunnerWorkItem(task, statusFuture);
        this.runningItems.add(taskRunnerWorkItem);
        Futures.addCallback((ListenableFuture)statusFuture, (FutureCallback)new FutureCallback<TaskStatus>(){

            public void onSuccess(TaskStatus result) {
                TestTaskRunner.this.runningItems.remove(taskRunnerWorkItem);
            }

            public void onFailure(Throwable t) {
                TestTaskRunner.this.runningItems.remove(taskRunnerWorkItem);
            }
        });
        return statusFuture;
    }

    public void shutdown(String taskid, String reason) {
        for (TaskRunnerWorkItem taskRunnerWorkItem : this.runningItems) {
            if (!taskRunnerWorkItem.getTaskId().equals(taskid)) continue;
            taskRunnerWorkItem.getResult().cancel(true);
        }
    }

    public Collection<TaskRunnerWorkItem> getRunningTasks() {
        return ImmutableList.copyOf(this.runningItems);
    }

    public Collection<TaskRunnerWorkItem> getPendingTasks() {
        return ImmutableList.of();
    }

    public Collection<TaskRunnerWorkItem> getKnownTasks() {
        return ImmutableList.copyOf(this.runningItems);
    }

    public Optional<ScalingStats> getScalingStats() {
        return Optional.absent();
    }

    public Map<String, Long> getTotalTaskSlotCount() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Long> getIdleTaskSlotCount() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Long> getUsedTaskSlotCount() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Long> getLazyTaskSlotCount() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Long> getBlacklistedTaskSlotCount() {
        throw new UnsupportedOperationException();
    }

    public void start() {
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        throw new UnsupportedOperationException();
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        throw new UnsupportedOperationException();
    }

    private class TestTaskRunnerCallable
    implements Callable<TaskStatus> {
        private final Task task;
        private final TaskToolbox toolbox;

        public TestTaskRunnerCallable(Task task, TaskToolbox toolbox) {
            this.task = task;
            this.toolbox = toolbox;
        }

        @Override
        public TaskStatus call() {
            TaskStatus status;
            long startTime = System.currentTimeMillis();
            try {
                log.info("Running task: %s", new Object[]{this.task.getId()});
                TaskRunnerUtils.notifyLocationChanged((Iterable)TestTaskRunner.this.listeners, (String)this.task.getId(), (TaskLocation)TestTaskRunner.this.taskLocation);
                TaskRunnerUtils.notifyStatusChanged((Iterable)TestTaskRunner.this.listeners, (String)this.task.getId(), (TaskStatus)TaskStatus.running((String)this.task.getId()));
                status = this.task.run(this.toolbox);
            }
            catch (InterruptedException e) {
                if (TestTaskRunner.this.stopping) {
                    log.debug((Throwable)e, "Interrupted while running task[%s] during graceful shutdown.", new Object[]{this.task});
                } else {
                    log.warn((Throwable)e, "Interrupted while running task[%s]", new Object[]{this.task});
                }
                status = TaskStatus.failure((String)this.task.getId(), (String)"Task failed due to its thread being interrupted");
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception while running task[%s]", new Object[]{this.task});
                status = TaskStatus.failure((String)this.task.getId(), (String)"Task failed");
            }
            catch (Throwable t) {
                throw new RE(t, "Uncaught Throwable while running task[%s]", new Object[]{this.task});
            }
            status = status.withDuration(System.currentTimeMillis() - startTime);
            TaskRunnerUtils.notifyStatusChanged((Iterable)TestTaskRunner.this.listeners, (String)this.task.getId(), (TaskStatus)status);
            return status;
        }
    }

    private static class TestTaskRunnerWorkItem
    extends TaskRunnerWorkItem
    implements Comparable<TestTaskRunnerWorkItem> {
        private final Task task;

        private TestTaskRunnerWorkItem(Task task, ListenableFuture<TaskStatus> result) {
            super(task.getId(), result);
            this.task = task;
        }

        public Task getTask() {
            return this.task;
        }

        public TaskLocation getLocation() {
            return TaskLocation.create((String)"testHost", (int)10000, (int)10000);
        }

        public String getTaskType() {
            return this.task.getType();
        }

        public String getDataSource() {
            return this.task.getDataSource();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof TestTaskRunnerWorkItem) {
                TestTaskRunnerWorkItem that = (TestTaskRunnerWorkItem)o;
                return this.task.getId().equals(that.task.getId());
            }
            return false;
        }

        public int hashCode() {
            return this.task.getId().hashCode();
        }

        @Override
        public int compareTo(TestTaskRunnerWorkItem o) {
            return this.task.getId().compareTo(o.task.getId());
        }
    }
}

