/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.helpers;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.indexing.overlord.helpers.TaskLogAutoCleanerConfig;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class TaskLogAutoCleanerConfigTest {
    @Test
    public void testSerde() throws Exception {
        String json = "{\n  \"enabled\": true,\n  \"initialDelay\": 10,\n  \"delay\": 40,\n  \"durationToRetain\": 30\n}";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        TaskLogAutoCleanerConfig config = (TaskLogAutoCleanerConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, TaskLogAutoCleanerConfig.class)), TaskLogAutoCleanerConfig.class);
        Assert.assertTrue((boolean)config.isEnabled());
        Assert.assertEquals((long)10L, (long)config.getInitialDelay());
        Assert.assertEquals((long)40L, (long)config.getDelay());
        Assert.assertEquals((long)30L, (long)config.getDurationToRetain());
    }

    @Test
    public void testSerdeWithDefaults() throws Exception {
        String json = "{}";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        TaskLogAutoCleanerConfig config = (TaskLogAutoCleanerConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, TaskLogAutoCleanerConfig.class)), TaskLogAutoCleanerConfig.class);
        Assert.assertFalse((boolean)config.isEnabled());
        Assert.assertTrue((config.getInitialDelay() >= 60000L && config.getInitialDelay() <= 300000L ? 1 : 0) != 0);
        Assert.assertEquals((long)21600000L, (long)config.getDelay());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)config.getDurationToRetain());
    }
}

