/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.hrtr;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.config.HttpRemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.hrtr.WorkerHolder;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.indexing.worker.WorkerHistoryItem;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.coordination.ChangeRequestHttpSyncer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class WorkerHolderTest {
    @Test
    public void testSyncListener() {
        ArrayList updates = new ArrayList();
        NoopTask task0 = NoopTask.create((String)"task0", (int)0);
        NoopTask task1 = NoopTask.create((String)"task1", (int)0);
        NoopTask task2 = NoopTask.create((String)"task2", (int)0);
        NoopTask task3 = NoopTask.create((String)"task3", (int)0);
        WorkerHolder workerHolder = new WorkerHolder(TestHelper.makeJsonMapper(), (HttpClient)EasyMock.createNiceMock(HttpClient.class), new HttpRemoteTaskRunnerConfig(), (ScheduledExecutorService)EasyMock.createNiceMock(ScheduledExecutorService.class), (taskAnnouncement, holder) -> updates.add(taskAnnouncement), new Worker("http", "localhost", "127.0.0.1", 5, "v0", "_default_worker_category"), (List)ImmutableList.of((Object)TaskAnnouncement.create((Task)task0, (TaskStatus)TaskStatus.running((String)task0.getId()), (TaskLocation)TaskLocation.unknown()), (Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.running((String)task1.getId()), (TaskLocation)TaskLocation.unknown())));
        ChangeRequestHttpSyncer.Listener syncListener = workerHolder.createSyncListener();
        Assert.assertTrue((boolean)workerHolder.disabled.get());
        syncListener.fullSync((List)ImmutableList.of((Object)new WorkerHistoryItem.Metadata(false), (Object)new WorkerHistoryItem.TaskUpdate(TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.success((String)task1.getId()), (TaskLocation)TaskLocation.create((String)"w1", (int)1, (int)-1))), (Object)new WorkerHistoryItem.TaskUpdate(TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.running((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"w1", (int)2, (int)-1))), (Object)new WorkerHistoryItem.TaskUpdate(TaskAnnouncement.create((Task)task3, (TaskStatus)TaskStatus.running((String)task3.getId()), (TaskLocation)TaskLocation.create((String)"w1", (int)2, (int)-1)))));
        Assert.assertFalse((boolean)workerHolder.disabled.get());
        Assert.assertEquals((long)4L, (long)updates.size());
        Assert.assertEquals((Object)task1.getId(), (Object)((TaskAnnouncement)updates.get(0)).getTaskId());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(0)).getTaskStatus().isSuccess());
        Assert.assertEquals((Object)task2.getId(), (Object)((TaskAnnouncement)updates.get(1)).getTaskId());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(1)).getTaskStatus().isRunnable());
        Assert.assertEquals((Object)task3.getId(), (Object)((TaskAnnouncement)updates.get(2)).getTaskId());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(2)).getTaskStatus().isRunnable());
        Assert.assertEquals((Object)task0.getId(), (Object)((TaskAnnouncement)updates.get(3)).getTaskId());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(3)).getTaskStatus().isFailure());
        Assert.assertNotNull((Object)((TaskAnnouncement)updates.get(3)).getTaskStatus().getErrorMsg());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(3)).getTaskStatus().getErrorMsg().startsWith("This task disappeared on the worker where it was assigned"));
        updates.clear();
        syncListener.deltaSync((List)ImmutableList.of((Object)new WorkerHistoryItem.Metadata(false), (Object)new WorkerHistoryItem.TaskRemoval(task1.getId()), (Object)new WorkerHistoryItem.Metadata(true), (Object)new WorkerHistoryItem.TaskRemoval(task2.getId()), (Object)new WorkerHistoryItem.Metadata(false), (Object)new WorkerHistoryItem.TaskUpdate(TaskAnnouncement.create((Task)task3, (TaskStatus)TaskStatus.running((String)task3.getId()), (TaskLocation)TaskLocation.create((String)"w1", (int)3, (int)-1)))));
        Assert.assertFalse((boolean)workerHolder.disabled.get());
        Assert.assertEquals((long)2L, (long)updates.size());
        Assert.assertEquals((Object)task2.getId(), (Object)((TaskAnnouncement)updates.get(0)).getTaskId());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(0)).getTaskStatus().isFailure());
        Assert.assertNotNull((Object)((TaskAnnouncement)updates.get(0)).getTaskStatus().getErrorMsg());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(0)).getTaskStatus().getErrorMsg().startsWith("This task disappeared on the worker where it was assigned"));
        Assert.assertEquals((Object)task3.getId(), (Object)((TaskAnnouncement)updates.get(1)).getTaskId());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(1)).getTaskStatus().isRunnable());
        updates.clear();
        syncListener.fullSync((List)ImmutableList.of((Object)new WorkerHistoryItem.Metadata(true), (Object)new WorkerHistoryItem.TaskUpdate(TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.success((String)task1.getId()), (TaskLocation)TaskLocation.create((String)"w1", (int)1, (int)-1))), (Object)new WorkerHistoryItem.TaskUpdate(TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.running((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"w1", (int)2, (int)-1))), (Object)new WorkerHistoryItem.TaskUpdate(TaskAnnouncement.create((Task)task3, (TaskStatus)TaskStatus.running((String)task3.getId()), (TaskLocation)TaskLocation.create((String)"w1", (int)2, (int)-1)))));
        Assert.assertTrue((boolean)workerHolder.disabled.get());
        Assert.assertEquals((long)3L, (long)updates.size());
        Assert.assertEquals((Object)task1.getId(), (Object)((TaskAnnouncement)updates.get(0)).getTaskId());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(0)).getTaskStatus().isSuccess());
        Assert.assertEquals((Object)task2.getId(), (Object)((TaskAnnouncement)updates.get(1)).getTaskId());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(1)).getTaskStatus().isRunnable());
        Assert.assertEquals((Object)task3.getId(), (Object)((TaskAnnouncement)updates.get(2)).getTaskId());
        Assert.assertTrue((boolean)((TaskAnnouncement)updates.get(2)).getTaskStatus().isRunnable());
        updates.clear();
    }
}

