/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.overlord.sampler.InputSourceSampler;
import org.apache.druid.indexing.overlord.sampler.SamplerTestUtils;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.segment.indexing.DataSchema;
import org.junit.Assert;
import org.junit.Test;

public class CsvInputSourceSamplerTest {
    @Test
    public void testCSVColumnAllNull() {
        TimestampSpec timestampSpec = new TimestampSpec(null, null, DateTimes.of((String)"1970"));
        DimensionsSpec dimensionsSpec = new DimensionsSpec(null);
        DataSchema dataSchema = new DataSchema("sampler", timestampSpec, dimensionsSpec, null, null, null);
        ImmutableList strCsvRows = ImmutableList.of((Object)"FirstName,LastName,Number,Gender", (Object)"J,G,,Male", (Object)"Kobe,Bryant,,Male", (Object)"Lisa, Krystal,,Female", (Object)"Michael,Jackson,,Male");
        InlineInputSource inputSource = new InlineInputSource(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)strCsvRows));
        CsvInputFormat inputFormat = new CsvInputFormat(null, null, null, Boolean.valueOf(true), 0);
        InputSourceSampler inputSourceSampler = new InputSourceSampler((ObjectMapper)new DefaultObjectMapper());
        SamplerResponse response = inputSourceSampler.sample((InputSource)inputSource, (InputFormat)inputFormat, dataSchema, null);
        Assert.assertEquals((long)4L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)4L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)4L, (long)response.getData().size());
        List data = response.getData();
        Assert.assertEquals((Object)new SamplerResponse.SamplerResponseRow(new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Object>().put("Number", null).put("FirstName", "J").put("LastName", "G").put("Gender", "Male").build(), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 0L).put("Number", null).put("FirstName", "J").put("LastName", "G").put("Gender", "Male").build(), null, null), data.get(0));
        Assert.assertEquals((Object)new SamplerResponse.SamplerResponseRow(new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Object>().put("Number", null).put("FirstName", "Kobe").put("LastName", "Bryant").put("Gender", "Male").build(), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Object>().put("Number", null).put("__time", 0L).put("FirstName", "Kobe").put("LastName", "Bryant").put("Gender", "Male").build(), null, null), data.get(1));
        Assert.assertEquals((Object)new SamplerResponse.SamplerResponseRow(new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Object>().put("Number", null).put("FirstName", "Lisa").put("LastName", " Krystal").put("Gender", "Female").build(), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Object>().put("Number", null).put("__time", 0L).put("FirstName", "Lisa").put("LastName", " Krystal").put("Gender", "Female").build(), null, null), data.get(2));
        Assert.assertEquals((Object)new SamplerResponse.SamplerResponseRow(new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Object>().put("Number", null).put("FirstName", "Michael").put("LastName", "Jackson").put("Gender", "Male").build(), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 0L).put("Number", null).put("FirstName", "Michael").put("LastName", "Jackson").put("Gender", "Male").build(), null, null), data.get(3));
    }
}

