/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.guice.FirehoseModule;
import org.apache.druid.indexing.overlord.sampler.IndexTaskSamplerSpec;
import org.apache.druid.indexing.overlord.sampler.InputSourceSampler;
import org.apache.druid.indexing.overlord.sampler.SamplerConfig;
import org.apache.druid.indexing.overlord.sampler.SamplerModule;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.indexing.DataSchema;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IndexTaskSamplerSpecTest
extends EasyMockSupport {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();
    private final InputSourceSampler inputSourceSampler = (InputSourceSampler)this.createMock(InputSourceSampler.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public IndexTaskSamplerSpecTest() {
        MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(InputSourceSampler.class, (Object)this.inputSourceSampler).addValue(ObjectMapper.class, (Object)MAPPER));
        MAPPER.registerModules((Iterable)new SamplerModule().getJacksonModules());
        MAPPER.registerModules((Iterable)new FirehoseModule().getJacksonModules());
    }

    @Test
    public void testSerde() throws IOException {
        String json = "{\n  \"type\": \"index\",\n  \"samplerConfig\": {\n    \"numRows\": 123,\n    \"timeoutMs\": 2345\n  },\n  \"spec\": {\n    \"dataSchema\": {\n      \"dataSource\": \"sampler\",\n      \"dimensionsSpec\": {},\n      \"timestampSpec\": {\n        \"missingValue\": \"1970\"\n      }\n    },\n    \"ioConfig\": {\n      \"type\": \"index\",\n      \"inputSource\": {\n        \"type\": \"local\",\n        \"baseDir\": \"/tmp\",\n        \"filter\": \"wikiticker-2015-09-12-sampled.json\"\n      },\n      \"inputFormat\": {\n        \"type\": \"json\"\n      }\n    }\n  }\n}";
        Capture capturedInputSource = EasyMock.newCapture();
        Capture capturedInputFormat = EasyMock.newCapture();
        Capture capturedDataSchema = EasyMock.newCapture();
        Capture capturedSamplerConfig = EasyMock.newCapture();
        IndexTaskSamplerSpec spec = (IndexTaskSamplerSpec)MAPPER.readValue(json, IndexTaskSamplerSpec.class);
        EasyMock.expect((Object)this.inputSourceSampler.sample((InputSource)EasyMock.capture((Capture)capturedInputSource), (InputFormat)EasyMock.capture((Capture)capturedInputFormat), (DataSchema)EasyMock.capture((Capture)capturedDataSchema), (SamplerConfig)EasyMock.capture((Capture)capturedSamplerConfig))).andReturn((Object)new SamplerResponse(0, 0, null));
        this.replayAll();
        spec.sample();
        this.verifyAll();
        InputSource inputSource = (InputSource)capturedInputSource.getValue();
        Assert.assertEquals((Object)new File("/tmp"), (Object)((LocalInputSource)inputSource).getBaseDir());
        Assert.assertEquals((Object)"wikiticker-2015-09-12-sampled.json", (Object)((LocalInputSource)inputSource).getFilter());
        DataSchema dataSchema = (DataSchema)capturedDataSchema.getValue();
        Assert.assertEquals((Object)"sampler", (Object)dataSchema.getDataSource());
        Assert.assertEquals(JsonInputFormat.class, ((InputFormat)capturedInputFormat.getValue()).getClass());
        SamplerConfig samplerConfig = (SamplerConfig)capturedSamplerConfig.getValue();
        Assert.assertEquals((long)123L, (long)samplerConfig.getNumRows());
        Assert.assertEquals((long)2345L, (long)samplerConfig.getTimeoutMs());
    }
}

