/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.AffinityConfig;
import org.apache.druid.indexing.overlord.setup.EqualDistributionWithAffinityWorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.WorkerSelectStrategy;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class EqualDistributionWithAffinityWorkerSelectStrategyTest {
    @Test
    public void testFindWorkerForTask() {
        EqualDistributionWithAffinityWorkerSelectStrategy strategy = new EqualDistributionWithAffinityWorkerSelectStrategy(new AffinityConfig((Map)ImmutableMap.of((Object)"foo", (Object)ImmutableSet.of((Object)"localhost1", (Object)"localhost2", (Object)"localhost3")), false));
        NoopTask noopTask = new NoopTask(null, null, null, 1L, 0L, null, null, null){

            public String getDataSource() {
                return "foo";
            }
        };
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"localhost0", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost0", "localhost0", 2, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost1", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost1", "localhost1", 2, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost2", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost2", "localhost2", 2, "v1", "_default_worker_category"), 1, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost3", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost3", "localhost3", 2, "v1", "_default_worker_category"), 1, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)noopTask);
        Assert.assertEquals((Object)"localhost1", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testFindWorkerForTaskWithNulls() {
        EqualDistributionWithAffinityWorkerSelectStrategy strategy = new EqualDistributionWithAffinityWorkerSelectStrategy(new AffinityConfig((Map)ImmutableMap.of((Object)"foo", (Object)ImmutableSet.of((Object)"localhost")), false));
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"lhost", (Object)new ImmutableWorkerInfo(new Worker("http", "lhost", "lhost", 1, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost", "localhost", 1, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)new NoopTask(null, null, null, 1L, 0L, null, null, null));
        Assert.assertEquals((Object)"lhost", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testIsolation() {
        EqualDistributionWithAffinityWorkerSelectStrategy strategy = new EqualDistributionWithAffinityWorkerSelectStrategy(new AffinityConfig((Map)ImmutableMap.of((Object)"foo", (Object)ImmutableSet.of((Object)"localhost")), false));
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"localhost", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost", "localhost", 1, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)new NoopTask(null, null, null, 1L, 0L, null, null, null));
        Assert.assertNull((Object)worker);
    }

    @Test
    public void testSerde() throws Exception {
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        EqualDistributionWithAffinityWorkerSelectStrategy strategy = new EqualDistributionWithAffinityWorkerSelectStrategy(new AffinityConfig((Map)ImmutableMap.of((Object)"foo", (Object)ImmutableSet.of((Object)"localhost")), false));
        WorkerSelectStrategy strategy2 = (WorkerSelectStrategy)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)strategy), WorkerSelectStrategy.class);
        Assert.assertEquals((Object)strategy, (Object)strategy2);
    }
}

