/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.ImmutableMap;
import javax.script.ScriptEngineManager;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.TestRemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.JavaScriptWorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.WorkerSelectStrategy;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.js.JavaScriptConfig;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaScriptWorkerSelectStrategyTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final JavaScriptWorkerSelectStrategy STRATEGY = new JavaScriptWorkerSelectStrategy("function (config, zkWorkers, task) {\nvar batch_workers = new java.util.ArrayList();\nbatch_workers.add(\"10.0.0.1\");\nbatch_workers.add(\"10.0.0.2\");\nworkers = zkWorkers.keySet().toArray();\nvar sortedWorkers = new Array()\n;for (var i = 0; i < workers.length; i++) {\n sortedWorkers[i] = workers[i];\n}\nArray.prototype.sort.call(sortedWorkers,function(a, b){return zkWorkers.get(b).getCurrCapacityUsed() - zkWorkers.get(a).getCurrCapacityUsed();});\nvar minWorkerVer = config.getMinWorkerVersion();\nvar parallelIndexTaskSlotRatio = config.getParallelIndexTaskSlotRatio();\nfor (var i = 0; i < sortedWorkers.length; i++) {\n var worker = sortedWorkers[i];\n  var zkWorker = zkWorkers.get(worker);\n  if (zkWorker.canRunTask(task, parallelIndexTaskSlotRatio) && zkWorker.isValidVersion(minWorkerVer)) {\n    if (task.getType() == 'index_hadoop' && batch_workers.contains(worker)) {\n      return worker;\n    } else {\n      if (task.getType() != 'index_hadoop' && !batch_workers.contains(worker)) {\n        return worker;\n      }\n    }\n  }\n}\nreturn null;\n}", JavaScriptConfig.getEnabledInstance());

    @Before
    public void checkJdkCompatibility() {
        Assume.assumeNotNull((Object[])new Object[]{new ScriptEngineManager().getEngineByName("javascript")});
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(JavaScriptConfig.class, (Object)JavaScriptConfig.getEnabledInstance()));
        Assert.assertEquals((Object)this.STRATEGY, (Object)mapper.readValue(mapper.writeValueAsString((Object)this.STRATEGY), WorkerSelectStrategy.class));
    }

    @Test
    public void testDisabled() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(JavaScriptConfig.class, (Object)new JavaScriptConfig(false)));
        String strategyString = mapper.writeValueAsString((Object)this.STRATEGY);
        this.expectedException.expect(JsonMappingException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(IllegalStateException.class));
        this.expectedException.expectMessage("JavaScript is disabled");
        mapper.readValue(strategyString, WorkerSelectStrategy.class);
    }

    @Test
    public void testFindWorkerForTask() {
        ImmutableWorkerInfo worker1 = this.createMockWorker(1, true, true);
        ImmutableWorkerInfo worker2 = this.createMockWorker(1, true, true);
        ImmutableMap workerMap = ImmutableMap.of((Object)"10.0.0.1", (Object)worker1, (Object)"10.0.0.3", (Object)worker2);
        ImmutableWorkerInfo workerForBatchTask = this.STRATEGY.findWorkerForTask((WorkerTaskRunnerConfig)new TestRemoteTaskRunnerConfig(new Period((Object)"PT1S")), workerMap, this.createMockTask("index_hadoop"));
        Assert.assertEquals((Object)worker1, (Object)workerForBatchTask);
        ImmutableWorkerInfo workerForOtherTask = this.STRATEGY.findWorkerForTask((WorkerTaskRunnerConfig)new TestRemoteTaskRunnerConfig(new Period((Object)"PT1S")), workerMap, this.createMockTask("other_type"));
        Assert.assertEquals((Object)worker2, (Object)workerForOtherTask);
    }

    @Test
    public void testIsolationOfBatchWorker() {
        ImmutableMap workerMap = ImmutableMap.of((Object)"10.0.0.1", (Object)this.createMockWorker(1, true, true), (Object)"10.0.0.2", (Object)this.createMockWorker(1, true, true));
        ImmutableWorkerInfo workerForOtherTask = this.STRATEGY.findWorkerForTask((WorkerTaskRunnerConfig)new TestRemoteTaskRunnerConfig(new Period((Object)"PT1S")), workerMap, this.createMockTask("other_type"));
        Assert.assertNull((Object)workerForOtherTask);
    }

    @Test
    public void testNoValidWorker() {
        ImmutableMap workerMap = ImmutableMap.of((Object)"10.0.0.1", (Object)this.createMockWorker(1, true, false), (Object)"10.0.0.4", (Object)this.createMockWorker(1, true, false));
        ImmutableWorkerInfo workerForBatchTask = this.STRATEGY.findWorkerForTask((WorkerTaskRunnerConfig)new TestRemoteTaskRunnerConfig(new Period((Object)"PT1S")), workerMap, this.createMockTask("index_hadoop"));
        Assert.assertNull((Object)workerForBatchTask);
        ImmutableWorkerInfo workerForOtherTask = this.STRATEGY.findWorkerForTask((WorkerTaskRunnerConfig)new TestRemoteTaskRunnerConfig(new Period((Object)"PT1S")), workerMap, this.createMockTask("otherTask"));
        Assert.assertNull((Object)workerForOtherTask);
    }

    @Test
    public void testNoWorkerCanRunTask() {
        ImmutableMap workerMap = ImmutableMap.of((Object)"10.0.0.1", (Object)this.createMockWorker(1, false, true), (Object)"10.0.0.4", (Object)this.createMockWorker(1, false, true));
        ImmutableWorkerInfo workerForBatchTask = this.STRATEGY.findWorkerForTask((WorkerTaskRunnerConfig)new TestRemoteTaskRunnerConfig(new Period((Object)"PT1S")), workerMap, this.createMockTask("index_hadoop"));
        Assert.assertNull((Object)workerForBatchTask);
        ImmutableWorkerInfo workerForOtherTask = this.STRATEGY.findWorkerForTask((WorkerTaskRunnerConfig)new TestRemoteTaskRunnerConfig(new Period((Object)"PT1S")), workerMap, this.createMockTask("otherTask"));
        Assert.assertNull((Object)workerForOtherTask);
    }

    @Test
    public void testFillWorkerCapacity() {
        ImmutableMap workerMap = ImmutableMap.of((Object)"10.0.0.1", (Object)this.createMockWorker(1, true, true), (Object)"10.0.0.2", (Object)this.createMockWorker(5, true, true));
        ImmutableWorkerInfo workerForBatchTask = this.STRATEGY.findWorkerForTask((WorkerTaskRunnerConfig)new TestRemoteTaskRunnerConfig(new Period((Object)"PT1S")), workerMap, this.createMockTask("index_hadoop"));
        Assert.assertEquals((Object)workerMap.get((Object)"10.0.0.2"), (Object)workerForBatchTask);
    }

    private Task createMockTask(String type) {
        Task mock = (Task)EasyMock.createMock(Task.class);
        EasyMock.expect((Object)mock.getType()).andReturn((Object)type).anyTimes();
        EasyMock.replay((Object[])new Object[]{mock});
        return mock;
    }

    private ImmutableWorkerInfo createMockWorker(int currCapacityUsed, boolean canRunTask, boolean isValidVersion) {
        ImmutableWorkerInfo worker = (ImmutableWorkerInfo)EasyMock.createMock(ImmutableWorkerInfo.class);
        EasyMock.expect((Object)worker.canRunTask((Task)EasyMock.anyObject(Task.class), EasyMock.anyDouble())).andReturn((Object)canRunTask).anyTimes();
        EasyMock.expect((Object)worker.getCurrCapacityUsed()).andReturn((Object)currCapacityUsed).anyTimes();
        EasyMock.expect((Object)worker.getCurrParallelIndexCapacityUsed()).andReturn((Object)0).anyTimes();
        EasyMock.expect((Object)worker.isValidVersion(EasyMock.anyString())).andReturn((Object)isValidVersion).anyTimes();
        EasyMock.replay((Object[])new Object[]{worker});
        return worker;
    }
}

