/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.supervisor.NoopSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class SupervisorManagerTest
extends EasyMockSupport {
    @Mock
    private MetadataSupervisorManager metadataSupervisorManager;
    @Mock
    private Supervisor supervisor1;
    @Mock
    private Supervisor supervisor2;
    @Mock
    private Supervisor supervisor3;
    private SupervisorManager manager;
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() {
        this.manager = new SupervisorManager(this.metadataSupervisorManager);
    }

    @Test
    public void testCreateUpdateAndRemoveSupervisor() {
        TestSupervisorSpec spec = new TestSupervisorSpec("id1", this.supervisor1);
        TestSupervisorSpec spec2 = new TestSupervisorSpec("id1", this.supervisor2);
        ImmutableMap existingSpecs = ImmutableMap.of((Object)"id3", (Object)new TestSupervisorSpec("id3", this.supervisor3));
        Assert.assertTrue((boolean)this.manager.getSupervisorIds().isEmpty());
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)existingSpecs);
        this.metadataSupervisorManager.insert("id1", (SupervisorSpec)spec);
        this.supervisor3.start();
        this.supervisor1.start();
        this.replayAll();
        this.manager.start();
        Assert.assertEquals((long)1L, (long)this.manager.getSupervisorIds().size());
        this.manager.createOrUpdateAndStartSupervisor((SupervisorSpec)spec);
        Assert.assertEquals((long)2L, (long)this.manager.getSupervisorIds().size());
        Assert.assertEquals((Object)spec, (Object)this.manager.getSupervisorSpec("id1").get());
        this.verifyAll();
        this.resetAll();
        this.metadataSupervisorManager.insert("id1", (SupervisorSpec)spec2);
        this.supervisor2.start();
        this.supervisor1.stop(true);
        this.replayAll();
        this.manager.createOrUpdateAndStartSupervisor((SupervisorSpec)spec2);
        Assert.assertEquals((long)2L, (long)this.manager.getSupervisorIds().size());
        Assert.assertEquals((Object)spec2, (Object)this.manager.getSupervisorSpec("id1").get());
        this.verifyAll();
        this.resetAll();
        this.metadataSupervisorManager.insert((String)EasyMock.eq((Object)"id1"), (SupervisorSpec)EasyMock.anyObject(NoopSupervisorSpec.class));
        this.supervisor2.stop(true);
        this.replayAll();
        boolean retVal = this.manager.stopAndRemoveSupervisor("id1");
        Assert.assertTrue((boolean)retVal);
        Assert.assertEquals((long)1L, (long)this.manager.getSupervisorIds().size());
        Assert.assertEquals((Object)Optional.absent(), (Object)this.manager.getSupervisorSpec("id1"));
        this.verifyAll();
        this.resetAll();
        this.supervisor3.stop(false);
        this.replayAll();
        this.manager.stop();
        this.verifyAll();
        Assert.assertTrue((boolean)this.manager.getSupervisorIds().isEmpty());
    }

    @Test
    public void testCreateOrUpdateAndStartSupervisorNotStarted() {
        this.exception.expect(IllegalStateException.class);
        this.manager.createOrUpdateAndStartSupervisor((SupervisorSpec)new TestSupervisorSpec("id", null));
    }

    @Test
    public void testCreateOrUpdateAndStartSupervisorNullSpec() {
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)ImmutableMap.of());
        this.replayAll();
        this.exception.expect(NullPointerException.class);
        this.manager.start();
        this.manager.createOrUpdateAndStartSupervisor(null);
        this.verifyAll();
    }

    @Test
    public void testCreateOrUpdateAndStartSupervisorNullSpecId() {
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)ImmutableMap.of());
        this.replayAll();
        this.exception.expect(NullPointerException.class);
        this.manager.start();
        this.manager.createOrUpdateAndStartSupervisor((SupervisorSpec)new TestSupervisorSpec(null, null));
        this.verifyAll();
    }

    @Test
    public void testStopAndRemoveSupervisorNotStarted() {
        this.exception.expect(IllegalStateException.class);
        this.manager.stopAndRemoveSupervisor("id");
    }

    @Test
    public void testStopAndRemoveSupervisorNullSpecId() {
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)ImmutableMap.of());
        this.replayAll();
        this.exception.expect(NullPointerException.class);
        this.manager.start();
        this.manager.stopAndRemoveSupervisor(null);
        this.verifyAll();
    }

    @Test
    public void testGetSupervisorHistory() {
        ImmutableMap supervisorHistory = ImmutableMap.of();
        EasyMock.expect((Object)this.metadataSupervisorManager.getAll()).andReturn((Object)supervisorHistory);
        this.replayAll();
        Map history = this.manager.getSupervisorHistory();
        this.verifyAll();
        Assert.assertEquals((Object)supervisorHistory, (Object)history);
    }

    @Test
    public void testGetSupervisorHistoryForId() {
        String id = "test-supervisor-1";
        ImmutableList supervisorHistory = ImmutableList.of();
        EasyMock.expect((Object)this.metadataSupervisorManager.getAllForId(id)).andReturn((Object)supervisorHistory);
        this.replayAll();
        List history = this.manager.getSupervisorHistoryForId(id);
        this.verifyAll();
        Assert.assertEquals((Object)supervisorHistory, (Object)history);
    }

    @Test
    public void testGetSupervisorStatus() {
        SupervisorReport report = new SupervisorReport("id1", DateTimes.nowUtc(), null);
        ImmutableMap existingSpecs = ImmutableMap.of((Object)"id1", (Object)new TestSupervisorSpec("id1", this.supervisor1));
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)existingSpecs);
        this.supervisor1.start();
        EasyMock.expect((Object)this.supervisor1.getStatus()).andReturn((Object)report);
        this.replayAll();
        this.manager.start();
        Assert.assertEquals((Object)Optional.absent(), (Object)this.manager.getSupervisorStatus("non-existent-id"));
        Assert.assertEquals((Object)report, (Object)this.manager.getSupervisorStatus("id1").get());
        this.verifyAll();
    }

    @Test
    public void testStartAlreadyStarted() {
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)ImmutableMap.of());
        this.replayAll();
        this.exception.expect(IllegalStateException.class);
        this.manager.start();
        this.manager.start();
    }

    @Test
    public void testStartIndividualSupervisorsFailStart() {
        ImmutableMap existingSpecs = ImmutableMap.of((Object)"id1", (Object)new TestSupervisorSpec("id1", this.supervisor1), (Object)"id3", (Object)new TestSupervisorSpec("id3", this.supervisor3));
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)existingSpecs);
        this.supervisor3.start();
        this.supervisor1.start();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("supervisor explosion"));
        this.replayAll();
        this.manager.start();
    }

    @Test
    public void testStopThrowsException() {
        ImmutableMap existingSpecs = ImmutableMap.of((Object)"id1", (Object)new TestSupervisorSpec("id1", this.supervisor1));
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)existingSpecs);
        this.supervisor1.start();
        this.supervisor1.stop(false);
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("RTE"));
        this.replayAll();
        this.manager.start();
        this.manager.stop();
        this.verifyAll();
    }

    @Test
    public void testResetSupervisor() {
        ImmutableMap existingSpecs = ImmutableMap.of((Object)"id1", (Object)new TestSupervisorSpec("id1", this.supervisor1));
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)existingSpecs);
        this.supervisor1.start();
        this.supervisor1.reset((DataSourceMetadata)EasyMock.anyObject(DataSourceMetadata.class));
        this.replayAll();
        this.manager.start();
        Assert.assertTrue((String)"resetValidSupervisor", (boolean)this.manager.resetSupervisor("id1", null));
        Assert.assertFalse((String)"resetInvalidSupervisor", (boolean)this.manager.resetSupervisor("nobody_home", null));
        this.verifyAll();
    }

    @Test
    public void testCreateSuspendResumeAndStopSupervisor() {
        Capture capturedInsert = Capture.newInstance();
        TestSupervisorSpec spec = new TestSupervisorSpec("id1", this.supervisor1, false, this.supervisor2);
        ImmutableMap existingSpecs = ImmutableMap.of((Object)"id3", (Object)new TestSupervisorSpec("id3", this.supervisor3));
        Assert.assertTrue((boolean)this.manager.getSupervisorIds().isEmpty());
        EasyMock.expect((Object)this.metadataSupervisorManager.getLatest()).andReturn((Object)existingSpecs);
        this.metadataSupervisorManager.insert("id1", (SupervisorSpec)spec);
        this.supervisor3.start();
        this.supervisor1.start();
        this.replayAll();
        this.manager.start();
        Assert.assertEquals((long)1L, (long)this.manager.getSupervisorIds().size());
        this.manager.createOrUpdateAndStartSupervisor((SupervisorSpec)spec);
        Assert.assertEquals((long)2L, (long)this.manager.getSupervisorIds().size());
        Assert.assertEquals((Object)spec, (Object)this.manager.getSupervisorSpec("id1").get());
        this.verifyAll();
        this.resetAll();
        this.metadataSupervisorManager.insert((String)EasyMock.eq((Object)"id1"), (SupervisorSpec)EasyMock.capture((Capture)capturedInsert));
        this.supervisor2.start();
        this.supervisor1.stop(true);
        this.replayAll();
        this.manager.suspendOrResumeSupervisor("id1", true);
        Assert.assertEquals((long)2L, (long)this.manager.getSupervisorIds().size());
        Assert.assertEquals((Object)capturedInsert.getValue(), (Object)this.manager.getSupervisorSpec("id1").get());
        Assert.assertTrue((boolean)((TestSupervisorSpec)capturedInsert.getValue()).suspended);
        this.verifyAll();
        this.resetAll();
        this.metadataSupervisorManager.insert((String)EasyMock.eq((Object)"id1"), (SupervisorSpec)EasyMock.capture((Capture)capturedInsert));
        this.supervisor2.stop(true);
        this.supervisor1.start();
        this.replayAll();
        this.manager.suspendOrResumeSupervisor("id1", false);
        Assert.assertEquals((long)2L, (long)this.manager.getSupervisorIds().size());
        Assert.assertEquals((Object)capturedInsert.getValue(), (Object)this.manager.getSupervisorSpec("id1").get());
        Assert.assertFalse((boolean)((TestSupervisorSpec)capturedInsert.getValue()).suspended);
        this.verifyAll();
        this.resetAll();
        this.metadataSupervisorManager.insert((String)EasyMock.eq((Object)"id1"), (SupervisorSpec)EasyMock.anyObject(NoopSupervisorSpec.class));
        this.supervisor1.stop(true);
        this.replayAll();
        boolean retVal = this.manager.stopAndRemoveSupervisor("id1");
        Assert.assertTrue((boolean)retVal);
        Assert.assertEquals((long)1L, (long)this.manager.getSupervisorIds().size());
        Assert.assertEquals((Object)Optional.absent(), (Object)this.manager.getSupervisorSpec("id1"));
        this.verifyAll();
        this.resetAll();
        this.supervisor3.stop(false);
        this.replayAll();
        this.manager.stop();
        this.verifyAll();
        Assert.assertTrue((boolean)this.manager.getSupervisorIds().isEmpty());
    }

    private static class TestSupervisorSpec
    implements SupervisorSpec {
        private final String id;
        private final Supervisor supervisor;
        private final boolean suspended;
        private final Supervisor suspendedSupervisor;

        TestSupervisorSpec(String id, Supervisor supervisor) {
            this(id, supervisor, false, null);
        }

        TestSupervisorSpec(String id, Supervisor supervisor, boolean suspended, Supervisor suspendedSupervisor) {
            this.id = id;
            this.supervisor = supervisor;
            this.suspended = suspended;
            this.suspendedSupervisor = suspendedSupervisor;
        }

        public SupervisorSpec createSuspendedSpec() {
            return new TestSupervisorSpec(this.id, this.suspendedSupervisor, true, this.supervisor);
        }

        public SupervisorSpec createRunningSpec() {
            return new TestSupervisorSpec(this.id, this.suspendedSupervisor, false, this.supervisor);
        }

        public String getId() {
            return this.id;
        }

        public Supervisor createSupervisor() {
            return this.supervisor;
        }

        public boolean isSuspended() {
            return this.suspended;
        }

        public String getType() {
            return null;
        }

        public String getSource() {
            return null;
        }

        public List<String> getDataSources() {
            return new ArrayList<String>();
        }
    }
}

