/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class SeekableStreamEndSequenceNumbersTest {
    private static final ObjectMapper OBJECT_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String stream = "theStream";
        ImmutableMap offsetMap = ImmutableMap.of((Object)1, (Object)2L, (Object)3, (Object)4L);
        SeekableStreamEndSequenceNumbers partitions = new SeekableStreamEndSequenceNumbers("theStream", (Map)offsetMap);
        String serializedString = OBJECT_MAPPER.writeValueAsString((Object)partitions);
        SeekableStreamEndSequenceNumbers partitions2 = (SeekableStreamEndSequenceNumbers)OBJECT_MAPPER.readValue(serializedString, (TypeReference)new TypeReference<SeekableStreamEndSequenceNumbers<Integer, Long>>(){});
        Assert.assertEquals((String)"Round trip", (Object)partitions, (Object)partitions2);
        Map asMap = (Map)OBJECT_MAPPER.readValue(serializedString, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((Object)"theStream", asMap.get("stream"));
        Assert.assertEquals((Object)"theStream", asMap.get("topic"));
        Assert.assertEquals((Object)offsetMap, (Object)OBJECT_MAPPER.convertValue(asMap.get("partitionSequenceNumberMap"), (TypeReference)new TypeReference<Map<Integer, Long>>(){}));
        Assert.assertEquals((Object)offsetMap, (Object)OBJECT_MAPPER.convertValue(asMap.get("partitionOffsetMap"), (TypeReference)new TypeReference<Map<Integer, Long>>(){}));
    }

    @Test
    public void testConvertToStart() {
        String stream = "topic";
        ImmutableMap offsetMap = ImmutableMap.of((Object)1, (Object)2L, (Object)3, (Object)4L);
        SeekableStreamEndSequenceNumbers endSequenceNumbers = new SeekableStreamEndSequenceNumbers("topic", (Map)offsetMap);
        Assert.assertEquals((Object)new SeekableStreamStartSequenceNumbers("topic", (Map)offsetMap, (Set)ImmutableSet.of((Object)1, (Object)3)), (Object)endSequenceNumbers.asStartPartitions(false));
        Assert.assertEquals((Object)new SeekableStreamStartSequenceNumbers("topic", (Map)offsetMap, (Set)ImmutableSet.of()), (Object)endSequenceNumbers.asStartPartitions(true));
    }
}

