/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingCluster;
import org.apache.druid.curator.PotentiallyGzippedCompressionProvider;
import org.apache.druid.curator.ZkEnablementConfig;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.indexing.worker.WorkerCuratorCoordinator;
import org.apache.druid.indexing.worker.WorkerTaskManager;
import org.apache.druid.indexing.worker.WorkerTaskMonitor;
import org.apache.druid.indexing.worker.http.WorkerResource;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.initialization.IndexerZkConfig;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkerResourceTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final String BASE_PATH = "/test/druid";
    private static final String ANNOUNCEMENT_PATH = StringUtils.format((String)"%s/indexer/announcements/host", (Object[])new Object[]{"/test/druid"});
    private TestingCluster testingCluster;
    private CuratorFramework cf;
    private Worker worker;
    private WorkerCuratorCoordinator curatorCoordinator;
    private WorkerResource workerResource;

    @Before
    public void setUp() throws Exception {
        this.testingCluster = new TestingCluster(1);
        this.testingCluster.start();
        this.cf = CuratorFrameworkFactory.builder().connectString(this.testingCluster.getConnectString()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1, 10)).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(false)).build();
        this.cf.start();
        this.cf.blockUntilConnected();
        this.cf.create().creatingParentsIfNeeded().forPath(BASE_PATH);
        this.worker = new Worker("http", "host", "ip", 3, "v1", "_default_worker_category");
        this.curatorCoordinator = new WorkerCuratorCoordinator(JSON_MAPPER, new IndexerZkConfig(new ZkPathsConfig(){

            public String getBase() {
                return WorkerResourceTest.BASE_PATH;
            }
        }, null, null, null, null), new RemoteTaskRunnerConfig(), this.cf, this.worker);
        this.curatorCoordinator.start();
        this.workerResource = new WorkerResource(this.worker, () -> this.curatorCoordinator, null, (WorkerTaskManager)EasyMock.createNiceMock(WorkerTaskMonitor.class), ZkEnablementConfig.ENABLED);
    }

    @After
    public void tearDown() throws Exception {
        this.curatorCoordinator.stop();
        this.cf.close();
        this.testingCluster.close();
    }

    @Test
    public void testDoDisable() throws Exception {
        Worker theWorker = (Worker)JSON_MAPPER.readValue((byte[])this.cf.getData().forPath(ANNOUNCEMENT_PATH), Worker.class);
        Assert.assertEquals((Object)"v1", (Object)theWorker.getVersion());
        Response res = this.workerResource.doDisable();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)res.getStatus());
        theWorker = (Worker)JSON_MAPPER.readValue((byte[])this.cf.getData().forPath(ANNOUNCEMENT_PATH), Worker.class);
        Assert.assertTrue((boolean)theWorker.getVersion().isEmpty());
    }

    @Test
    public void testDoEnable() throws Exception {
        Response res = this.workerResource.doDisable();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)res.getStatus());
        Worker theWorker = (Worker)JSON_MAPPER.readValue((byte[])this.cf.getData().forPath(ANNOUNCEMENT_PATH), Worker.class);
        Assert.assertTrue((boolean)theWorker.getVersion().isEmpty());
        res = this.workerResource.doEnable();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)res.getStatus());
        theWorker = (Worker)JSON_MAPPER.readValue((byte[])this.cf.getData().forPath(ANNOUNCEMENT_PATH), Worker.class);
        Assert.assertEquals((Object)"v1", (Object)theWorker.getVersion());
    }
}

