/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Optional;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.indexing.worker.shuffle.ShuffleMetrics;
import org.apache.druid.indexing.worker.shuffle.ShuffleModule;
import org.apache.druid.indexing.worker.shuffle.ShuffleMonitor;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ShuffleModuleTest {
    private ShuffleModule shuffleModule;

    @Before
    public void setup() {
        this.shuffleModule = new ShuffleModule();
    }

    @Test
    public void testGetShuffleMetricsWhenShuffleMonitorExists() {
        ShuffleMonitor shuffleMonitor = new ShuffleMonitor();
        MonitorScheduler monitorScheduler = (MonitorScheduler)Mockito.mock(MonitorScheduler.class);
        Mockito.when((Object)monitorScheduler.findMonitor(ShuffleMonitor.class)).thenReturn(Optional.of(shuffleMonitor));
        Injector injector = this.createInjector(monitorScheduler);
        Optional optional = (Optional)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Optional<ShuffleMetrics>>(){}));
        Assert.assertTrue((boolean)optional.isPresent());
    }

    @Test
    public void testGetShuffleMetricsWithNoShuffleMonitor() {
        MonitorScheduler monitorScheduler = (MonitorScheduler)Mockito.mock(MonitorScheduler.class);
        Mockito.when((Object)monitorScheduler.findMonitor((Class)ArgumentMatchers.eq(ShuffleMonitor.class))).thenReturn(Optional.empty());
        Injector injector = this.createInjector(monitorScheduler);
        Optional optional = (Optional)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Optional<ShuffleMetrics>>(){}));
        Assert.assertFalse((boolean)optional.isPresent());
    }

    private Injector createInjector(MonitorScheduler monitorScheduler) {
        return Guice.createInjector((Module[])new Module[]{binder -> {
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
            binder.bind(MonitorScheduler.class).toInstance((Object)monitorScheduler);
            binder.bind(IntermediaryDataManager.class).toInstance(Mockito.mock(IntermediaryDataManager.class));
        }, this.shuffleModule});
    }
}

