/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.LockRequestForNewSegment;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.joda.time.chrono.ISOChronology;

public class SegmentAllocateAction
implements TaskAction<SegmentIdWithShardSpec> {
    public static final String TYPE = "segmentAllocate";
    private static final Logger log = new Logger(SegmentAllocateAction.class);
    private static final int MAX_ATTEMPTS = 90;
    private final String dataSource;
    private final DateTime timestamp;
    private final Granularity queryGranularity;
    private final Granularity preferredSegmentGranularity;
    private final String sequenceName;
    private final String previousSegmentId;
    private final boolean skipSegmentLineageCheck;
    private final PartialShardSpec partialShardSpec;
    private final LockGranularity lockGranularity;
    private final TaskLockType taskLockType;

    @JsonCreator
    public SegmentAllocateAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="queryGranularity") Granularity queryGranularity, @JsonProperty(value="preferredSegmentGranularity") Granularity preferredSegmentGranularity, @JsonProperty(value="sequenceName") String sequenceName, @JsonProperty(value="previousSegmentId") String previousSegmentId, @JsonProperty(value="skipSegmentLineageCheck") boolean skipSegmentLineageCheck, @JsonProperty(value="shardSpecFactory") @Nullable PartialShardSpec partialShardSpec, @JsonProperty(value="lockGranularity") @Nullable LockGranularity lockGranularity, @JsonProperty(value="taskLockType") @Nullable TaskLockType taskLockType) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.timestamp = (DateTime)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.queryGranularity = (Granularity)Preconditions.checkNotNull((Object)queryGranularity, (Object)"queryGranularity");
        this.preferredSegmentGranularity = (Granularity)Preconditions.checkNotNull((Object)preferredSegmentGranularity, (Object)"preferredSegmentGranularity");
        this.sequenceName = (String)Preconditions.checkNotNull((Object)sequenceName, (Object)"sequenceName");
        this.previousSegmentId = previousSegmentId;
        this.skipSegmentLineageCheck = skipSegmentLineageCheck;
        this.partialShardSpec = partialShardSpec == null ? NumberedPartialShardSpec.instance() : partialShardSpec;
        this.lockGranularity = lockGranularity == null ? LockGranularity.TIME_CHUNK : lockGranularity;
        this.taskLockType = taskLockType == null ? TaskLockType.EXCLUSIVE : taskLockType;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @JsonProperty
    public Granularity getPreferredSegmentGranularity() {
        return this.preferredSegmentGranularity;
    }

    @JsonProperty
    public String getSequenceName() {
        return this.sequenceName;
    }

    @JsonProperty
    public String getPreviousSegmentId() {
        return this.previousSegmentId;
    }

    @JsonProperty
    public boolean isSkipSegmentLineageCheck() {
        return this.skipSegmentLineageCheck;
    }

    @JsonProperty(value="shardSpecFactory")
    public PartialShardSpec getPartialShardSpec() {
        return this.partialShardSpec;
    }

    @JsonProperty
    public LockGranularity getLockGranularity() {
        return this.lockGranularity;
    }

    @JsonProperty
    public TaskLockType getTaskLockType() {
        return this.taskLockType;
    }

    @Override
    public TypeReference<SegmentIdWithShardSpec> getReturnTypeReference() {
        return new TypeReference<SegmentIdWithShardSpec>(){};
    }

    @Override
    public SegmentIdWithShardSpec perform(Task task, TaskActionToolbox toolbox) {
        block5: {
            Interval rowInterval;
            int attempt = 0;
            while (true) {
                ++attempt;
                if (!task.getDataSource().equals(this.dataSource)) {
                    throw new IAE("Task dataSource must match action dataSource, [%s] != [%s].", new Object[]{task.getDataSource(), this.dataSource});
                }
                IndexerMetadataStorageCoordinator msc = toolbox.getIndexerMetadataStorageCoordinator();
                HashSet usedSegmentsForRow = new HashSet(msc.retrieveUsedSegmentsForInterval(this.dataSource, rowInterval = this.queryGranularity.bucket(this.timestamp).withChronology((Chronology)ISOChronology.getInstanceUTC()), Segments.ONLY_VISIBLE));
                SegmentIdWithShardSpec identifier = usedSegmentsForRow.isEmpty() ? this.tryAllocateFirstSegment(toolbox, task, rowInterval) : this.tryAllocateSubsequentSegment(toolbox, task, rowInterval, (DataSegment)usedSegmentsForRow.iterator().next());
                if (identifier != null) {
                    return identifier;
                }
                HashSet newUsedSegmentsForRow = new HashSet(msc.retrieveUsedSegmentsForInterval(this.dataSource, rowInterval, Segments.ONLY_VISIBLE));
                if (newUsedSegmentsForRow.equals(usedSegmentsForRow)) break block5;
                if (attempt >= 90) break;
                long shortRandomSleep = 50L + (long)(ThreadLocalRandom.current().nextDouble() * 450.0);
                log.debug("Used segment set changed for rowInterval[%s]. Retrying segment allocation in %,dms (attempt = %,d).", new Object[]{rowInterval, shortRandomSleep, attempt});
                try {
                    Thread.sleep(shortRandomSleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            log.error("Used segment set changed for rowInterval[%s]. Not trying again (attempt = %,d).", new Object[]{rowInterval, attempt});
            return null;
        }
        return null;
    }

    private SegmentIdWithShardSpec tryAllocateFirstSegment(TaskActionToolbox toolbox, Task task, Interval rowInterval) {
        List tryIntervals = Granularity.granularitiesFinerThan((Granularity)this.preferredSegmentGranularity).stream().map(granularity -> granularity.bucket(this.timestamp)).collect(Collectors.toList());
        for (Interval tryInterval : tryIntervals) {
            SegmentIdWithShardSpec identifier;
            if (!tryInterval.contains((ReadableInterval)rowInterval) || (identifier = this.tryAllocate(toolbox, task, tryInterval, rowInterval, false)) == null) continue;
            return identifier;
        }
        return null;
    }

    private SegmentIdWithShardSpec tryAllocateSubsequentSegment(TaskActionToolbox toolbox, Task task, Interval rowInterval, DataSegment usedSegment) {
        if (!usedSegment.getInterval().contains((ReadableInterval)rowInterval)) {
            log.error("The interval of existing segment[%s] doesn't contain rowInterval[%s]", new Object[]{usedSegment.getId(), rowInterval});
            return null;
        }
        return this.tryAllocate(toolbox, task, usedSegment.getInterval(), rowInterval, true);
    }

    private SegmentIdWithShardSpec tryAllocate(TaskActionToolbox toolbox, Task task, Interval tryInterval, Interval rowInterval, boolean logOnFail) {
        LockResult lockResult = toolbox.getTaskLockbox().tryLock(task, new LockRequestForNewSegment(this.lockGranularity, this.taskLockType, task.getGroupId(), this.dataSource, tryInterval, this.partialShardSpec, task.getPriority(), this.sequenceName, this.previousSegmentId, this.skipSegmentLineageCheck));
        if (lockResult.isRevoked()) {
            throw new ISE("The lock for interval[%s] is preempted and no longer valid", new Object[]{tryInterval});
        }
        if (lockResult.isOk()) {
            SegmentIdWithShardSpec identifier = lockResult.getNewSegmentId();
            if (identifier != null) {
                return identifier;
            }
            String msg = StringUtils.format((String)"Could not allocate pending segment for rowInterval[%s], segmentInterval[%s].", (Object[])new Object[]{rowInterval, tryInterval});
            if (logOnFail) {
                log.error(msg, new Object[0]);
            } else {
                log.debug(msg, new Object[0]);
            }
            return null;
        }
        String msg = StringUtils.format((String)"Could not acquire lock for rowInterval[%s], segmentInterval[%s].", (Object[])new Object[]{rowInterval, tryInterval});
        if (logOnFail) {
            log.error(msg, new Object[0]);
        } else {
            log.debug(msg, new Object[0]);
        }
        return null;
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    @Override
    public String toString() {
        return "SegmentAllocateAction{dataSource='" + this.dataSource + '\'' + ", timestamp=" + this.timestamp + ", queryGranularity=" + this.queryGranularity + ", preferredSegmentGranularity=" + this.preferredSegmentGranularity + ", sequenceName='" + this.sequenceName + '\'' + ", previousSegmentId='" + this.previousSegmentId + '\'' + ", skipSegmentLineageCheck=" + this.skipSegmentLineageCheck + ", partialShardSpec=" + this.partialShardSpec + ", lockGranularity=" + (Object)((Object)this.lockGranularity) + '}';
    }
}

