/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.actions.SegmentInsertAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.metadata.TaskLookup;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class TaskStorageQueryAdapter {
    private final TaskStorage storage;
    private final TaskLockbox taskLockbox;

    @Inject
    public TaskStorageQueryAdapter(TaskStorage storage, TaskLockbox taskLockbox) {
        this.storage = storage;
        this.taskLockbox = taskLockbox;
    }

    public List<Task> getActiveTasks() {
        return this.storage.getActiveTasks();
    }

    public Map<String, List<Interval>> getLockedIntervals(Map<String, Integer> minTaskPriority) {
        return this.taskLockbox.getLockedIntervals(minTaskPriority);
    }

    public List<TaskInfo<Task, TaskStatus>> getActiveTaskInfo(@Nullable String dataSource) {
        return this.storage.getTaskInfos((TaskLookup)TaskLookup.ActiveTaskLookup.getInstance(), dataSource);
    }

    public List<TaskStatusPlus> getTaskStatusPlusList(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String dataSource) {
        return this.storage.getTaskStatusPlusList(taskLookups, dataSource);
    }

    public Optional<Task> getTask(String taskid) {
        return this.storage.getTask(taskid);
    }

    public Optional<TaskStatus> getStatus(String taskid) {
        return this.storage.getStatus(taskid);
    }

    @Nullable
    public TaskInfo<Task, TaskStatus> getTaskInfo(String taskId) {
        return this.storage.getTaskInfo(taskId);
    }

    @Deprecated
    public Set<DataSegment> getInsertedSegments(String taskid) {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (TaskAction action : this.storage.getAuditLogs(taskid)) {
            if (action instanceof SegmentInsertAction) {
                segments.addAll(((SegmentInsertAction)action).getSegments());
                continue;
            }
            if (!(action instanceof SegmentTransactionalInsertAction)) continue;
            segments.addAll(((SegmentTransactionalInsertAction)action).getSegments());
        }
        return segments;
    }
}

