/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http.security;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.http.security.AbstractResourceFilter;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;

public class SupervisorResourceFilter
extends AbstractResourceFilter {
    private final SupervisorManager supervisorManager;

    @Inject
    public SupervisorResourceFilter(AuthorizerMapper authorizerMapper, SupervisorManager supervisorManager) {
        super(authorizerMapper);
        this.supervisorManager = supervisorManager;
    }

    public ContainerRequest filter(ContainerRequest request) {
        String supervisorId = (String)Preconditions.checkNotNull((Object)((PathSegment)request.getPathSegments().get(Iterables.indexOf((Iterable)request.getPathSegments(), (Predicate)new Predicate<PathSegment>(){

            public boolean apply(PathSegment input) {
                return "supervisor".equals(input.getPath());
            }
        }) + 1)).getPath());
        Optional<SupervisorSpec> supervisorSpecOptional = this.supervisorManager.getSupervisorSpec(supervisorId);
        if (!supervisorSpecOptional.isPresent()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)StringUtils.format((String)"Cannot find any supervisor with id: [%s]", (Object[])new Object[]{supervisorId})).build());
        }
        SupervisorSpec spec = (SupervisorSpec)supervisorSpecOptional.get();
        Preconditions.checkArgument((spec.getDataSources() != null && spec.getDataSources().size() > 0 ? 1 : 0) != 0, (Object)"No dataSources found to perform authorization checks");
        Function resourceActionFunction = this.getAction(request) == Action.READ ? AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR : AuthorizationUtils.DATASOURCE_WRITE_RA_GENERATOR;
        Access authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)this.getReq(), (Iterable)Iterables.transform((Iterable)spec.getDataSources(), (Function)resourceActionFunction), (AuthorizerMapper)this.getAuthorizerMapper());
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        return request;
    }
}

