/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http.security;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskStorageQueryAdapter;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.http.security.AbstractResourceFilter;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;

public class TaskResourceFilter
extends AbstractResourceFilter {
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;

    @Inject
    public TaskResourceFilter(TaskStorageQueryAdapter taskStorageQueryAdapter, AuthorizerMapper authorizerMapper) {
        super(authorizerMapper);
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
    }

    public ContainerRequest filter(ContainerRequest request) {
        String taskId = (String)Preconditions.checkNotNull((Object)((PathSegment)request.getPathSegments().get(Iterables.indexOf((Iterable)request.getPathSegments(), input -> "task".equals(input.getPath())) + 1)).getPath());
        IdUtils.validateId((String)"taskId", (String)taskId);
        Optional<Task> taskOptional = this.taskStorageQueryAdapter.getTask(taskId);
        if (!taskOptional.isPresent()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)StringUtils.format((String)"Cannot find any task with id: [%s]", (Object[])new Object[]{taskId})).build());
        }
        String dataSourceName = (String)Preconditions.checkNotNull((Object)((Task)taskOptional.get()).getDataSource());
        ResourceAction resourceAction = new ResourceAction(new Resource(dataSourceName, "DATASOURCE"), this.getAction(request));
        Access authResult = AuthorizationUtils.authorizeResourceAction((HttpServletRequest)this.getReq(), (ResourceAction)resourceAction, (AuthorizerMapper)this.getAuthorizerMapper());
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        return request;
    }
}

