/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.TestHelper;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class RetrieveUsedSegmentsActionSerdeTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSingleIntervalSerde() throws Exception {
        Interval interval = Intervals.of((String)"2014/2015");
        RetrieveUsedSegmentsAction expected = new RetrieveUsedSegmentsAction("dataSource", interval, null, Segments.ONLY_VISIBLE);
        RetrieveUsedSegmentsAction actual = (RetrieveUsedSegmentsAction)MAPPER.readValue(MAPPER.writeValueAsString((Object)expected), RetrieveUsedSegmentsAction.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)interval), (Object)actual.getIntervals());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMultiIntervalSerde() throws Exception {
        ImmutableList intervals = ImmutableList.of((Object)Intervals.of((String)"2014/2015"), (Object)Intervals.of((String)"2016/2017"));
        RetrieveUsedSegmentsAction expected = new RetrieveUsedSegmentsAction("dataSource", null, (Collection)intervals, Segments.ONLY_VISIBLE);
        RetrieveUsedSegmentsAction actual = (RetrieveUsedSegmentsAction)MAPPER.readValue(MAPPER.writeValueAsString((Object)expected), RetrieveUsedSegmentsAction.class);
        Assert.assertEquals((Object)intervals, (Object)actual.getIntervals());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOldJsonDeserialization() throws Exception {
        String jsonStr = "{\"type\": \"segmentListUsed\", \"dataSource\": \"test\", \"interval\": \"2014/2015\"}";
        RetrieveUsedSegmentsAction actual = (RetrieveUsedSegmentsAction)MAPPER.readValue(jsonStr, TaskAction.class);
        Assert.assertEquals((Object)new RetrieveUsedSegmentsAction("test", Intervals.of((String)"2014/2015"), null, Segments.ONLY_VISIBLE), (Object)actual);
    }
}

