/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskActionTestKit;
import org.apache.druid.indexing.common.actions.TimeChunkLockAcquireAction;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TimeChunkLockAcquireActionTest {
    @Rule
    public TaskActionTestKit actionTestKit = new TaskActionTestKit();
    private final ObjectMapper mapper = new DefaultObjectMapper();

    @Test
    public void testSerdeWithAllFields() throws IOException {
        TimeChunkLockAcquireAction expected = new TimeChunkLockAcquireAction(TaskLockType.SHARED, Intervals.of((String)"2017-01-01/2017-01-02"), 1000L);
        byte[] bytes = this.mapper.writeValueAsBytes((Object)expected);
        TimeChunkLockAcquireAction actual = (TimeChunkLockAcquireAction)this.mapper.readValue(bytes, TimeChunkLockAcquireAction.class);
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((Object)expected.getInterval(), (Object)actual.getInterval());
        Assert.assertEquals((long)expected.getTimeoutMs(), (long)actual.getTimeoutMs());
    }

    @Test
    public void testSerdeFromJsonWithMissingFields() throws IOException {
        String json = "{ \"type\": \"lockAcquire\", \"interval\" : \"2017-01-01/2017-01-02\" }";
        TimeChunkLockAcquireAction actual = (TimeChunkLockAcquireAction)this.mapper.readValue("{ \"type\": \"lockAcquire\", \"interval\" : \"2017-01-01/2017-01-02\" }", TimeChunkLockAcquireAction.class);
        TimeChunkLockAcquireAction expected = new TimeChunkLockAcquireAction(TaskLockType.EXCLUSIVE, Intervals.of((String)"2017-01-01/2017-01-02"), 0L);
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((Object)expected.getInterval(), (Object)actual.getInterval());
        Assert.assertEquals((long)expected.getTimeoutMs(), (long)actual.getTimeoutMs());
    }

    @Test(timeout=60000L)
    public void testWithLockType() {
        NoopTask task = NoopTask.create();
        TimeChunkLockAcquireAction action = new TimeChunkLockAcquireAction(TaskLockType.EXCLUSIVE, Intervals.of((String)"2017-01-01/2017-01-02"), 1000L);
        this.actionTestKit.getTaskLockbox().add((Task)task);
        TaskLock lock = action.perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertNotNull((Object)lock);
    }

    @Test(timeout=60000L)
    public void testWithoutLockType() {
        NoopTask task = NoopTask.create();
        TimeChunkLockAcquireAction action = new TimeChunkLockAcquireAction(null, Intervals.of((String)"2017-01-01/2017-01-02"), 1000L);
        this.actionTestKit.getTaskLockbox().add((Task)task);
        TaskLock lock = action.perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertNotNull((Object)lock);
    }
}

