/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskActionTestKit;
import org.apache.druid.indexing.common.actions.TimeChunkLockTryAcquireAction;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TimeChunkLockTryAcquireActionTest {
    @Rule
    public TaskActionTestKit actionTestKit = new TaskActionTestKit();
    private final ObjectMapper mapper = new DefaultObjectMapper();

    @Test
    public void testSerdeWithAllFields() throws IOException {
        TimeChunkLockTryAcquireAction expected = new TimeChunkLockTryAcquireAction(TaskLockType.SHARED, Intervals.of((String)"2017-01-01/2017-01-02"));
        byte[] bytes = this.mapper.writeValueAsBytes((Object)expected);
        TimeChunkLockTryAcquireAction actual = (TimeChunkLockTryAcquireAction)this.mapper.readValue(bytes, TimeChunkLockTryAcquireAction.class);
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((Object)expected.getInterval(), (Object)actual.getInterval());
    }

    @Test
    public void testSerdeFromJsonWithMissingFields() throws IOException {
        String json = "{ \"type\": \"lockTryAcquire\", \"interval\" : \"2017-01-01/2017-01-02\" }";
        TimeChunkLockTryAcquireAction actual = (TimeChunkLockTryAcquireAction)this.mapper.readValue("{ \"type\": \"lockTryAcquire\", \"interval\" : \"2017-01-01/2017-01-02\" }", TimeChunkLockTryAcquireAction.class);
        TimeChunkLockTryAcquireAction expected = new TimeChunkLockTryAcquireAction(TaskLockType.EXCLUSIVE, Intervals.of((String)"2017-01-01/2017-01-02"));
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((Object)expected.getInterval(), (Object)actual.getInterval());
    }

    @Test(timeout=60000L)
    public void testWithLockType() {
        NoopTask task = NoopTask.create();
        TimeChunkLockTryAcquireAction action = new TimeChunkLockTryAcquireAction(TaskLockType.EXCLUSIVE, Intervals.of((String)"2017-01-01/2017-01-02"));
        this.actionTestKit.getTaskLockbox().add((Task)task);
        TaskLock lock = action.perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertNotNull((Object)lock);
    }

    @Test(timeout=60000L)
    public void testWithoutLockType() {
        NoopTask task = NoopTask.create();
        TimeChunkLockTryAcquireAction action = new TimeChunkLockTryAcquireAction(null, Intervals.of((String)"2017-01-01/2017-01-02"));
        this.actionTestKit.getTaskLockbox().add((Task)task);
        TaskLock lock = action.perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertNotNull((Object)lock);
    }
}

