/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.IOException;
import org.apache.druid.client.indexing.ClientKillUnusedSegmentsTaskQuery;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.indexing.common.task.KillUnusedSegmentsTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientKillUnusedSegmentsTaskQuerySerdeTest {
    private ObjectMapper objectMapper;

    @Before
    public void setup() {
        this.objectMapper = new DefaultObjectMapper();
        this.objectMapper.registerSubtypes(new NamedType[]{new NamedType(ClientKillUnusedSegmentsTaskQuery.class, "kill")});
    }

    @Test
    public void testClientKillUnusedSegmentsTaskQueryToKillUnusedSegmentsTask() throws IOException {
        ClientKillUnusedSegmentsTaskQuery taskQuery = new ClientKillUnusedSegmentsTaskQuery("killTaskId", "datasource", Intervals.of((String)"2020-01-01/P1D"), Boolean.valueOf(true));
        byte[] json = this.objectMapper.writeValueAsBytes((Object)taskQuery);
        KillUnusedSegmentsTask fromJson = (KillUnusedSegmentsTask)this.objectMapper.readValue(json, Task.class);
        Assert.assertEquals((Object)taskQuery.getId(), (Object)fromJson.getId());
        Assert.assertEquals((Object)taskQuery.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((Object)taskQuery.getInterval(), (Object)fromJson.getInterval());
        Assert.assertEquals((Object)taskQuery.getMarkAsUnused(), (Object)fromJson.isMarkAsUnused());
    }

    @Test
    public void testKillUnusedSegmentsTaskToClientKillUnusedSegmentsTaskQuery() throws IOException {
        KillUnusedSegmentsTask task = new KillUnusedSegmentsTask(null, "datasource", Intervals.of((String)"2020-01-01/P1D"), null, Boolean.valueOf(true));
        byte[] json = this.objectMapper.writeValueAsBytes((Object)task);
        ClientKillUnusedSegmentsTaskQuery taskQuery = (ClientKillUnusedSegmentsTaskQuery)this.objectMapper.readValue(json, ClientTaskQuery.class);
        Assert.assertEquals((Object)task.getId(), (Object)taskQuery.getId());
        Assert.assertEquals((Object)task.getDataSource(), (Object)taskQuery.getDataSource());
        Assert.assertEquals((Object)task.getInterval(), (Object)taskQuery.getInterval());
        Assert.assertEquals((Object)task.isMarkAsUnused(), (Object)taskQuery.getMarkAsUnused());
    }
}

