/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.indexing.common.task.CompactionIntervalSpec;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.IndexTaskTest;
import org.apache.druid.indexing.common.task.IngestionTestBase;
import org.apache.druid.indexing.common.task.NoopTestTaskReportFileWriter;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.firehose.IngestSegmentFirehoseFactory;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.druid.segment.loading.LocalDataSegmentPusher;
import org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.druid.segment.loading.NoopDataSegmentKiller;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.loading.TombstoneLoadSpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompactionTaskRunTest
extends IngestionTestBase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    public static final ParseSpec DEFAULT_PARSE_SPEC = new CSVParseSpec(new TimestampSpec("ts", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim"))), "|", Arrays.asList("ts", "dim", "val"), false, 0);
    private static final List<String> TEST_ROWS = ImmutableList.of((Object)"2014-01-01T00:00:10Z,a,1\n", (Object)"2014-01-01T00:00:10Z,b,2\n", (Object)"2014-01-01T00:00:10Z,c,3\n", (Object)"2014-01-01T01:00:20Z,a,1\n", (Object)"2014-01-01T01:00:20Z,b,2\n", (Object)"2014-01-01T01:00:20Z,c,3\n", (Object)"2014-01-01T02:00:30Z,a,1\n", (Object)"2014-01-01T02:00:30Z,b,2\n", (Object)"2014-01-01T02:00:30Z,c,3\n", (Object)"2014-01-01T02:00:30Z,c|d|e,3\n");
    private static final String DATA_SOURCE = "test";
    private static final RetryPolicyFactory RETRY_POLICY_FACTORY = new RetryPolicyFactory(new RetryPolicyConfig());
    private final OverlordClient overlordClient;
    private final CoordinatorClient coordinatorClient;
    private final SegmentCacheManagerFactory segmentCacheManagerFactory;
    private final LockGranularity lockGranularity;
    private final TestUtils testUtils = new TestUtils();
    private ExecutorService exec;
    private File localDeepStorage;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{LockGranularity.TIME_CHUNK}, (Object)new Object[]{LockGranularity.SEGMENT});
    }

    public CompactionTaskRunTest(LockGranularity lockGranularity) {
        this.overlordClient = new NoopOverlordClient();
        this.coordinatorClient = new CoordinatorClient(null, null){

            public Collection<DataSegment> fetchUsedSegmentsInDataSourceForIntervals(String dataSource, List<Interval> intervals) {
                return CompactionTaskRunTest.this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(dataSource, intervals, Segments.ONLY_VISIBLE);
            }
        };
        this.segmentCacheManagerFactory = new SegmentCacheManagerFactory(this.getObjectMapper());
        this.lockGranularity = lockGranularity;
    }

    public static CompactionState getDefaultCompactionState(Granularity segmentGranularity, Granularity queryGranularity, List<Interval> intervals) throws JsonProcessingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
        expectedLongSumMetric.put("type", "longSum");
        expectedLongSumMetric.put("name", "val");
        expectedLongSumMetric.put("fieldName", "val");
        return new CompactionState((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(5000000), Long.valueOf(Long.MAX_VALUE)), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), null, (Map)mapper.readValue(mapper.writeValueAsString((Object)new IndexSpec()), Map.class), (Map)mapper.readValue(mapper.writeValueAsString((Object)new UniformGranularitySpec(segmentGranularity, queryGranularity, Boolean.valueOf(true), intervals)), Map.class));
    }

    @Before
    public void setup() throws IOException {
        this.exec = Execs.multiThreaded((int)2, (String)"compaction-task-run-test-%d");
        this.localDeepStorage = this.temporaryFolder.newFolder();
    }

    @After
    public void teardown() {
        this.exec.shutdownNow();
        this.temporaryFolder.delete();
    }

    @Test
    public void testRunWithDynamicPartitioning() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.HOUR, Granularities.MINUTE, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}))), (Object)((DataSegment)segments.get(i)).getLastCompactionState());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedOverwriteShardSpec(32768, 0, 2, 1, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
        List<String> rowsFromSegment = this.getCSVFormatRowsFromSegments(segments);
        Assert.assertEquals(TEST_ROWS, rowsFromSegment);
    }

    @Test
    public void testRunWithHashPartitioning() throws Exception {
        if (this.lockGranularity == LockGranularity.SEGMENT) {
            return;
        }
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).tuningConfig((TuningConfig)new ParallelIndexTuningConfig(null, null, null, null, null, null, null, null, null, (PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(3), null), null, null, null, Boolean.valueOf(true), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)6L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            Interval interval = Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1});
            for (int j = 0; j < 2; ++j) {
                int segmentIdx = i * 2 + j;
                Assert.assertEquals((Object)interval, (Object)((DataSegment)segments.get(segmentIdx)).getInterval());
                HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
                expectedLongSumMetric.put("type", "longSum");
                expectedLongSumMetric.put("name", "val");
                expectedLongSumMetric.put("fieldName", "val");
                CompactionState expectedState = new CompactionState((PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(3), null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), null, compactionTask.getTuningConfig().getIndexSpec().asMap(this.getObjectMapper()), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1})))), Map.class));
                Assert.assertEquals((Object)expectedState, (Object)((DataSegment)segments.get(segmentIdx)).getLastCompactionState());
                Assert.assertSame(HashBasedNumberedShardSpec.class, ((DataSegment)segments.get(segmentIdx)).getShardSpec().getClass());
            }
        }
        List<String> rowsFromSegment = this.getCSVFormatRowsFromSegments(segments);
        rowsFromSegment.sort((Comparator<String>)Ordering.natural());
        Assert.assertEquals(TEST_ROWS, rowsFromSegment);
    }

    @Test
    public void testRunCompactionTwice() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask1 = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask1);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.HOUR, Granularities.MINUTE, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}))), (Object)((DataSegment)segments.get(i)).getLastCompactionState());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedOverwriteShardSpec(32768, 0, 2, 1, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
        CompactionTask compactionTask2 = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).build();
        resultPair = this.runTask((Task)compactionTask2);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        segments = (List)resultPair.rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.HOUR, Granularities.MINUTE, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}))), (Object)((DataSegment)segments.get(i)).getLastCompactionState());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedOverwriteShardSpec(32769, 0, 2, 2, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
    }

    @Test
    public void testRunIndexAndCompactAtTheSameTimeForDifferentInterval() throws Exception {
        int i;
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.interval(Intervals.of((String)"2014-01-01T00:00:00/2014-01-02T03:00:00")).build();
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T03:00:10Z,a,1\n");
            writer.write("2014-01-01T03:00:10Z,b,2\n");
            writer.write("2014-01-01T03:00:10Z,c,3\n");
            writer.write("2014-01-01T04:00:20Z,a,1\n");
            writer.write("2014-01-01T04:00:20Z,b,2\n");
            writer.write("2014-01-01T04:00:20Z,c,3\n");
            writer.write("2014-01-01T05:00:30Z,a,1\n");
            writer.write("2014-01-01T05:00:30Z,b,2\n");
            writer.write("2014-01-01T05:00:30Z,c,3\n");
        }
        IndexTask indexTask = new IndexTask(null, null, IndexTaskTest.createIngestionSpec(this.getObjectMapper(), tmpDir, DEFAULT_PARSE_SPEC, null, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), IndexTaskTest.createTuningConfig(2, 2, null, 2L, null, false, true), false, false), null);
        Future<Pair> compactionFuture = this.exec.submit(() -> this.runTask((Task)compactionTask));
        Future<Pair> indexFuture = this.exec.submit(() -> this.runTask((Task)indexTask));
        Assert.assertTrue((boolean)((TaskStatus)indexFuture.get().lhs).isSuccess());
        List segments = (List)indexFuture.get().rhs;
        Assert.assertEquals((long)6L, (long)segments.size());
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{3 + i / 2, 3 + i / 2 + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedShardSpec(i % 2, 0), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(i % 2, 2), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
        Assert.assertTrue((boolean)((TaskStatus)compactionFuture.get().lhs).isSuccess());
        segments = (List)compactionFuture.get().rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.HOUR, Granularities.MINUTE, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}))), (Object)((DataSegment)segments.get(i)).getLastCompactionState());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedOverwriteShardSpec(32768, 0, 2, 1, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
    }

    @Test
    public void testWithSegmentGranularity() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask1 = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).segmentGranularity(Granularities.DAY).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask1);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01/2014-01-02"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(0)).getShardSpec());
        Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.DAY, Granularities.MINUTE, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T00:00:00/2014-01-01T03:00:00"))), (Object)((DataSegment)segments.get(0)).getLastCompactionState());
        CompactionTask compactionTask2 = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).segmentGranularity(Granularities.HOUR).build();
        resultPair = this.runTask((Task)compactionTask2);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        segments = (List)resultPair.rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
            Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.HOUR, Granularities.MINUTE, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01/2014-01-02"))), (Object)((DataSegment)segments.get(i)).getLastCompactionState());
        }
    }

    @Test
    public void testCompactionWithFilterInTransformSpec() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.DAY, null, null)).transformSpec(new ClientCompactionTaskTransformSpec((DimFilter)new SelectorDimFilter("dim", "a", null))).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01/2014-01-02"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(0)).getShardSpec());
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
        expectedLongSumMetric.put("type", "longSum");
        expectedLongSumMetric.put("name", "val");
        expectedLongSumMetric.put("fieldName", "val");
        CompactionState expectedCompactionState = new CompactionState((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(5000000), Long.valueOf(Long.MAX_VALUE)), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)compactionTask.getTransformSpec()), Map.class), (Map)mapper.readValue(mapper.writeValueAsString((Object)new IndexSpec()), Map.class), (Map)mapper.readValue(mapper.writeValueAsString((Object)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T00:00:00/2014-01-01T03:00:00")))), Map.class));
        Assert.assertEquals((Object)expectedCompactionState, (Object)((DataSegment)segments.get(0)).getLastCompactionState());
    }

    @Test
    public void testCompactionWithNewMetricInMetricsSpec() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.DAY, null, null)).metricsSpec(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new LongSumAggregatorFactory("val", "val")}).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01/2014-01-02"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(0)).getShardSpec());
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        HashMap<String, String> expectedCountMetric = new HashMap<String, String>();
        expectedCountMetric.put("type", "count");
        expectedCountMetric.put("name", "cnt");
        HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
        expectedLongSumMetric.put("type", "longSum");
        expectedLongSumMetric.put("name", "val");
        expectedLongSumMetric.put("fieldName", "val");
        CompactionState expectedCompactionState = new CompactionState((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(5000000), Long.valueOf(Long.MAX_VALUE)), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedCountMetric, expectedLongSumMetric), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)compactionTask.getTransformSpec()), Map.class), (Map)mapper.readValue(mapper.writeValueAsString((Object)new IndexSpec()), Map.class), (Map)mapper.readValue(mapper.writeValueAsString((Object)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T00:00:00/2014-01-01T03:00:00")))), Map.class));
        Assert.assertEquals((Object)expectedCompactionState, (Object)((DataSegment)segments.get(0)).getLastCompactionState());
    }

    @Test
    public void testWithGranularitySpecNonNullSegmentGranularityAndNullQueryGranularity() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask1 = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.DAY, null, null)).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask1);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01/2014-01-02"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(0)).getShardSpec());
        Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.DAY, Granularities.MINUTE, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T00:00:00/2014-01-01T03:00:00"))), (Object)((DataSegment)segments.get(0)).getLastCompactionState());
        CompactionTask compactionTask2 = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.HOUR, null, null)).build();
        resultPair = this.runTask((Task)compactionTask2);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        segments = (List)resultPair.rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
            Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.HOUR, Granularities.MINUTE, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01/2014-01-02"))), (Object)((DataSegment)segments.get(i)).getLastCompactionState());
        }
    }

    @Test
    public void testWithGranularitySpecNonNullQueryGranularityAndNullSegmentGranularity() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask1 = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).granularitySpec(new ClientCompactionTaskGranularitySpec(null, Granularities.SECOND, null)).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask1);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.HOUR, Granularities.SECOND, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}))), (Object)((DataSegment)segments.get(i)).getLastCompactionState());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedOverwriteShardSpec(32768, 0, 2, 1, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
    }

    @Test
    public void testWithGranularitySpecNonNullQueryGranularityAndNonNullSegmentGranularity() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask1 = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.DAY, Granularities.DAY, null)).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask1);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01/2014-01-02"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(0)).getShardSpec());
        Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.DAY, Granularities.DAY, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T00:00:00/2014-01-01T03:00:00"))), (Object)((DataSegment)segments.get(0)).getLastCompactionState());
    }

    @Test
    public void testWithGranularitySpecNullQueryGranularityAndNullSegmentGranularity() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask1 = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).granularitySpec(new ClientCompactionTaskGranularitySpec(null, null, null)).build();
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)compactionTask1);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.HOUR, Granularities.MINUTE, (List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}))), (Object)((DataSegment)segments.get(i)).getLastCompactionState());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedOverwriteShardSpec(32768, 0, 2, 1, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
    }

    @Test
    public void testCompactThenAppend() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.interval(Intervals.of((String)"2014-01-01/2014-01-02")).build();
        Pair<TaskStatus, List<DataSegment>> compactionResult = this.runTask((Task)compactionTask);
        Assert.assertTrue((boolean)((TaskStatus)compactionResult.lhs).isSuccess());
        HashSet expectedSegments = new HashSet((Collection)compactionResult.rhs);
        Pair<TaskStatus, List<DataSegment>> appendResult = this.runAppendTask();
        Assert.assertTrue((boolean)((TaskStatus)appendResult.lhs).isSuccess());
        expectedSegments.addAll((Collection)appendResult.rhs);
        HashSet usedSegments = new HashSet(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02")), Segments.ONLY_VISIBLE));
        Assert.assertEquals(expectedSegments, usedSegments);
    }

    @Test
    public void testPartialIntervalCompactWithFinerSegmentGranularityThenFullIntervalCompactWithDropExistingTrue() throws Exception {
        if (this.lockGranularity == LockGranularity.SEGMENT) {
            return;
        }
        Pair<TaskStatus, List<DataSegment>> result = this.runIndexTask();
        Assert.assertEquals((long)6L, (long)((List)result.rhs).size());
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        Interval compactionPartialInterval = Intervals.of((String)"2014-01-01T01:00:00/2014-01-01T02:00:00");
        CompactionTask partialCompactionTask = builder.segmentGranularity(Granularities.MINUTE).inputSpec((CompactionInputSpec)new CompactionIntervalSpec(compactionPartialInterval, null), Boolean.valueOf(true)).build();
        Pair<TaskStatus, List<DataSegment>> partialCompactionResult = this.runTask((Task)partialCompactionTask);
        Assert.assertTrue((boolean)((TaskStatus)partialCompactionResult.lhs).isSuccess());
        HashSet expectedSegments = new HashSet();
        expectedSegments.addAll(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01T00:00:00/2014-01-01T01:00:00")), Segments.ONLY_VISIBLE));
        expectedSegments.addAll(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01T02:00:00/2014-01-01T03:00:00")), Segments.ONLY_VISIBLE));
        expectedSegments.addAll((Collection)partialCompactionResult.rhs);
        Assert.assertEquals((long)64L, (long)expectedSegments.size());
        HashSet segmentsAfterPartialCompaction = new HashSet(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02")), Segments.ONLY_VISIBLE));
        Assert.assertEquals(expectedSegments, segmentsAfterPartialCompaction);
        List realSegmentsAfterPartialCompaction = segmentsAfterPartialCompaction.stream().filter(s -> !s.isTombstone()).collect(Collectors.toList());
        List tombstonesAfterPartialCompaction = segmentsAfterPartialCompaction.stream().filter(s -> s.isTombstone()).collect(Collectors.toList());
        Assert.assertEquals((long)59L, (long)tombstonesAfterPartialCompaction.size());
        Assert.assertEquals((long)5L, (long)realSegmentsAfterPartialCompaction.size());
        Assert.assertEquals((long)64L, (long)segmentsAfterPartialCompaction.size());
        CompactionTask fullCompactionTask = builder.segmentGranularity(null).inputSpec((CompactionInputSpec)new CompactionIntervalSpec(Intervals.of((String)"2014-01-01/2014-01-02"), null), Boolean.valueOf(true)).build();
        Pair<TaskStatus, List<DataSegment>> fullCompactionResult = this.runTask((Task)fullCompactionTask);
        Assert.assertTrue((boolean)((TaskStatus)fullCompactionResult.lhs).isSuccess());
        ArrayList segmentsAfterFullCompaction = new ArrayList(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02")), Segments.ONLY_VISIBLE));
        segmentsAfterFullCompaction.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getInterval(), s2.getInterval()));
        Assert.assertEquals((long)62L, (long)segmentsAfterFullCompaction.size());
        List tombstonesAfterFullCompaction = segmentsAfterFullCompaction.stream().filter(s -> s.isTombstone()).collect(Collectors.toList());
        Assert.assertEquals((long)59L, (long)tombstonesAfterFullCompaction.size());
        List realSegmentsAfterFullCompaction = segmentsAfterFullCompaction.stream().filter(s -> !s.isTombstone()).collect(Collectors.toList());
        Assert.assertEquals((long)3L, (long)realSegmentsAfterFullCompaction.size());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T00:00:00.000Z/2014-01-01T01:00:00.000Z"), (Object)((DataSegment)realSegmentsAfterFullCompaction.get(0)).getInterval());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T01:00:00.000Z/2014-01-01T01:01:00.000Z"), (Object)((DataSegment)realSegmentsAfterFullCompaction.get(1)).getInterval());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T02:00:00.000Z/2014-01-01T03:00:00.000Z"), (Object)((DataSegment)realSegmentsAfterFullCompaction.get(2)).getInterval());
    }

    @Test
    public void testCompactDatasourceOverIntervalWithOnlyTombstones() throws Exception {
        if (this.lockGranularity == LockGranularity.SEGMENT) {
            return;
        }
        Pair<TaskStatus, List<DataSegment>> result = this.runIndexTask();
        Assert.assertEquals((long)6L, (long)((List)result.rhs).size());
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        Interval compactionPartialInterval = Intervals.of((String)"2014-01-01T01:00:00/2014-01-01T02:00:00");
        CompactionTask partialCompactionTask = builder.segmentGranularity(Granularities.MINUTE).inputSpec((CompactionInputSpec)new CompactionIntervalSpec(compactionPartialInterval, null), Boolean.valueOf(true)).build();
        Pair<TaskStatus, List<DataSegment>> partialCompactionResult = this.runTask((Task)partialCompactionTask);
        Assert.assertTrue((boolean)((TaskStatus)partialCompactionResult.lhs).isSuccess());
        HashSet expectedSegments = new HashSet();
        expectedSegments.addAll(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01T00:00:00/2014-01-01T01:00:00")), Segments.ONLY_VISIBLE));
        expectedSegments.addAll(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01T02:00:00/2014-01-01T03:00:00")), Segments.ONLY_VISIBLE));
        expectedSegments.addAll((Collection)partialCompactionResult.rhs);
        Assert.assertEquals((long)64L, (long)expectedSegments.size());
        HashSet segmentsAfterPartialCompaction = new HashSet(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02")), Segments.ONLY_VISIBLE));
        Assert.assertEquals(expectedSegments, segmentsAfterPartialCompaction);
        List realSegmentsAfterPartialCompaction = segmentsAfterPartialCompaction.stream().filter(s -> !s.isTombstone()).collect(Collectors.toList());
        List tombstonesAfterPartialCompaction = segmentsAfterPartialCompaction.stream().filter(s -> s.isTombstone()).collect(Collectors.toList());
        Assert.assertEquals((long)59L, (long)tombstonesAfterPartialCompaction.size());
        Assert.assertEquals((long)5L, (long)realSegmentsAfterPartialCompaction.size());
        Assert.assertEquals((long)64L, (long)segmentsAfterPartialCompaction.size());
        CompactionTask compactionTaskOverOnlyTombstones = builder.segmentGranularity(null).inputSpec((CompactionInputSpec)new CompactionIntervalSpec(Intervals.of((String)"2014-01-01T01:01:00/2014-01-01T02:00:00"), null), Boolean.valueOf(true)).build();
        Pair<TaskStatus, List<DataSegment>> resultOverOnlyTombstones = this.runTask((Task)compactionTaskOverOnlyTombstones);
        Assert.assertTrue((boolean)((TaskStatus)resultOverOnlyTombstones.lhs).isSuccess());
        Assert.assertEquals((long)59L, (long)((List)resultOverOnlyTombstones.rhs).size());
        ((List)resultOverOnlyTombstones.rhs).forEach(t -> Assert.assertTrue((boolean)t.isTombstone()));
    }

    @Test
    public void testPartialIntervalCompactWithFinerSegmentGranularityThenFullIntervalCompactWithDropExistingFalse() throws Exception {
        if (this.lockGranularity == LockGranularity.SEGMENT) {
            return;
        }
        this.runIndexTask();
        HashSet expectedSegments = new HashSet(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02")), Segments.ONLY_VISIBLE));
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        Interval partialInterval = Intervals.of((String)"2014-01-01T01:00:00/2014-01-01T02:00:00");
        CompactionTask partialCompactionTask = builder.segmentGranularity(Granularities.MINUTE).inputSpec((CompactionInputSpec)new CompactionIntervalSpec(partialInterval, null), Boolean.valueOf(false)).build();
        Pair<TaskStatus, List<DataSegment>> partialCompactionResult = this.runTask((Task)partialCompactionTask);
        Assert.assertTrue((boolean)((TaskStatus)partialCompactionResult.lhs).isSuccess());
        expectedSegments.addAll((Collection)partialCompactionResult.rhs);
        HashSet segmentsAfterPartialCompaction = new HashSet(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02")), Segments.ONLY_VISIBLE));
        Assert.assertEquals(expectedSegments, segmentsAfterPartialCompaction);
        CompactionTask fullCompactionTask = builder.segmentGranularity(null).inputSpec((CompactionInputSpec)new CompactionIntervalSpec(Intervals.of((String)"2014-01-01/2014-01-02"), null), Boolean.valueOf(false)).build();
        Pair<TaskStatus, List<DataSegment>> fullCompactionResult = this.runTask((Task)fullCompactionTask);
        Assert.assertTrue((boolean)((TaskStatus)fullCompactionResult.lhs).isSuccess());
        ArrayList segmentsAfterFullCompaction = new ArrayList(this.getStorageCoordinator().retrieveUsedSegmentsForIntervals(DATA_SOURCE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02")), Segments.ONLY_VISIBLE));
        segmentsAfterFullCompaction.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getInterval(), s2.getInterval()));
        Assert.assertEquals((long)3L, (long)segmentsAfterFullCompaction.size());
        for (int i = 0; i < segmentsAfterFullCompaction.size(); ++i) {
            Assert.assertEquals((Object)Intervals.of((String)StringUtils.format((String)"2014-01-01T%02d/2014-01-01T%02d", (Object[])new Object[]{i, i + 1})), (Object)((DataSegment)segmentsAfterFullCompaction.get(i)).getInterval());
        }
    }

    @Test
    public void testRunIndexAndCompactForSameSegmentAtTheSameTime() throws Exception {
        this.runIndexTask();
        CountDownLatch compactionTaskReadyLatch = new CountDownLatch(1);
        CountDownLatch indexTaskStartLatch = new CountDownLatch(1);
        Future<Pair> indexFuture = this.exec.submit(() -> this.runIndexTask(compactionTaskReadyLatch, indexTaskStartLatch, false));
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.interval(Intervals.of((String)"2014-01-01T00:00:00/2014-01-02T03:00:00")).build();
        Future<Pair> compactionFuture = this.exec.submit(() -> {
            compactionTaskReadyLatch.await();
            return this.runTask((Task)compactionTask, indexTaskStartLatch, null);
        });
        Assert.assertTrue((boolean)((TaskStatus)indexFuture.get().lhs).isSuccess());
        List segments = (List)indexFuture.get().rhs;
        Assert.assertEquals((long)6L, (long)segments.size());
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i / 2, i / 2 + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedOverwriteShardSpec(32768 + i % 2, 0, 2, 1, 2), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(i % 2, 2), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
        Pair compactionResult = compactionFuture.get();
        Assert.assertEquals((Object)TaskState.FAILED, (Object)((TaskStatus)compactionResult.lhs).getStatusCode());
    }

    @Test
    public void testRunIndexAndCompactForSameSegmentAtTheSameTime2() throws Exception {
        this.runIndexTask();
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.interval(Intervals.of((String)"2014-01-01T00:00:00/2014-01-02T03:00:00")).build();
        CountDownLatch indexTaskReadyLatch = new CountDownLatch(1);
        CountDownLatch compactionTaskStartLatch = new CountDownLatch(1);
        Future<Pair> compactionFuture = this.exec.submit(() -> {
            Pair<TaskStatus, List<DataSegment>> pair = this.runTask((Task)compactionTask, indexTaskReadyLatch, compactionTaskStartLatch);
            return pair;
        });
        Future<Pair> indexFuture = this.exec.submit(() -> {
            indexTaskReadyLatch.await();
            return this.runIndexTask(compactionTaskStartLatch, null, false);
        });
        Assert.assertTrue((boolean)((TaskStatus)indexFuture.get().lhs).isSuccess());
        List segments = (List)indexFuture.get().rhs;
        Assert.assertEquals((long)6L, (long)segments.size());
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i / 2, i / 2 + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedOverwriteShardSpec(32768 + i % 2, 0, 2, 1, 2), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(i % 2, 2), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
        Pair compactionResult = compactionFuture.get();
        Assert.assertEquals((Object)TaskState.FAILED, (Object)((TaskStatus)compactionResult.lhs).getStatusCode());
    }

    @Test
    public void testRunRegularIndexTaskWithIngestSegmentFirehose() throws Exception {
        this.runIndexTask();
        IndexTask indexTask = new IndexTask(null, null, new IndexTask.IndexIngestionSpec(new DataSchema(DATA_SOURCE, (Map)this.getObjectMapper().convertValue((Object)new StringInputRowParser(DEFAULT_PARSE_SPEC, null), Map.class), new AggregatorFactory[]{new LongSumAggregatorFactory("val", "val")}, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, this.getObjectMapper()), new IndexTask.IndexIOConfig((FirehoseFactory)new IngestSegmentFirehoseFactory(DATA_SOURCE, Intervals.of((String)"2014-01-01/2014-01-02"), null, null, null, null, null, this.getIndexIO(), this.coordinatorClient, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY), Boolean.valueOf(false), Boolean.valueOf(false)), IndexTaskTest.createTuningConfig(5000000, null, null, Long.MAX_VALUE, null, false, true)), null);
        indexTask.addToContext("storeCompactionState", (Object)true);
        Pair<TaskStatus, List<DataSegment>> resultPair = this.runTask((Task)indexTask);
        Assert.assertTrue((boolean)((TaskStatus)resultPair.lhs).isSuccess());
        List segments = (List)resultPair.rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T0%d:00:00/2014-01-01T0%d:00:00", (Object[])new Object[]{i, i + 1}), (Object)((DataSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)CompactionTaskRunTest.getDefaultCompactionState(Granularities.HOUR, Granularities.MINUTE, (List<Interval>)ImmutableList.of()), (Object)((DataSegment)segments.get(i)).getLastCompactionState());
            if (this.lockGranularity == LockGranularity.SEGMENT) {
                Assert.assertEquals((Object)new NumberedOverwriteShardSpec(32768, 0, 2, 1, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
                continue;
            }
            Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)((DataSegment)segments.get(i)).getShardSpec());
        }
    }

    private Pair<TaskStatus, List<DataSegment>> runIndexTask() throws Exception {
        return this.runIndexTask(null, null, false);
    }

    private Pair<TaskStatus, List<DataSegment>> runAppendTask() throws Exception {
        return this.runIndexTask(null, null, true);
    }

    private Pair<TaskStatus, List<DataSegment>> runIndexTask(@Nullable CountDownLatch readyLatchToCountDown, @Nullable CountDownLatch latchToAwaitBeforeRun, boolean appendToExisting) throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            for (String testRow : TEST_ROWS) {
                writer.write(testRow);
            }
        }
        IndexTask indexTask = new IndexTask(null, null, IndexTaskTest.createIngestionSpec(this.getObjectMapper(), tmpDir, DEFAULT_PARSE_SPEC, null, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), IndexTaskTest.createTuningConfig(2, 2, null, 2L, null, false, true), appendToExisting, false), null);
        return this.runTask((Task)indexTask, readyLatchToCountDown, latchToAwaitBeforeRun);
    }

    private Pair<TaskStatus, List<DataSegment>> runTask(Task task) throws Exception {
        return this.runTask(task, null, null);
    }

    private Pair<TaskStatus, List<DataSegment>> runTask(Task task, @Nullable CountDownLatch readyLatchToCountDown, @Nullable CountDownLatch latchToAwaitBeforeRun) throws Exception {
        this.getLockbox().add(task);
        this.getTaskStorage().insert(task, TaskStatus.running((String)task.getId()));
        ObjectMapper objectMapper = this.getObjectMapper();
        objectMapper.registerSubtypes(new NamedType[]{new NamedType(LocalLoadSpec.class, "local")});
        objectMapper.registerSubtypes(new Class[]{LocalDataSegmentPuller.class});
        objectMapper.registerSubtypes(new Class[]{TombstoneLoadSpec.class});
        TaskToolbox box = this.createTaskToolbox(objectMapper, task);
        task.addToContext("forceTimeChunkLock", (Object)(this.lockGranularity == LockGranularity.TIME_CHUNK ? 1 : 0));
        if (task.isReady(box.getTaskActionClient())) {
            if (readyLatchToCountDown != null) {
                readyLatchToCountDown.countDown();
            }
            if (latchToAwaitBeforeRun != null) {
                latchToAwaitBeforeRun.await();
            }
            TaskStatus status = task.run(box);
            this.shutdownTask(task);
            ArrayList<DataSegment> segments = new ArrayList<DataSegment>(((IngestionTestBase.TestLocalTaskActionClient)box.getTaskActionClient()).getPublishedSegments());
            Collections.sort(segments);
            return Pair.of((Object)status, segments);
        }
        throw new ISE("task[%s] is not ready", new Object[]{task.getId()});
    }

    private TaskToolbox createTaskToolbox(ObjectMapper objectMapper, Task task) throws IOException {
        SegmentLocalCacheManager loader = new SegmentLocalCacheManager(new SegmentLoaderConfig(){

            public List<StorageLocationConfig> getLocations() {
                return ImmutableList.of((Object)new StorageLocationConfig(CompactionTaskRunTest.this.localDeepStorage, null, null));
            }
        }, objectMapper);
        return new TaskToolbox.Builder().config(new TaskConfig(null, null, null, null, null, false, null, null, null, false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null)).taskActionClient((TaskActionClient)this.createActionClient(task)).segmentPusher((DataSegmentPusher)new LocalDataSegmentPusher(new LocalDataSegmentPusherConfig())).dataSegmentKiller((DataSegmentKiller)new NoopDataSegmentKiller()).joinableFactory((JoinableFactory)NoopJoinableFactory.INSTANCE).segmentCacheManager((SegmentCacheManager)loader).jsonMapper(objectMapper).taskWorkDir(this.temporaryFolder.newFolder()).indexIO(this.getIndexIO()).indexMergerV9(this.getIndexMergerV9Factory().create(((Boolean)task.getContextValue("storeEmptyColumns", (Object)true)).booleanValue())).taskReportFileWriter((TaskReportFileWriter)new NoopTestTaskReportFileWriter()).authorizerMapper(AuthTestUtils.TEST_AUTHORIZER_MAPPER).chatHandlerProvider((ChatHandlerProvider)new NoopChatHandlerProvider()).rowIngestionMetersFactory(this.testUtils.getRowIngestionMetersFactory()).appenderatorsManager((AppenderatorsManager)new TestAppenderatorsManager()).overlordClient(this.overlordClient).coordinatorClient(this.coordinatorClient).build();
    }

    private List<String> getCSVFormatRowsFromSegments(List<DataSegment> segments) throws Exception {
        File cacheDir = this.temporaryFolder.newFolder();
        SegmentCacheManager segmentCacheManager = this.segmentCacheManagerFactory.manufacturate(cacheDir);
        ArrayList<String> rowsFromSegment = new ArrayList<String>();
        for (DataSegment segment : segments) {
            File segmentFile = segmentCacheManager.getSegmentFiles(segment);
            WindowedStorageAdapter adapter = new WindowedStorageAdapter((StorageAdapter)new QueryableIndexStorageAdapter(this.testUtils.getTestIndexIO().loadIndex(segmentFile)), segment.getInterval());
            Sequence cursorSequence = adapter.getAdapter().makeCursors(null, segment.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
            cursorSequence.accumulate(rowsFromSegment, (accumulated, cursor) -> {
                cursor.reset();
                while (!cursor.isDone()) {
                    DimensionSelector selector1 = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("ts", "ts"));
                    DimensionSelector selector2 = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("dim", "dim"));
                    DimensionSelector selector3 = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("val", "val"));
                    Object dimObject = selector2.getObject();
                    String dimVal = null;
                    if (dimObject instanceof String) {
                        dimVal = (String)dimObject;
                    } else if (dimObject instanceof List) {
                        dimVal = String.join((CharSequence)"|", (List)dimObject);
                    }
                    rowsFromSegment.add(CompactionTaskRunTest.makeCSVFormatRow(selector1.getObject().toString(), dimVal, selector3.defaultGetObject().toString()));
                    cursor.advance();
                }
                return accumulated;
            });
        }
        return rowsFromSegment;
    }

    private static String makeCSVFormatRow(String ts, String dim, String val) {
        return StringUtils.format((String)"%s,%s,%s\n", (Object[])new Object[]{ts, dim, val});
    }
}

