/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.task.IngestionTestBase;
import org.apache.druid.indexing.common.task.ShardSpecs;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBucketShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class ShardSpecsTest
extends IngestionTestBase {
    private final TestUtils testUtils = new TestUtils();
    private final ObjectMapper jsonMapper = this.testUtils.getTestObjectMapper();

    @Test
    public void testShardSpecSelectionWithNullPartitionDimension() {
        HashBucketShardSpec spec1 = new HashBucketShardSpec(0, 2, null, HashPartitionFunction.MURMUR3_32_ABS, this.jsonMapper);
        HashBucketShardSpec spec2 = new HashBucketShardSpec(1, 2, null, HashPartitionFunction.MURMUR3_32_ABS, this.jsonMapper);
        HashMap<Interval, ImmutableList> shardSpecMap = new HashMap<Interval, ImmutableList>();
        shardSpecMap.put(Intervals.of((String)"2014-01-01T00:00:00.000Z/2014-01-02T00:00:00.000Z"), ImmutableList.of((Object)spec1, (Object)spec2));
        ShardSpecs shardSpecs = new ShardSpecs(shardSpecMap, Granularities.HOUR);
        String visitorId = "visitorId";
        String clientType = "clientType";
        long timestamp1 = DateTimes.of((String)"2014-01-01T00:00:00.000Z").getMillis();
        MapBasedInputRow row1 = new MapBasedInputRow(timestamp1, (List)Lists.newArrayList((Object[])new String[]{visitorId, clientType}), (Map)ImmutableMap.of((Object)visitorId, (Object)"0", (Object)clientType, (Object)"iphone"));
        long timestamp2 = DateTimes.of((String)"2014-01-01T00:30:20.456Z").getMillis();
        MapBasedInputRow row2 = new MapBasedInputRow(timestamp2, (List)Lists.newArrayList((Object[])new String[]{visitorId, clientType}), (Map)ImmutableMap.of((Object)visitorId, (Object)"0", (Object)clientType, (Object)"iphone"));
        long timestamp3 = DateTimes.of((String)"2014-01-01T10:10:20.456Z").getMillis();
        MapBasedInputRow row3 = new MapBasedInputRow(timestamp3, (List)Lists.newArrayList((Object[])new String[]{visitorId, clientType}), (Map)ImmutableMap.of((Object)visitorId, (Object)"0", (Object)clientType, (Object)"iphone"));
        BucketNumberedShardSpec spec3 = shardSpecs.getShardSpec(Intervals.of((String)"2014-01-01T00:00:00.000Z/2014-01-02T00:00:00.000Z"), (InputRow)row1);
        BucketNumberedShardSpec spec4 = shardSpecs.getShardSpec(Intervals.of((String)"2014-01-01T00:00:00.000Z/2014-01-02T00:00:00.000Z"), (InputRow)row2);
        BucketNumberedShardSpec spec5 = shardSpecs.getShardSpec(Intervals.of((String)"2014-01-01T00:00:00.000Z/2014-01-02T00:00:00.000Z"), (InputRow)row3);
        Assert.assertSame((Object)true, (Object)(spec3 == spec4 ? 1 : 0));
        Assert.assertSame((Object)false, (Object)(spec3 == spec5 ? 1 : 0));
    }
}

