/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.SingleFileTaskReportFileWriter;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskReportSerdeTest {
    private final ObjectMapper jsonMapper;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    public TaskReportSerdeTest() {
        TestUtils testUtils = new TestUtils();
        this.jsonMapper = testUtils.getTestObjectMapper();
    }

    @Test
    public void testSerde() throws Exception {
        IngestionStatsAndErrorsTaskReport report1 = new IngestionStatsAndErrorsTaskReport("testID", new IngestionStatsAndErrorsTaskReportData(IngestionState.BUILD_SEGMENTS, (Map)ImmutableMap.of((Object)"hello", (Object)"world"), (Map)ImmutableMap.of((Object)"number", (Object)1234), "an error message", true, 1000L));
        String report1serialized = this.jsonMapper.writeValueAsString((Object)report1);
        IngestionStatsAndErrorsTaskReport report2 = (IngestionStatsAndErrorsTaskReport)this.jsonMapper.readValue(report1serialized, TaskReport.class);
        Assert.assertEquals((Object)report1, (Object)report2);
        Assert.assertEquals((long)report1.hashCode(), (long)report2.hashCode());
        File reportFile = this.temporaryFolder.newFile();
        SingleFileTaskReportFileWriter writer = new SingleFileTaskReportFileWriter(reportFile);
        writer.setObjectMapper(this.jsonMapper);
        Map reportMap1 = TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{report1});
        writer.write("testID", reportMap1);
        Map reportMap2 = (Map)this.jsonMapper.readValue(reportFile, (TypeReference)new TypeReference<Map<String, TaskReport>>(){});
        Assert.assertEquals((Object)reportMap1, (Object)reportMap2);
    }
}

