/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionStat;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBucketShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeepStoragePartitionStatTest {
    private static final ObjectMapper OBJECT_MAPPER = ParallelIndexTestingFactory.createObjectMapper();
    private DeepStoragePartitionStat target;

    @Before
    public void setup() {
        this.target = new DeepStoragePartitionStat(ParallelIndexTestingFactory.INTERVAL, (BucketNumberedShardSpec)new HashBucketShardSpec(4, 5, Collections.singletonList("dim"), HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper()), (Map)ImmutableMap.of((Object)"path", (Object)"/dummy/index.zip"));
    }

    @Test
    public void serializesDeserializes() {
        TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)this.target);
    }

    @Test
    public void hasPartitionIdThatMatchesSecondaryPartition() {
        Assert.assertEquals((long)this.target.getSecondaryPartition().getBucketId(), (long)this.target.getBucketId());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(DeepStoragePartitionStat.class).withNonnullFields(new String[]{"interval", "shardSpec", "loadSpec"}).usingGetClass().verify();
    }
}

