/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.CachingLocalSegmentAllocator;
import org.apache.druid.indexing.common.task.SegmentAllocators;
import org.apache.druid.indexing.common.task.SequenceNameFunction;
import org.apache.druid.indexing.common.task.SupervisorTaskAccessWithNullClient;
import org.apache.druid.indexing.common.task.batch.parallel.SupervisorTaskAccess;
import org.apache.druid.indexing.common.task.batch.partition.CompletePartitionAnalysis;
import org.apache.druid.indexing.common.task.batch.partition.HashPartitionAnalysis;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.HashBucketShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HashPartitionCachingLocalSegmentAllocatorTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String DATASOURCE = "datasource";
    private static final String TASKID = "taskid";
    private static final String SUPERVISOR_TASKID = "supervisor-taskid";
    private static final Interval INTERVAL = Intervals.utc((long)0L, (long)1000L);
    private static final String VERSION = "version";
    private static final String DIMENSION = "dim";
    private static final List<String> PARTITION_DIMENSIONS = ImmutableList.of((Object)"dim");
    private static final int NUM_PARTITONS = 1;
    private static final int PARTITION_NUM = 0;
    private static final HashedPartitionsSpec PARTITIONS_SPEC = new HashedPartitionsSpec(null, null, Collections.singletonList("dim"));
    private SegmentAllocator target;
    private SequenceNameFunction sequenceNameFunction;

    @Before
    public void setup() throws IOException {
        TaskToolbox toolbox = HashPartitionCachingLocalSegmentAllocatorTest.createToolbox();
        HashPartitionAnalysis partitionAnalysis = new HashPartitionAnalysis(PARTITIONS_SPEC);
        partitionAnalysis.updateBucket(INTERVAL, Integer.valueOf(1));
        this.target = SegmentAllocators.forNonLinearPartitioning((TaskToolbox)toolbox, (String)DATASOURCE, (String)TASKID, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.NONE, (List)ImmutableList.of()), (SupervisorTaskAccess)new SupervisorTaskAccessWithNullClient(SUPERVISOR_TASKID), (CompletePartitionAnalysis)partitionAnalysis);
        this.sequenceNameFunction = ((CachingLocalSegmentAllocator)this.target).getSequenceNameFunction();
    }

    @Test
    public void allocatesCorrectShardSpec() throws IOException {
        InputRow row = HashPartitionCachingLocalSegmentAllocatorTest.createInputRow();
        String sequenceName = this.sequenceNameFunction.getSequenceName(INTERVAL, row);
        SegmentIdWithShardSpec segmentIdWithShardSpec = this.target.allocate(row, sequenceName, null, false);
        Assert.assertEquals((Object)SegmentId.of((String)DATASOURCE, (Interval)INTERVAL, (String)VERSION, (int)0), (Object)segmentIdWithShardSpec.asSegmentId());
        HashBucketShardSpec shardSpec = (HashBucketShardSpec)segmentIdWithShardSpec.getShardSpec();
        Assert.assertEquals(PARTITION_DIMENSIONS, (Object)shardSpec.getPartitionDimensions());
        Assert.assertEquals((long)1L, (long)shardSpec.getNumBuckets());
        Assert.assertEquals((long)0L, (long)shardSpec.getBucketId());
    }

    @Test
    public void getSequenceName() {
        InputRow row = HashPartitionCachingLocalSegmentAllocatorTest.createInputRow();
        String sequenceName = this.sequenceNameFunction.getSequenceName(INTERVAL, row);
        String expectedSequenceName = StringUtils.format((String)"%s_%s_%d", (Object[])new Object[]{TASKID, INTERVAL, 0});
        Assert.assertEquals((Object)expectedSequenceName, (Object)sequenceName);
    }

    private static TaskToolbox createToolbox() {
        TaskToolbox toolbox = (TaskToolbox)EasyMock.mock(TaskToolbox.class);
        EasyMock.expect((Object)toolbox.getTaskActionClient()).andStubReturn((Object)HashPartitionCachingLocalSegmentAllocatorTest.createTaskActionClient());
        EasyMock.expect((Object)toolbox.getJsonMapper()).andStubReturn((Object)OBJECT_MAPPER);
        EasyMock.replay((Object[])new Object[]{toolbox});
        return toolbox;
    }

    private static TaskActionClient createTaskActionClient() {
        List<TaskLock> taskLocks = Collections.singletonList(HashPartitionCachingLocalSegmentAllocatorTest.createTaskLock());
        try {
            TaskActionClient taskActionClient = (TaskActionClient)EasyMock.mock(TaskActionClient.class);
            EasyMock.expect((Object)taskActionClient.submit((TaskAction)EasyMock.anyObject(LockListAction.class))).andStubReturn(taskLocks);
            EasyMock.replay((Object[])new Object[]{taskActionClient});
            return taskActionClient;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static TaskLock createTaskLock() {
        TaskLock taskLock = (TaskLock)EasyMock.mock(TaskLock.class);
        EasyMock.expect((Object)taskLock.getInterval()).andStubReturn((Object)INTERVAL);
        EasyMock.expect((Object)taskLock.getVersion()).andStubReturn((Object)VERSION);
        EasyMock.replay((Object[])new Object[]{taskLock});
        return taskLock;
    }

    private static InputRow createInputRow() {
        long timestamp = INTERVAL.getStartMillis();
        return new MapBasedInputRow(timestamp, Collections.singletonList(DIMENSION), (Map)ImmutableMap.of((Object)DIMENSION, (Object)1));
    }
}

