/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.IOException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ParallelIndexTuningConfigTest {
    private final ObjectMapper mapper = new DefaultObjectMapper();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.mapper.registerSubtypes(new NamedType[]{new NamedType(ParallelIndexTuningConfig.class, "index_parallel")});
    }

    @Test
    public void testSerdeDefault() throws IOException {
        ParallelIndexTuningConfig tuningConfig = ParallelIndexTuningConfig.defaultConfig();
        byte[] json = this.mapper.writeValueAsBytes((Object)tuningConfig);
        ParallelIndexTuningConfig fromJson = (ParallelIndexTuningConfig)this.mapper.readValue(json, TuningConfig.class);
        Assert.assertEquals((Object)fromJson, (Object)tuningConfig);
    }

    @Test
    public void testSerdeWithMaxRowsPerSegment() throws IOException {
        ParallelIndexTuningConfig tuningConfig = new ParallelIndexTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(100L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(250), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, null, null);
        byte[] json = this.mapper.writeValueAsBytes((Object)tuningConfig);
        ParallelIndexTuningConfig fromJson = (ParallelIndexTuningConfig)this.mapper.readValue(json, TuningConfig.class);
        Assert.assertEquals((Object)fromJson, (Object)tuningConfig);
    }

    @Test
    public void testSerdeWithMaxNumConcurrentSubTasks() throws IOException {
        int maxNumConcurrentSubTasks = 250;
        ParallelIndexTuningConfig tuningConfig = new ParallelIndexTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(100L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(250), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, null, null);
        byte[] json = this.mapper.writeValueAsBytes((Object)tuningConfig);
        ParallelIndexTuningConfig fromJson = (ParallelIndexTuningConfig)this.mapper.readValue(json, TuningConfig.class);
        Assert.assertEquals((Object)fromJson, (Object)tuningConfig);
    }

    @Test
    public void testSerdeWithMaxNumSubTasks() throws IOException {
        int maxNumSubTasks = 250;
        ParallelIndexTuningConfig tuningConfig = new ParallelIndexTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(100L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), Integer.valueOf(250), null, Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, null, null);
        byte[] json = this.mapper.writeValueAsBytes((Object)tuningConfig);
        ParallelIndexTuningConfig fromJson = (ParallelIndexTuningConfig)this.mapper.readValue(json, TuningConfig.class);
        Assert.assertEquals((Object)fromJson, (Object)tuningConfig);
    }

    @Test
    public void testSerdeWithMaxNumSubTasksAndMaxNumConcurrentSubTasks() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Can't use both maxNumSubTasks and maxNumConcurrentSubTasks");
        int maxNumSubTasks = 250;
        ParallelIndexTuningConfig tuningConfig = new ParallelIndexTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(100L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), Integer.valueOf(250), Integer.valueOf(250), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, null, null);
    }

    @Test
    public void testConstructorWithHashedPartitionsSpecAndNonForceGuaranteedRollupFailToCreate() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("DynamicPartitionsSpec must be used for best-effort rollup");
        boolean forceGuaranteedRollup = false;
        new ParallelIndexTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(10), null), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(10), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, null, null);
    }

    @Test
    public void testConstructorWithSingleDimensionPartitionsSpecAndNonForceGuaranteedRollupFailToCreate() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("DynamicPartitionsSpec must be used for best-effort rollup");
        boolean forceGuaranteedRollup = false;
        new ParallelIndexTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(100), null, "dim", false), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(10), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, null, null);
    }

    @Test
    public void testConstructorWithDynamicPartitionsSpecAndForceGuaranteedRollupFailToCreate() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("cannot be used for perfect rollup");
        boolean forceGuaranteedRollup = true;
        new ParallelIndexTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), null), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(true), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(10), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, null, null);
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(ParallelIndexTuningConfig.class).usingGetClass().verify();
    }
}

