/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractParallelIndexSupervisorTaskTest;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.indexing.common.task.batch.parallel.PartialGenericSegmentMergeTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionLocation;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PartialGenericSegmentMergeTaskTest
extends AbstractParallelIndexSupervisorTaskTest {
    @Parameterized.Parameter
    public PartitionLocation partitionLocation;
    private static final GenericPartitionLocation GENERIC_PARTITION_LOCATION = new GenericPartitionLocation("host", 1, true, "subtask-id", ParallelIndexTestingFactory.INTERVAL, (BuildingShardSpec)ParallelIndexTestingFactory.HASH_BASED_NUMBERED_SHARD_SPEC);
    private static final DeepStoragePartitionLocation DEEP_STORE_PARTITION_LOCATION = new DeepStoragePartitionLocation("subtask-id", ParallelIndexTestingFactory.INTERVAL, (BuildingShardSpec)ParallelIndexTestingFactory.HASH_BASED_NUMBERED_SHARD_SPEC, (Map)ImmutableMap.of());
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private PartialGenericSegmentMergeTask target;
    private PartialSegmentMergeIOConfig ioConfig;
    private HashedPartitionsSpec partitionsSpec;
    private PartialSegmentMergeIngestionSpec ingestionSpec;

    @Parameterized.Parameters(name="partitionLocation = {0}")
    public static Iterable<? extends Object> data() {
        return Arrays.asList(GENERIC_PARTITION_LOCATION, DEEP_STORE_PARTITION_LOCATION);
    }

    public PartialGenericSegmentMergeTaskTest() {
        super(0.0, 0.0);
    }

    @Before
    public void setup() {
        this.ioConfig = new PartialSegmentMergeIOConfig(Collections.singletonList(this.partitionLocation));
        this.partitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(1), Collections.emptyList());
        this.ingestionSpec = new PartialSegmentMergeIngestionSpec(ParallelIndexTestingFactory.createDataSchema(ParallelIndexTestingFactory.INPUT_INTERVALS), this.ioConfig, new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)this.partitionsSpec).build());
        this.target = new PartialGenericSegmentMergeTask(ParallelIndexTestingFactory.AUTOMATIC_ID, "group-id", ParallelIndexTestingFactory.TASK_RESOURCE, "supervisor-task-id", "subtask-spec-id", 1, this.ingestionSpec, ParallelIndexTestingFactory.CONTEXT);
    }

    @Test
    public void serializesDeserializes() {
        TestHelper.testSerializesDeserializes((ObjectMapper)this.getObjectMapper(), (Object)this.target);
    }

    @Test
    public void hasCorrectPrefixForAutomaticId() {
        String id = this.target.getId();
        Assert.assertThat((Object)id, (Matcher)Matchers.startsWith((String)"partial_index_generic_merge"));
    }

    @Test
    public void requiresGranularitySpecInputIntervals() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Missing intervals in granularitySpec");
        new PartialGenericSegmentMergeTask(ParallelIndexTestingFactory.AUTOMATIC_ID, "group-id", ParallelIndexTestingFactory.TASK_RESOURCE, "supervisor-task-id", "subtask-spec-id", 1, new PartialSegmentMergeIngestionSpec(ParallelIndexTestingFactory.createDataSchema(null), this.ioConfig, new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)this.partitionsSpec).build()), ParallelIndexTestingFactory.CONTEXT);
    }
}

