/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentGenerateTask;
import org.apache.druid.indexing.common.task.batch.partition.HashPartitionAnalysis;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PartialHashSegmentGenerateTaskTest {
    private static final ObjectMapper OBJECT_MAPPER = ParallelIndexTestingFactory.createObjectMapper();
    private static final ParallelIndexIngestionSpec INGESTION_SPEC = ParallelIndexTestingFactory.createIngestionSpec((InputSource)new LocalInputSource(new File("baseDir"), "filer"), (InputFormat)new JsonInputFormat(null, null, null), new ParallelIndexTestingFactory.TuningConfigBuilder().build(), ParallelIndexTestingFactory.createDataSchema(ParallelIndexTestingFactory.INPUT_INTERVALS));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private PartialHashSegmentGenerateTask target;

    @Before
    public void setup() {
        this.target = new PartialHashSegmentGenerateTask(ParallelIndexTestingFactory.AUTOMATIC_ID, "group-id", ParallelIndexTestingFactory.TASK_RESOURCE, "supervisor-task-id", "subtask-spec-id", 1, INGESTION_SPEC, ParallelIndexTestingFactory.CONTEXT, null);
    }

    @Test
    public void serializesDeserializes() {
        TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)this.target);
    }

    @Test
    public void hasCorrectPrefixForAutomaticId() {
        String id = this.target.getId();
        Assert.assertThat((Object)id, (Matcher)Matchers.startsWith((String)"partial_index_generate"));
    }

    @Test
    public void testCreateHashPartitionAnalysisFromPartitionsSpecWithNumShardsReturningAnalysisOfValidNumBuckets() {
        ImmutableList intervals = ImmutableList.of((Object)Intervals.of((String)"2020-01-01/2020-01-02"), (Object)Intervals.of((String)"2020-01-02/2020-01-03"), (Object)Intervals.of((String)"2020-01-03/2020-01-04"));
        int expectedNumBuckets = 5;
        HashPartitionAnalysis partitionAnalysis = PartialHashSegmentGenerateTask.createHashPartitionAnalysisFromPartitionsSpec((GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.NONE, (List)intervals), (HashedPartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(5), null), null);
        Assert.assertEquals((long)intervals.size(), (long)partitionAnalysis.getNumTimePartitions());
        for (Interval interval : intervals) {
            Assert.assertEquals((long)5L, (long)partitionAnalysis.getBucketAnalysis(interval).intValue());
        }
    }

    @Test
    public void testCreateHashPartitionAnalysisFromPartitionsSpecWithNumShardsMap() {
        ImmutableList intervals = ImmutableList.of((Object)Intervals.of((String)"2020-01-01/2020-01-02"), (Object)Intervals.of((String)"2020-01-02/2020-01-03"), (Object)Intervals.of((String)"2020-01-03/2020-01-04"));
        ImmutableMap intervalToNumShards = ImmutableMap.of((Object)Intervals.of((String)"2020-01-01/2020-01-02"), (Object)1, (Object)Intervals.of((String)"2020-01-02/2020-01-03"), (Object)2, (Object)Intervals.of((String)"2020-01-03/2020-01-04"), (Object)3);
        HashPartitionAnalysis partitionAnalysis = PartialHashSegmentGenerateTask.createHashPartitionAnalysisFromPartitionsSpec((GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.NONE, (List)intervals), (HashedPartitionsSpec)new HashedPartitionsSpec(null, null, null), (Map)intervalToNumShards);
        Assert.assertEquals((long)intervals.size(), (long)partitionAnalysis.getNumTimePartitions());
        for (Interval interval : intervals) {
            Assert.assertEquals((long)((Integer)intervalToNumShards.get(interval)).intValue(), (long)partitionAnalysis.getBucketAnalysis(interval).intValue());
        }
    }

    @Test
    public void requiresGranularitySpecInputIntervals() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Missing intervals in granularitySpec");
        new PartialHashSegmentGenerateTask(ParallelIndexTestingFactory.AUTOMATIC_ID, "group-id", ParallelIndexTestingFactory.TASK_RESOURCE, "supervisor-task-id", "subtask-spec-id", 1, ParallelIndexTestingFactory.createIngestionSpec((InputSource)new LocalInputSource(new File("baseDir"), "filer"), (InputFormat)new JsonInputFormat(null, null, null), new ParallelIndexTestingFactory.TuningConfigBuilder().build(), ParallelIndexTestingFactory.createDataSchema(null)), ParallelIndexTestingFactory.CONTEXT, null);
    }
}

