/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionLocation;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PartialSegmentMergeIOConfigTest {
    final PartitionLocation partitionLocation;
    private static final ObjectMapper OBJECT_MAPPER = ParallelIndexTestingFactory.createObjectMapper();
    private static final GenericPartitionLocation GENERIC_PARTITION_LOCATION = new GenericPartitionLocation("host", 1, true, "subtask-id", ParallelIndexTestingFactory.INTERVAL, (BuildingShardSpec)ParallelIndexTestingFactory.HASH_BASED_NUMBERED_SHARD_SPEC);
    private PartialSegmentMergeIOConfig target;

    public PartialSegmentMergeIOConfigTest(PartitionLocation partitionLocation) {
        this.partitionLocation = partitionLocation;
    }

    @Parameterized.Parameters(name="partitionLocation = {0}")
    public static Collection<Object[]> data() {
        return ImmutableList.of((Object)new Object[]{new GenericPartitionLocation("host", 1, true, "subtask-id", ParallelIndexTestingFactory.INTERVAL, (BuildingShardSpec)ParallelIndexTestingFactory.HASH_BASED_NUMBERED_SHARD_SPEC)}, (Object)new Object[]{new DeepStoragePartitionLocation("subtask-id", ParallelIndexTestingFactory.INTERVAL, (BuildingShardSpec)ParallelIndexTestingFactory.HASH_BASED_NUMBERED_SHARD_SPEC, (Map)ImmutableMap.of((Object)"path", (Object)"/test/path"))});
    }

    @Before
    public void setup() {
        this.target = new PartialSegmentMergeIOConfig(Collections.singletonList(this.partitionLocation));
    }

    @Test
    public void serializesDeserializes() {
        TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)this.target);
    }
}

