/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionLocation;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PartialSegmentMergeIngestionSpecTest {
    private static final ObjectMapper OBJECT_MAPPER = ParallelIndexTestingFactory.createObjectMapper();
    @Parameterized.Parameter
    public PartitionLocation partitionLocation;
    private static final GenericPartitionLocation GENERIC_PARTITION_LOCATION = new GenericPartitionLocation("host", 1, true, "subtask-id", ParallelIndexTestingFactory.INTERVAL, (BuildingShardSpec)ParallelIndexTestingFactory.HASH_BASED_NUMBERED_SHARD_SPEC);
    private static final DeepStoragePartitionLocation DEEP_STORE_PARTITION_LOCATION = new DeepStoragePartitionLocation("subtask-id", ParallelIndexTestingFactory.INTERVAL, (BuildingShardSpec)ParallelIndexTestingFactory.HASH_BASED_NUMBERED_SHARD_SPEC, (Map)ImmutableMap.of());
    private PartialSegmentMergeIngestionSpec target;
    private PartialSegmentMergeIOConfig ioConfig;
    private HashedPartitionsSpec partitionsSpec;

    @Parameterized.Parameters(name="partitionLocation = {0}")
    public static Iterable<? extends Object> data() {
        return Arrays.asList(GENERIC_PARTITION_LOCATION, DEEP_STORE_PARTITION_LOCATION);
    }

    @Before
    public void setup() {
        this.ioConfig = new PartialSegmentMergeIOConfig(Collections.singletonList(this.partitionLocation));
        this.partitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(1), Collections.emptyList());
        this.target = new PartialSegmentMergeIngestionSpec(ParallelIndexTestingFactory.createDataSchema(ParallelIndexTestingFactory.INPUT_INTERVALS), this.ioConfig, new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)this.partitionsSpec).build());
    }

    @Test
    public void serializesDeserializes() {
        TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)this.target);
    }
}

