/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractMultiPhaseParallelIndexingTest;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.ProvideSystemProperty;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RangePartitionMultiPhaseParallelIndexingTest
extends AbstractMultiPhaseParallelIndexingTest {
    private static final boolean USE_INPUT_FORMAT_API = true;
    private static final boolean USE_MULTIVALUE_DIM = true;
    private static final int NUM_FILE = 10;
    private static final int NUM_ROW = 20;
    private static final int DIM_FILE_CARDINALITY = 2;
    private static final int NUM_PARTITION = 2;
    private static final int YEAR = 2017;
    private static final Interval INTERVAL_TO_INDEX = Intervals.of((String)"%s-12/P1M", (Object[])new Object[]{2017});
    private static final String TIME = "ts";
    private static final String DIM1 = "dim1";
    private static final String DIM2 = "dim2";
    private static final String LIST_DELIMITER = "|";
    private static final List<String> DIMS = ImmutableList.of((Object)"dim1", (Object)"dim2");
    private static final String TEST_FILE_NAME_PREFIX = "test_";
    private static final TimestampSpec TIMESTAMP_SPEC = new TimestampSpec("ts", "auto", null);
    private static final DimensionsSpec DIMENSIONS_SPEC = new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim1", "dim2")));
    private static final ParseSpec PARSE_SPEC = new CSVParseSpec(TIMESTAMP_SPEC, DIMENSIONS_SPEC, "|", Arrays.asList("ts", "dim1", "dim2", "val"), false, 0);
    private static final InputFormat INPUT_FORMAT = new CsvInputFormat(Arrays.asList("ts", "dim1", "dim2", "val"), "|", Boolean.valueOf(false), Boolean.valueOf(false), 0);
    @Rule
    public final ProvideSystemProperty noDefaultNullValue = new ProvideSystemProperty("druid.generic.useDefaultValueForNull", "false");
    private File inputDir;
    private SetMultimap<Interval, List<Object>> intervalToDims;
    private final int maxNumConcurrentSubTasks;
    private final boolean useMultivalueDim;
    @Nullable
    private final Interval intervalToIndex;

    @Parameterized.Parameters(name="{0}, useInputFormatApi={1}, maxNumConcurrentSubTasks={2}, useMultiValueDim={3}, intervalToIndex={4}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{LockGranularity.TIME_CHUNK, false, 2, false, INTERVAL_TO_INDEX}, (Object)new Object[]{LockGranularity.TIME_CHUNK, true, 2, false, INTERVAL_TO_INDEX}, (Object)new Object[]{LockGranularity.TIME_CHUNK, true, 2, false, null}, (Object)new Object[]{LockGranularity.SEGMENT, true, 2, false, INTERVAL_TO_INDEX}, (Object)new Object[]{LockGranularity.SEGMENT, true, 1, false, INTERVAL_TO_INDEX}, (Object)new Object[]{LockGranularity.SEGMENT, true, 2, true, INTERVAL_TO_INDEX});
    }

    public RangePartitionMultiPhaseParallelIndexingTest(LockGranularity lockGranularity, boolean useInputFormatApi, int maxNumConcurrentSubTasks, boolean useMultivalueDim, @Nullable Interval intervalToIndex) {
        super(lockGranularity, useInputFormatApi, 0.2, 0.2);
        this.maxNumConcurrentSubTasks = maxNumConcurrentSubTasks;
        this.useMultivalueDim = useMultivalueDim;
        this.intervalToIndex = intervalToIndex;
    }

    @Before
    public void setup() throws IOException {
        this.inputDir = this.temporaryFolder.newFolder("data");
        this.intervalToDims = RangePartitionMultiPhaseParallelIndexingTest.createInputFiles(this.inputDir, this.useMultivalueDim);
    }

    private static SetMultimap<Interval, List<Object>> createInputFiles(File inputDir, boolean useMultivalueDim) throws IOException {
        HashMultimap intervalToDims = HashMultimap.create();
        for (int fileIndex = 0; fileIndex < 10; ++fileIndex) {
            Path path = new File(inputDir, TEST_FILE_NAME_PREFIX + fileIndex).toPath();
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                for (int i = 0; i < 10; ++i) {
                    for (int d = 0; d < 2; ++d) {
                        int rowIndex = i * 2 + d;
                        String dim1Value = RangePartitionMultiPhaseParallelIndexingTest.createDim1Value(rowIndex, fileIndex, useMultivalueDim);
                        RangePartitionMultiPhaseParallelIndexingTest.writeRow(writer, i + d, dim1Value, fileIndex, (Multimap<Interval, List<Object>>)intervalToDims);
                        RangePartitionMultiPhaseParallelIndexingTest.writeRow(writer, i + d, dim1Value, fileIndex, (Multimap<Interval, List<Object>>)intervalToDims);
                        RangePartitionMultiPhaseParallelIndexingTest.writeRow(writer, i + d, dim1Value, fileIndex + 10, (Multimap<Interval, List<Object>>)intervalToDims);
                    }
                }
                continue;
            }
        }
        return intervalToDims;
    }

    private static SetMultimap<Interval, List<Object>> createInputFilesForReplace(File inputDir, boolean useMultivalueDim) throws IOException {
        HashMultimap intervalToDims = HashMultimap.create();
        HashSet<Integer> fileIds = new HashSet<Integer>();
        fileIds.add(1);
        fileIds.add(7);
        fileIds.add(9);
        for (Integer fileIndex : fileIds) {
            Path path = new File(inputDir, TEST_FILE_NAME_PREFIX + fileIndex).toPath();
            BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            Throwable throwable = null;
            try {
                for (int i = 11; i < 20; ++i) {
                    for (int d = 0; d < 2; ++d) {
                        int rowIndex = i * 2 + d;
                        String dim1Value = RangePartitionMultiPhaseParallelIndexingTest.createDim1Value(rowIndex, fileIndex, useMultivalueDim);
                        RangePartitionMultiPhaseParallelIndexingTest.writeRow(writer, i + d, dim1Value, fileIndex, (Multimap<Interval, List<Object>>)intervalToDims);
                        RangePartitionMultiPhaseParallelIndexingTest.writeRow(writer, i + d, dim1Value, fileIndex, (Multimap<Interval, List<Object>>)intervalToDims);
                        RangePartitionMultiPhaseParallelIndexingTest.writeRow(writer, i + d, dim1Value, fileIndex + 10, (Multimap<Interval, List<Object>>)intervalToDims);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Writer)writer).close();
            }
        }
        return intervalToDims;
    }

    @Nullable
    private static String createDim1Value(int rowIndex, int fileIndex, boolean useMultivalueDim) {
        if (rowIndex == fileIndex) {
            return null;
        }
        String dim1Value = String.valueOf(fileIndex);
        return useMultivalueDim ? dim1Value + LIST_DELIMITER + dim1Value : dim1Value;
    }

    private static void writeRow(Writer writer, int day, @Nullable String dim1Value, int fileIndex, Multimap<Interval, List<Object>> intervalToDims) throws IOException {
        Interval interval = Intervals.of((String)"%s-12-%d/%s-12-%d", (Object[])new Object[]{2017, day + 1, 2017, day + 2});
        String startDate = interval.getStart().toString("y-M-d");
        String dim2Value = "test file " + fileIndex;
        String row = startDate + ",";
        if (dim1Value != null) {
            row = row + dim1Value;
        }
        row = row + "," + dim2Value + "\n";
        writer.write(row);
        intervalToDims.put((Object)interval, Arrays.asList(dim1Value, dim2Value));
    }

    @Test
    public void createsCorrectRangePartitions() throws Exception {
        int targetRowsPerSegment = 10;
        Set<DataSegment> publishedSegments = this.runTask((Task)this.runTestTask((PartitionsSpec)new DimensionRangePartitionsSpec(Integer.valueOf(targetRowsPerSegment), null, Collections.singletonList(DIM1), false), this.inputDir, false, false), this.useMultivalueDim ? TaskState.FAILED : TaskState.SUCCESS);
        if (!this.useMultivalueDim) {
            this.assertRangePartitions(publishedSegments);
        }
        if (this.intervalToIndex == null) {
            return;
        }
        File inputDirectory = this.temporaryFolder.newFolder("dataReplace");
        RangePartitionMultiPhaseParallelIndexingTest.createInputFilesForReplace(inputDirectory, this.useMultivalueDim);
        Set<DataSegment> publishedSegmentsAfterReplace = this.runTask((Task)this.runTestTask((PartitionsSpec)new DimensionRangePartitionsSpec(Integer.valueOf(targetRowsPerSegment), null, Collections.singletonList(DIM1), false), inputDirectory, false, true), this.useMultivalueDim ? TaskState.FAILED : TaskState.SUCCESS);
        int tombstones = 0;
        for (DataSegment ds : publishedSegmentsAfterReplace) {
            if (!ds.isTombstone()) continue;
            ++tombstones;
        }
        if (!this.useMultivalueDim) {
            Assert.assertEquals((long)11L, (long)tombstones);
            Assert.assertEquals((long)10L, (long)(publishedSegmentsAfterReplace.size() - tombstones));
        }
    }

    @Test
    public void testAppendLinearlyPartitionedSegmentsToHashPartitionedDatasourceSuccessfullyAppend() {
        if (this.useMultivalueDim) {
            return;
        }
        int targetRowsPerSegment = 5;
        HashSet<DataSegment> publishedSegments = new HashSet<DataSegment>();
        publishedSegments.addAll(this.runTask((Task)this.runTestTask((PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(5), null, DIM1, false), this.inputDir, false, false), TaskState.SUCCESS));
        publishedSegments.addAll(this.runTask((Task)this.runTestTask((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(5), null), this.inputDir, true, false), TaskState.SUCCESS));
        publishedSegments.addAll(this.runTask((Task)this.runTestTask((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(10), null), this.inputDir, true, false), TaskState.SUCCESS));
        HashMap intervalToSegments = new HashMap();
        publishedSegments.forEach(segment -> intervalToSegments.computeIfAbsent(segment.getInterval(), k -> new ArrayList()).add(segment));
        for (Map.Entry entry : intervalToSegments.entrySet()) {
            List segments = (List)entry.getValue();
            List rangedSegments = segments.stream().filter(segment -> segment.getShardSpec().getClass() == SingleDimensionShardSpec.class).collect(Collectors.toList());
            List linearSegments = segments.stream().filter(segment -> segment.getShardSpec().getClass() == NumberedShardSpec.class).collect(Collectors.toList());
            for (DataSegment rangedSegment : rangedSegments) {
                SingleDimensionShardSpec rangeShardSpec = (SingleDimensionShardSpec)rangedSegment.getShardSpec();
                for (DataSegment linearSegment : linearSegments) {
                    Assert.assertEquals((Object)rangedSegment.getInterval(), (Object)linearSegment.getInterval());
                    Assert.assertEquals((Object)rangedSegment.getVersion(), (Object)linearSegment.getVersion());
                    NumberedShardSpec numberedShardSpec = (NumberedShardSpec)linearSegment.getShardSpec();
                    Assert.assertEquals((long)rangeShardSpec.getNumCorePartitions(), (long)numberedShardSpec.getNumCorePartitions());
                    Assert.assertTrue((rangeShardSpec.getPartitionNum() < numberedShardSpec.getPartitionNum() ? 1 : 0) != 0);
                }
            }
        }
    }

    private ParallelIndexSupervisorTask runTestTask(PartitionsSpec partitionsSpec, File inputDirectory, boolean appendToExisting, boolean dropExisting) {
        if (this.isUseInputFormatApi()) {
            return this.createTask(TIMESTAMP_SPEC, DIMENSIONS_SPEC, INPUT_FORMAT, null, this.intervalToIndex, inputDirectory, "test_*", partitionsSpec, this.maxNumConcurrentSubTasks, appendToExisting, dropExisting);
        }
        return this.createTask(null, null, null, PARSE_SPEC, this.intervalToIndex, inputDirectory, "test_*", partitionsSpec, this.maxNumConcurrentSubTasks, appendToExisting, dropExisting);
    }

    private void assertRangePartitions(Set<DataSegment> publishedSegments) throws IOException {
        ArrayListMultimap intervalToSegments = ArrayListMultimap.create();
        publishedSegments.forEach(arg_0 -> RangePartitionMultiPhaseParallelIndexingTest.lambda$assertRangePartitions$4((Multimap)intervalToSegments, arg_0));
        Set publishedIntervals = intervalToSegments.keySet();
        this.assertHasExpectedIntervals(publishedIntervals);
        File tempSegmentDir = this.temporaryFolder.newFolder();
        intervalToSegments.asMap().forEach((interval, segments) -> {
            RangePartitionMultiPhaseParallelIndexingTest.assertNumPartition(segments);
            ArrayList<StringTuple> allValues = new ArrayList<StringTuple>(20);
            for (DataSegment segment : segments) {
                List<StringTuple> values = this.getColumnValues(segment, tempSegmentDir);
                RangePartitionMultiPhaseParallelIndexingTest.assertValuesInRange(values, segment);
                allValues.addAll(values);
            }
            this.assertIntervalHasAllExpectedValues((Interval)interval, (List<StringTuple>)allValues);
        });
    }

    private void assertHasExpectedIntervals(Set<Interval> publishedSegmentIntervals) {
        Assert.assertEquals((Object)this.intervalToDims.keySet(), publishedSegmentIntervals);
    }

    private static void assertNumPartition(Collection<DataSegment> segments) {
        Assert.assertEquals((long)2L, (long)segments.size());
    }

    private List<StringTuple> getColumnValues(DataSegment segment, File tempDir) {
        List<ScanResultValue> results = this.querySegment(segment, DIMS, tempDir);
        Assert.assertEquals((long)1L, (long)results.size());
        List rows = (List)results.get(0).getEvents();
        return rows.stream().map(row -> (String)row.get(DIM1)).map(xva$0 -> StringTuple.create((String[])new String[]{xva$0})).collect(Collectors.toList());
    }

    private static void assertValuesInRange(List<StringTuple> values, DataSegment segment) {
        DimensionRangeShardSpec shardSpec = (DimensionRangeShardSpec)segment.getShardSpec();
        StringTuple start = shardSpec.getStartTuple();
        StringTuple end = shardSpec.getEndTuple();
        Assert.assertTrue((String)shardSpec.toString(), (start != null || end != null ? 1 : 0) != 0);
        for (StringTuple value : values) {
            if (start != null) {
                Assert.assertThat((Object)value.compareTo(start), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
            }
            if (end == null) continue;
            if (value == null) {
                Assert.assertNull((String)"null values should be in first partition", (Object)start);
                continue;
            }
            Assert.assertThat((Object)value.compareTo(end), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        }
    }

    private void assertIntervalHasAllExpectedValues(Interval interval, List<StringTuple> actualValues) {
        List expectedValues = this.intervalToDims.get((Object)interval).stream().map(d -> (String)d.get(0)).map(xva$0 -> StringTuple.create((String[])new String[]{xva$0})).sorted((Comparator<StringTuple>)Comparators.naturalNullsFirst()).collect(Collectors.toList());
        actualValues.sort((Comparator<StringTuple>)Comparators.naturalNullsFirst());
        Assert.assertEquals((String)interval.toString(), expectedValues, actualValues);
    }

    private static /* synthetic */ void lambda$assertRangePartitions$4(Multimap intervalToSegments, DataSegment s) {
        intervalToSegments.put((Object)s.getInterval(), (Object)s);
    }
}

