/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.IngestionTestBase;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractMultiPhaseParallelIndexingTest;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTaskRunner;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialDimensionDistributionParallelIndexTaskRunner;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RangePartitionTaskKillTest
extends AbstractMultiPhaseParallelIndexingTest {
    private static final int NUM_PARTITION = 2;
    private static final int NUM_ROW = 20;
    private static final int DIM_FILE_CARDINALITY = 2;
    private static final int YEAR = 2017;
    private static final Interval INTERVAL_TO_INDEX = Intervals.of((String)"%s-12/P1M", (Object[])new Object[]{2017});
    private static final String TIME = "ts";
    private static final String DIM1 = "dim1";
    private static final String DIM2 = "dim2";
    private static final String LIST_DELIMITER = "|";
    private static final String TEST_FILE_NAME_PREFIX = "test_";
    private static final TimestampSpec TIMESTAMP_SPEC = new TimestampSpec("ts", "auto", null);
    private static final DimensionsSpec DIMENSIONS_SPEC = new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim1", "dim2")));
    private static final InputFormat INPUT_FORMAT = new CsvInputFormat(Arrays.asList("ts", "dim1", "dim2", "val"), "|", Boolean.valueOf(false), Boolean.valueOf(false), 0);
    private File inputDir;

    public RangePartitionTaskKillTest() {
        super(LockGranularity.SEGMENT, true, 0.2, 0.2);
    }

    @Before
    public void setup() throws IOException {
        this.inputDir = this.temporaryFolder.newFolder("data");
    }

    @Test(timeout=5000L)
    public void failsFirstPhase() throws Exception {
        int targetRowsPerSegment = 10;
        ParallelIndexSupervisorTask task = this.newTask(TIMESTAMP_SPEC, DIMENSIONS_SPEC, INPUT_FORMAT, null, INTERVAL_TO_INDEX, this.inputDir, "test_*", (PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(targetRowsPerSegment), null, DIM1, false), 2, false, 0);
        IngestionTestBase.TestLocalTaskActionClient actionClient = this.createActionClient((Task)task);
        TaskToolbox toolbox = this.createTaskToolbox((Task)task, actionClient);
        this.prepareTaskForLocking((Task)task);
        Assert.assertTrue((boolean)task.isReady((TaskActionClient)actionClient));
        task.stopGracefully(null);
        TaskStatus taskStatus = task.runRangePartitionMultiPhaseParallel(toolbox);
        Assert.assertTrue((boolean)taskStatus.isFailure());
        Assert.assertEquals((Object)"Failed in phase[PHASE-1]. See task logs for details.", (Object)taskStatus.getErrorMsg());
    }

    @Test(timeout=5000L)
    public void failsSecondPhase() throws Exception {
        int targetRowsPerSegment = 10;
        ParallelIndexSupervisorTask task = this.newTask(TIMESTAMP_SPEC, DIMENSIONS_SPEC, INPUT_FORMAT, null, INTERVAL_TO_INDEX, this.inputDir, "test_*", (PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(targetRowsPerSegment), null, DIM1, false), 2, false, 1);
        IngestionTestBase.TestLocalTaskActionClient actionClient = this.createActionClient((Task)task);
        TaskToolbox toolbox = this.createTaskToolbox((Task)task, actionClient);
        this.prepareTaskForLocking((Task)task);
        Assert.assertTrue((boolean)task.isReady((TaskActionClient)actionClient));
        task.stopGracefully(null);
        TaskStatus taskStatus = task.runRangePartitionMultiPhaseParallel(toolbox);
        Assert.assertTrue((boolean)taskStatus.isFailure());
        Assert.assertEquals((Object)"Failed in phase[PHASE-2]. See task logs for details.", (Object)taskStatus.getErrorMsg());
    }

    @Test(timeout=5000L)
    public void failsThirdPhase() throws Exception {
        int targetRowsPerSegment = 10;
        ParallelIndexSupervisorTask task = this.newTask(TIMESTAMP_SPEC, DIMENSIONS_SPEC, INPUT_FORMAT, null, INTERVAL_TO_INDEX, this.inputDir, "test_*", (PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(targetRowsPerSegment), null, DIM1, false), 2, false, 2);
        IngestionTestBase.TestLocalTaskActionClient actionClient = this.createActionClient((Task)task);
        TaskToolbox toolbox = this.createTaskToolbox((Task)task, actionClient);
        this.prepareTaskForLocking((Task)task);
        Assert.assertTrue((boolean)task.isReady((TaskActionClient)actionClient));
        task.stopGracefully(null);
        TaskStatus taskStatus = task.runRangePartitionMultiPhaseParallel(toolbox);
        Assert.assertTrue((boolean)taskStatus.isFailure());
        Assert.assertEquals((Object)"Failed in phase[PHASE-3]. See task logs for details.", (Object)taskStatus.getErrorMsg());
    }

    protected ParallelIndexSupervisorTask newTask(@Nullable TimestampSpec timestampSpec, @Nullable DimensionsSpec dimensionsSpec, @Nullable InputFormat inputFormat, @Nullable ParseSpec parseSpec, Interval interval, File inputDir, String filter, PartitionsSpec partitionsSpec, int maxNumConcurrentSubTasks, boolean appendToExisting, int succeedsBeforeFailing) {
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(SEGMENT_GRANULARITY, Granularities.MINUTE, interval == null ? null : Collections.singletonList(interval));
        ParallelIndexTuningConfig tuningConfig = this.newTuningConfig(partitionsSpec, maxNumConcurrentSubTasks, !appendToExisting);
        Preconditions.checkArgument((parseSpec == null ? 1 : 0) != 0);
        ParallelIndexIOConfig ioConfig = new ParallelIndexIOConfig(null, (InputSource)new LocalInputSource(inputDir, filter), inputFormat, Boolean.valueOf(appendToExisting), null);
        ParallelIndexIngestionSpec ingestionSpec = new ParallelIndexIngestionSpec(new DataSchema("dataSource", timestampSpec, dimensionsSpec, new AggregatorFactory[]{new LongSumAggregatorFactory("val", "val")}, (GranularitySpec)granularitySpec, null), ioConfig, tuningConfig);
        return new ParallelIndexSupervisorTaskTest(null, null, null, ingestionSpec, null, Collections.emptyMap(), succeedsBeforeFailing);
    }

    static class ParallelIndexSupervisorTaskTest
    extends ParallelIndexSupervisorTask {
        private final int failInPhase;
        private int currentPhase;
        private static final Map<Interval, PartitionBoundaries> INTERVAL_TO_PARTITIONS = ImmutableMap.of((Object)Intervals.of((String)"2011-04-01/2011-04-02"), (Object)new PartitionBoundaries(new StringTuple[0]));

        public ParallelIndexSupervisorTaskTest(String id, @Nullable String groupId, TaskResource taskResource, ParallelIndexIngestionSpec ingestionSchema, @Nullable String baseSubtaskSpecName, Map<String, Object> context, int succedsBeforeFailing) {
            super(id, groupId, taskResource, ingestionSchema, baseSubtaskSpecName, context);
            this.failInPhase = succedsBeforeFailing;
        }

        <T extends Task, R extends SubTaskReport> ParallelIndexTaskRunner<T, R> createRunner(TaskToolbox toolbox, Function<TaskToolbox, ParallelIndexTaskRunner<T, R>> runnerCreator) {
            PartialDimensionDistributionParallelIndexTaskRunner retVal;
            if (this.failInPhase == 0) {
                retVal = this.createMockDistributionRunner(false, "PHASE-1");
            } else if (this.failInPhase == 1 && this.currentPhase == 1) {
                retVal = this.createMockDistributionRunner(false, "PHASE-2");
            } else if (this.failInPhase == 2 && this.currentPhase == 2) {
                retVal = this.createMockDistributionRunner(false, "PHASE-3");
            } else {
                ++this.currentPhase;
                retVal = this.createMockDistributionRunner(true, "SUCCESFUL-PHASE");
            }
            return retVal;
        }

        private PartialDimensionDistributionParallelIndexTaskRunner createMockDistributionRunner(boolean succeeds, String phase) {
            try {
                PartialDimensionDistributionParallelIndexTaskRunner runner = (PartialDimensionDistributionParallelIndexTaskRunner)Mockito.mock(PartialDimensionDistributionParallelIndexTaskRunner.class);
                Mockito.when((Object)runner.getName()).thenReturn((Object)phase);
                Mockito.when((Object)runner.run()).thenReturn((Object)(succeeds ? TaskState.SUCCESS : TaskState.FAILED));
                Mockito.when((Object)runner.getStopReason()).thenReturn(null);
                Mockito.when((Object)runner.getProgress()).thenReturn(null);
                Mockito.when((Object)runner.getIntervalToPartitionBoundaries((DimensionRangePartitionsSpec)ArgumentMatchers.any())).thenReturn(INTERVAL_TO_PARTITIONS);
                return runner;
            }
            catch (Exception e) {
                throw new ISE((Throwable)e, "Error while mocking distribution phase runner", new Object[0]);
            }
        }
    }
}

