/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.tasklogs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.config.FileTaskLogsConfig;
import org.apache.druid.indexing.common.tasklogs.FileTaskLogs;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.tasklogs.TaskLogs;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class FileTaskLogsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        try {
            File logDir = new File(tmpDir, "druid/logs");
            File logFile = new File(tmpDir, "log");
            Files.write((CharSequence)"blah", (File)logFile, (Charset)StandardCharsets.UTF_8);
            FileTaskLogs taskLogs = new FileTaskLogs(new FileTaskLogsConfig(logDir));
            taskLogs.pushTaskLog("foo", logFile);
            ImmutableMap expected = ImmutableMap.of((Object)0L, (Object)"blah", (Object)1L, (Object)"lah", (Object)-2L, (Object)"ah", (Object)-5L, (Object)"blah");
            for (Map.Entry entry : expected.entrySet()) {
                byte[] bytes = ByteStreams.toByteArray((InputStream)((InputStream)taskLogs.streamTaskLog("foo", ((Long)entry.getKey()).longValue()).get()));
                String string = StringUtils.fromUtf8((byte[])bytes);
                Assert.assertEquals((String)StringUtils.format((String)"Read with offset %,d", (Object[])new Object[]{entry.getKey()}), (Object)string, entry.getValue());
            }
        }
        finally {
            FileUtils.deleteDirectory((File)tmpDir);
        }
    }

    @Test
    public void testSimpleReport() throws Exception {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        File tmpDir = this.temporaryFolder.newFolder();
        File logDir = new File(tmpDir, "druid/logs");
        File reportFile = new File(tmpDir, "report.json");
        String taskId = "myTask";
        TestTaskReport testReport = new TestTaskReport("myTask");
        String testReportString = mapper.writeValueAsString((Object)TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{testReport}));
        Files.write((CharSequence)testReportString, (File)reportFile, (Charset)StandardCharsets.UTF_8);
        FileTaskLogs taskLogs = new FileTaskLogs(new FileTaskLogsConfig(logDir));
        taskLogs.pushTaskReports("foo", reportFile);
        Assert.assertEquals((Object)testReportString, (Object)StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)taskLogs.streamTaskReports("foo").get()))));
    }

    @Test
    public void testPushTaskLogDirCreationFails() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File logDir = new File(tmpDir, "druid/logs");
        File logFile = new File(tmpDir, "log");
        Files.write((CharSequence)"blah", (File)logFile, (Charset)StandardCharsets.UTF_8);
        if (!tmpDir.setWritable(false)) {
            throw new RuntimeException("failed to make tmp dir read-only");
        }
        FileTaskLogs taskLogs = new FileTaskLogs(new FileTaskLogsConfig(logDir));
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("Cannot create directory");
        taskLogs.pushTaskLog("foo", logFile);
    }

    @Test
    public void testKill() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File logDir = new File(tmpDir, "logs");
        File logFile = new File(tmpDir, "log");
        FileTaskLogs taskLogs = new FileTaskLogs(new FileTaskLogsConfig(logDir));
        Files.write((CharSequence)"log1content", (File)logFile, (Charset)StandardCharsets.UTF_8);
        taskLogs.pushTaskLog("log1", logFile);
        Assert.assertEquals((Object)"log1content", (Object)this.readLog((TaskLogs)taskLogs, "log1", 0L));
        Thread.sleep(1500L);
        long time = System.currentTimeMillis() / 1000L * 1000L;
        Assert.assertTrue((new File(logDir, "log1.log").lastModified() < time ? 1 : 0) != 0);
        Files.write((CharSequence)"log2content", (File)logFile, (Charset)StandardCharsets.UTF_8);
        taskLogs.pushTaskLog("log2", logFile);
        Assert.assertEquals((Object)"log2content", (Object)this.readLog((TaskLogs)taskLogs, "log2", 0L));
        Assert.assertTrue((new File(logDir, "log2.log").lastModified() >= time ? 1 : 0) != 0);
        taskLogs.killOlderThan(time);
        Assert.assertFalse((boolean)taskLogs.streamTaskLog("log1", 0L).isPresent());
        Assert.assertEquals((Object)"log2content", (Object)this.readLog((TaskLogs)taskLogs, "log2", 0L));
    }

    private String readLog(TaskLogs taskLogs, String logFile, long offset) throws IOException {
        return StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)taskLogs.streamTaskLog(logFile, offset).get())));
    }

    private static class TestTaskReport
    implements TaskReport {
        static final String KEY = "testReport";
        static final Map<String, Object> PAYLOAD = ImmutableMap.of((Object)"foo", (Object)"bar");
        private final String taskId;

        public TestTaskReport(String taskId) {
            this.taskId = taskId;
        }

        @JsonProperty
        public String getTaskId() {
            return this.taskId;
        }

        public String getReportKey() {
            return KEY;
        }

        @JsonProperty
        public Object getPayload() {
            return PAYLOAD;
        }
    }
}

