/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.tasklogs;

import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.indexing.common.tasklogs.SwitchingTaskLogStreamer;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.tasklogs.NoopTaskLogs;
import org.apache.druid.tasklogs.TaskLogStreamer;
import org.junit.Assert;
import org.junit.Test;

public class SwitchingTaskLogStreamerTest {
    private static final String LOG = "LOG";
    private static final String REPORT = "REPORT";
    private static final String TASK_ID = "foo";
    private final TaskLogStreamer streamer1 = new TestTaskLogStreamer(1);
    private final TaskLogStreamer streamer2 = new TestTaskLogStreamer(2);
    private final TaskLogStreamer emptyStreamer = new NoopTaskLogs();
    private final TaskLogStreamer ioExceptionStreamer = new TaskLogStreamer(){

        public Optional<InputStream> streamTaskLog(String taskid, long offset) throws IOException {
            throw new IOE("expected log exception", new Object[0]);
        }

        public Optional<InputStream> streamTaskReports(String taskid) throws IOException {
            throw new IOE("expected task exception", new Object[0]);
        }
    };

    @Test
    public void foundInRemoteTasks() throws IOException {
        SwitchingTaskLogStreamer switchingTaskLogStreamer = new SwitchingTaskLogStreamer(this.streamer1, Arrays.asList(this.streamer2, this.emptyStreamer));
        Assert.assertEquals((Object)SwitchingTaskLogStreamerTest.getLogString(1, TASK_ID, 1L), (Object)StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskLog(TASK_ID, 1L).get()))));
        Assert.assertEquals((Object)SwitchingTaskLogStreamerTest.getReportString(1, TASK_ID), (Object)StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskReports(TASK_ID).get()))));
    }

    @Test
    public void foundInDeepStorage() throws IOException {
        SwitchingTaskLogStreamer switchingTaskLogStreamer = new SwitchingTaskLogStreamer(this.emptyStreamer, Arrays.asList(this.streamer2, this.emptyStreamer));
        Assert.assertEquals((Object)SwitchingTaskLogStreamerTest.getLogString(2, TASK_ID, 1L), (Object)StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskLog(TASK_ID, 1L).get()))));
        Assert.assertEquals((Object)SwitchingTaskLogStreamerTest.getReportString(2, TASK_ID), (Object)StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskReports(TASK_ID).get()))));
    }

    @Test
    public void exceptionInTaskStreamerButFoundInDeepStrorage() throws IOException {
        SwitchingTaskLogStreamer switchingTaskLogStreamer = new SwitchingTaskLogStreamer(this.ioExceptionStreamer, Arrays.asList(this.streamer2, this.emptyStreamer));
        Assert.assertEquals((Object)SwitchingTaskLogStreamerTest.getLogString(2, TASK_ID, 1L), (Object)StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskLog(TASK_ID, 1L).get()))));
        Assert.assertEquals((Object)SwitchingTaskLogStreamerTest.getReportString(2, TASK_ID), (Object)StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskReports(TASK_ID).get()))));
    }

    @Test
    public void exceptionInDeepStrorage() {
        SwitchingTaskLogStreamer switchingTaskLogStreamer = new SwitchingTaskLogStreamer(this.emptyStreamer, Arrays.asList(this.ioExceptionStreamer, this.streamer2));
        Assert.assertThrows((String)"expected log exception", IOException.class, () -> StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskLog(TASK_ID, 1L).get()))));
        Assert.assertThrows((String)"expected report exception", IOException.class, () -> StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskReports(TASK_ID).get()))));
    }

    @Test
    public void exceptionInRemoteTaskLogStreamerWithEmptyDeepStorage() {
        SwitchingTaskLogStreamer switchingTaskLogStreamer = new SwitchingTaskLogStreamer(this.ioExceptionStreamer, Collections.singletonList(this.emptyStreamer));
        Assert.assertThrows((String)"expected log exception", IOException.class, () -> StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskLog(TASK_ID, 1L).get()))));
        Assert.assertThrows((String)"expected report exception", IOException.class, () -> StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskReports(TASK_ID).get()))));
    }

    @Test
    public void exceptionEverywhere() {
        SwitchingTaskLogStreamer switchingTaskLogStreamer = new SwitchingTaskLogStreamer(this.ioExceptionStreamer, Collections.singletonList(this.ioExceptionStreamer));
        Assert.assertThrows((String)"expected log exception", IOException.class, () -> StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskLog(TASK_ID, 1L).get()))));
        Assert.assertThrows((String)"expected report exception", IOException.class, () -> StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)((InputStream)switchingTaskLogStreamer.streamTaskReports(TASK_ID).get()))));
    }

    @Test
    public void empty() throws IOException {
        SwitchingTaskLogStreamer switchingTaskLogStreamer = new SwitchingTaskLogStreamer(this.emptyStreamer, Collections.singletonList(this.emptyStreamer));
        Assert.assertFalse((boolean)switchingTaskLogStreamer.streamTaskLog(TASK_ID, 1L).isPresent());
        Assert.assertFalse((boolean)switchingTaskLogStreamer.streamTaskReports(TASK_ID).isPresent());
    }

    private static String getLogString(int id, String taskid, long offset) {
        return StringUtils.format((String)"LOG with id %d, task %s and offset %d", (Object[])new Object[]{id, taskid, offset});
    }

    private static String getReportString(int id, String taskid) {
        return StringUtils.format((String)"REPORT with id %d, task %s", (Object[])new Object[]{id, taskid});
    }

    private static class TestTaskLogStreamer
    implements TaskLogStreamer {
        private final int id;

        public TestTaskLogStreamer(int id) {
            this.id = id;
        }

        public Optional<InputStream> streamTaskLog(String taskid, long offset) {
            return Optional.of((Object)new ByteArrayInputStream(SwitchingTaskLogStreamerTest.getLogString(this.id, taskid, offset).getBytes(StandardCharsets.UTF_8)));
        }

        public Optional<InputStream> streamTaskReports(String taskid) {
            return Optional.of((Object)new ByteArrayInputStream(SwitchingTaskLogStreamerTest.getReportString(this.id, taskid).getBytes(StandardCharsets.UTF_8)));
        }
    }
}

