/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.guice.IndexingServiceInputSourceModule;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.firehose.WindowedSegmentId;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.TestHelper;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DruidInputSourceTest {
    private final IndexIO indexIO = (IndexIO)EasyMock.createMock(IndexIO.class);
    private final CoordinatorClient coordinatorClient = (CoordinatorClient)EasyMock.createMock(CoordinatorClient.class);
    private final SegmentCacheManagerFactory segmentCacheManagerFactory = (SegmentCacheManagerFactory)EasyMock.createMock(SegmentCacheManagerFactory.class);
    private final RetryPolicyFactory retryPolicyFactory = (RetryPolicyFactory)EasyMock.createMock(RetryPolicyFactory.class);
    private final TaskConfig taskConfig = (TaskConfig)EasyMock.createMock(TaskConfig.class);
    private ObjectMapper mapper = null;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.mapper = TestHelper.makeJsonMapper();
        this.mapper.registerModules((Iterable)new IndexingServiceInputSourceModule().getJacksonModules());
        InjectableValues.Std injectableValues = (InjectableValues.Std)this.mapper.getInjectableValues();
        injectableValues.addValue(IndexIO.class, (Object)this.indexIO);
        injectableValues.addValue(CoordinatorClient.class, (Object)this.coordinatorClient);
        injectableValues.addValue(SegmentCacheManagerFactory.class, (Object)this.segmentCacheManagerFactory);
        injectableValues.addValue(RetryPolicyFactory.class, (Object)this.retryPolicyFactory);
        injectableValues.addValue(TaskConfig.class, (Object)this.taskConfig);
    }

    @Test
    public void testSerdeUsingIntervals() throws Exception {
        String json = "{\"type\":\"druid\",\"dataSource\":\"foo\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\"}";
        InputSource inputSource = (InputSource)this.mapper.readValue("{\"type\":\"druid\",\"dataSource\":\"foo\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\"}", InputSource.class);
        Assert.assertThat((Object)inputSource, (Matcher)CoreMatchers.instanceOf(DruidInputSource.class));
        Assert.assertEquals((Object)new DruidInputSource("foo", Intervals.of((String)"2000/2001"), null, null, null, null, this.indexIO, this.coordinatorClient, this.segmentCacheManagerFactory, this.retryPolicyFactory, this.taskConfig), (Object)inputSource);
        Assert.assertEquals((Object)"{\"type\":\"druid\",\"dataSource\":\"foo\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\"}", (Object)this.mapper.writeValueAsString((Object)inputSource));
    }

    @Test
    public void testSerdeUsingIntervalsAndLegacyDimensionsMetrics() throws Exception {
        String json = "{\"type\":\"druid\",\"dataSource\":\"foo\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\",\"dimensions\":[\"a\"],\"metrics\":[\"b\"]}";
        InputSource inputSource = (InputSource)this.mapper.readValue("{\"type\":\"druid\",\"dataSource\":\"foo\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\",\"dimensions\":[\"a\"],\"metrics\":[\"b\"]}", InputSource.class);
        Assert.assertThat((Object)inputSource, (Matcher)CoreMatchers.instanceOf(DruidInputSource.class));
        Assert.assertEquals((Object)new DruidInputSource("foo", Intervals.of((String)"2000/2001"), null, null, (List)ImmutableList.of((Object)"a"), (List)ImmutableList.of((Object)"b"), this.indexIO, this.coordinatorClient, this.segmentCacheManagerFactory, this.retryPolicyFactory, this.taskConfig), (Object)inputSource);
        Assert.assertEquals((Object)"{\"type\":\"druid\",\"dataSource\":\"foo\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\",\"dimensions\":[\"a\"],\"metrics\":[\"b\"]}", (Object)this.mapper.writeValueAsString((Object)inputSource));
    }

    @Test
    public void testSerdeUsingSegments() throws Exception {
        String json = "{\"type\":\"druid\",\"dataSource\":\"foo\",\"segments\":[{\"segmentId\":\"foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_abc123\",\"intervals\":[\"2000-01-01T00:00:00.000Z/2000-01-01T12:00:00.000Z\"]}]}";
        InputSource inputSource = (InputSource)this.mapper.readValue("{\"type\":\"druid\",\"dataSource\":\"foo\",\"segments\":[{\"segmentId\":\"foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_abc123\",\"intervals\":[\"2000-01-01T00:00:00.000Z/2000-01-01T12:00:00.000Z\"]}]}", InputSource.class);
        Assert.assertThat((Object)inputSource, (Matcher)CoreMatchers.instanceOf(DruidInputSource.class));
        Assert.assertEquals((Object)new DruidInputSource("foo", null, (List)ImmutableList.of((Object)new WindowedSegmentId("foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_abc123", (List)ImmutableList.of((Object)Intervals.of((String)"2000-01-01T00/2000-01-01T12")))), null, null, null, this.indexIO, this.coordinatorClient, this.segmentCacheManagerFactory, this.retryPolicyFactory, this.taskConfig), (Object)inputSource);
        Assert.assertEquals((Object)"{\"type\":\"druid\",\"dataSource\":\"foo\",\"segments\":[{\"segmentId\":\"foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_abc123\",\"intervals\":[\"2000-01-01T00:00:00.000Z/2000-01-01T12:00:00.000Z\"]}]}", (Object)this.mapper.writeValueAsString((Object)inputSource));
    }

    @Test
    public void testSerdeUsingBothIntervalsAndSegments() throws Exception {
        String json = "{\"type\":\"druid\",\"dataSource\":\"foo\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\",\"segments\":[  {\"segmentId\":\"foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_abc123\",   \"intervals\":[\"2000-01-01T00:00:00.000Z/2000-01-01T12:00:00.000Z\"]}]}";
        this.expectedException.expect(JsonProcessingException.class);
        this.expectedException.expectMessage("Specify exactly one of 'interval' and 'segments'");
        this.mapper.readValue("{\"type\":\"druid\",\"dataSource\":\"foo\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\",\"segments\":[  {\"segmentId\":\"foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_abc123\",   \"intervals\":[\"2000-01-01T00:00:00.000Z/2000-01-01T12:00:00.000Z\"]}]}", InputSource.class);
    }

    @Test
    public void testSerdeUsingNeitherIntervalsNorSegments() throws Exception {
        String json = "{\"type\":\"druid\",\"dataSource\":\"foo\"}";
        this.expectedException.expect(JsonProcessingException.class);
        this.expectedException.expectMessage("Specify exactly one of 'interval' and 'segments'");
        this.mapper.readValue("{\"type\":\"druid\",\"dataSource\":\"foo\"}", InputSource.class);
    }

    @Test
    public void testSerdeUsingNoDataSource() throws Exception {
        String json = "{\"type\":\"druid\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\"}";
        this.expectedException.expect(JsonProcessingException.class);
        this.expectedException.expectMessage("dataSource");
        this.mapper.readValue("{\"type\":\"druid\",\"interval\":\"2000-01-01T00:00:00.000Z/2001-01-01T00:00:00.000Z\"}", InputSource.class);
    }

    @Test
    public void testReaderColumnsFilterWithMetricGiven() {
        String datasource = "foo";
        Interval interval = Intervals.of((String)"2000/2001");
        String column = "c1";
        String metricName = "m1";
        ColumnsFilter originalColumnsFilter = ColumnsFilter.inclusionBased((Set)ImmutableSet.of((Object)column));
        InputRowSchema inputRowSchema = new InputRowSchema(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("timestamp", "a", "b"))), originalColumnsFilter, (Set)ImmutableSet.of((Object)metricName));
        DruidInputSource druidInputSource = new DruidInputSource(datasource, interval, null, null, (List)ImmutableList.of((Object)"a"), (List)ImmutableList.of((Object)"b"), this.indexIO, this.coordinatorClient, this.segmentCacheManagerFactory, this.retryPolicyFactory, this.taskConfig);
        InputRowSchema inputSourceReader = druidInputSource.getInputRowSchemaToUse(inputRowSchema);
        ColumnsFilter columnsFilter = inputSourceReader.getColumnsFilter();
        Assert.assertTrue((boolean)columnsFilter.apply(column));
        Assert.assertTrue((boolean)columnsFilter.apply(metricName));
    }

    @Test
    public void testReaderColumnsFilterWithNoMetricGiven() {
        String datasource = "foo";
        Interval interval = Intervals.of((String)"2000/2001");
        String column = "c1";
        String metricName = "m1";
        ColumnsFilter originalColumnsFilter = ColumnsFilter.inclusionBased((Set)ImmutableSet.of((Object)column));
        InputRowSchema inputRowSchema = new InputRowSchema(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("timestamp", "a", "b"))), originalColumnsFilter, (Set)ImmutableSet.of());
        DruidInputSource druidInputSource = new DruidInputSource(datasource, interval, null, null, (List)ImmutableList.of((Object)"a"), (List)ImmutableList.of((Object)"b"), this.indexIO, this.coordinatorClient, this.segmentCacheManagerFactory, this.retryPolicyFactory, this.taskConfig);
        InputRowSchema inputSourceReader = druidInputSource.getInputRowSchemaToUse(inputRowSchema);
        ColumnsFilter columnsFilter = inputSourceReader.getColumnsFilter();
        Assert.assertTrue((boolean)columnsFilter.apply(column));
        Assert.assertFalse((boolean)columnsFilter.apply(metricName));
    }
}

