/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.collect.ImmutableList;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageAdapter;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskStorageQueryAdapter;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IndexerMetadataStorageAdapterTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private TaskStorageQueryAdapter taskStorageQueryAdapter;
    private IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    private IndexerMetadataStorageAdapter indexerMetadataStorageAdapter;

    @Before
    public void setup() {
        this.indexerMetadataStorageCoordinator = (IndexerMetadataStorageCoordinator)EasyMock.strictMock(IndexerMetadataStorageCoordinator.class);
        this.taskStorageQueryAdapter = (TaskStorageQueryAdapter)EasyMock.strictMock(TaskStorageQueryAdapter.class);
        this.indexerMetadataStorageAdapter = new IndexerMetadataStorageAdapter(this.taskStorageQueryAdapter, this.indexerMetadataStorageCoordinator);
    }

    @Test
    public void testDeletePendingSegments() {
        ImmutableList taskInfos = ImmutableList.of((Object)new TaskInfo("id1", DateTimes.of((String)"2017-12-01"), (Object)TaskStatus.running((String)"id1"), "dataSource", (Object)NoopTask.create((String)"id1", (int)0)), (Object)new TaskInfo("id1", DateTimes.of((String)"2017-12-02"), (Object)TaskStatus.running((String)"id2"), "dataSource", (Object)NoopTask.create((String)"id2", (int)0)));
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getActiveTaskInfo("dataSource")).andReturn((Object)taskInfos);
        Interval deleteInterval = Intervals.of((String)"2017-01-01/2017-12-01");
        EasyMock.expect((Object)this.indexerMetadataStorageCoordinator.deletePendingSegmentsCreatedInInterval(EasyMock.anyString(), (Interval)EasyMock.eq((Object)deleteInterval))).andReturn((Object)10);
        EasyMock.replay((Object[])new Object[]{this.taskStorageQueryAdapter, this.indexerMetadataStorageCoordinator});
        Assert.assertEquals((long)10L, (long)this.indexerMetadataStorageAdapter.deletePendingSegments("dataSource", deleteInterval));
    }

    @Test
    public void testDeletePendingSegmentsOfRunningTasks() {
        ImmutableList taskInfos = ImmutableList.of((Object)new TaskInfo("id1", DateTimes.of((String)"2017-11-01"), (Object)TaskStatus.running((String)"id1"), "dataSource", (Object)NoopTask.create((String)"id1", (int)0)), (Object)new TaskInfo("id1", DateTimes.of((String)"2017-12-02"), (Object)TaskStatus.running((String)"id2"), "dataSource", (Object)NoopTask.create((String)"id2", (int)0)));
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getActiveTaskInfo("dataSource")).andReturn((Object)taskInfos);
        Interval deleteInterval = Intervals.of((String)"2017-01-01/2017-12-01");
        EasyMock.expect((Object)this.indexerMetadataStorageCoordinator.deletePendingSegmentsCreatedInInterval(EasyMock.anyString(), (Interval)EasyMock.eq((Object)deleteInterval))).andReturn((Object)10);
        EasyMock.replay((Object[])new Object[]{this.taskStorageQueryAdapter, this.indexerMetadataStorageCoordinator});
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalArgumentException.class));
        this.expectedException.expectMessage("Cannot delete pendingSegments because there is at least one active task created");
        this.indexerMetadataStorageAdapter.deletePendingSegments("dataSource", deleteInterval);
    }
}

