/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingCluster;
import org.apache.druid.common.guava.DSuppliers;
import org.apache.druid.curator.PotentiallyGzippedCompressionProvider;
import org.apache.druid.curator.cache.PathChildrenCacheFactory;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.IndexingServiceCondition;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.RemoteTaskRunner;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.autoscaling.NoopProvisioningStrategy;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningStrategy;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.DefaultWorkerBehaviorConfig;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.server.initialization.IndexerZkConfig;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.zookeeper.CreateMode;

public class RemoteTaskRunnerTestUtils {
    static final Joiner JOINER = Joiner.on((String)"/");
    static final String BASE_PATH = "/test/druid";
    static final String ANNOUNCEMENTS_PATH = StringUtils.format((String)"%s/indexer/announcements", (Object[])new Object[]{"/test/druid"});
    static final String TASKS_PATH = StringUtils.format((String)"%s/indexer/tasks", (Object[])new Object[]{"/test/druid"});
    static final String STATUS_PATH = StringUtils.format((String)"%s/indexer/status", (Object[])new Object[]{"/test/druid"});
    static final TaskLocation DUMMY_LOCATION = TaskLocation.create((String)"dummy", (int)9000, (int)-1);
    private TestingCluster testingCluster;
    private CuratorFramework cf;
    private ObjectMapper jsonMapper;

    RemoteTaskRunnerTestUtils() {
        TestUtils testUtils = new TestUtils();
        this.jsonMapper = testUtils.getTestObjectMapper();
    }

    CuratorFramework getCuratorFramework() {
        return this.cf;
    }

    ObjectMapper getObjectMapper() {
        return this.jsonMapper;
    }

    void setUp() throws Exception {
        this.testingCluster = new TestingCluster(1);
        this.testingCluster.start();
        this.cf = CuratorFrameworkFactory.builder().connectString(this.testingCluster.getConnectString()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1, 10)).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(false)).build();
        this.cf.start();
        this.cf.blockUntilConnected();
        this.cf.create().creatingParentsIfNeeded().forPath(BASE_PATH);
        this.cf.create().creatingParentsIfNeeded().forPath(TASKS_PATH);
    }

    void tearDown() throws Exception {
        this.cf.close();
        this.testingCluster.stop();
    }

    RemoteTaskRunner makeRemoteTaskRunner(RemoteTaskRunnerConfig config, HttpClient httpClient) {
        NoopProvisioningStrategy resourceManagement = new NoopProvisioningStrategy();
        return this.makeRemoteTaskRunner(config, (ProvisioningStrategy<WorkerTaskRunner>)resourceManagement, httpClient);
    }

    public RemoteTaskRunner makeRemoteTaskRunner(RemoteTaskRunnerConfig config, ProvisioningStrategy<WorkerTaskRunner> provisioningStrategy, HttpClient httpClient) {
        TestableRemoteTaskRunner remoteTaskRunner = new TestableRemoteTaskRunner(this.jsonMapper, config, new IndexerZkConfig(new ZkPathsConfig(){

            public String getBase() {
                return RemoteTaskRunnerTestUtils.BASE_PATH;
            }
        }, null, null, null, null), this.cf, new PathChildrenCacheFactory.Builder(), httpClient, (Supplier<WorkerBehaviorConfig>)DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), provisioningStrategy);
        remoteTaskRunner.start();
        return remoteTaskRunner;
    }

    Worker makeWorker(String workerId, int capacity) throws Exception {
        Worker worker = new Worker("http", workerId, workerId, capacity, "0", "_default_worker_category");
        ((ACLBackgroundPathAndBytesable)this.cf.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(JOINER.join((Object)ANNOUNCEMENTS_PATH, (Object)workerId, new Object[0]), this.jsonMapper.writeValueAsBytes((Object)worker));
        this.cf.create().creatingParentsIfNeeded().forPath(JOINER.join((Object)TASKS_PATH, (Object)workerId, new Object[0]));
        return worker;
    }

    void disableWorker(Worker worker) throws Exception {
        this.cf.setData().forPath(JOINER.join((Object)ANNOUNCEMENTS_PATH, (Object)worker.getHost(), new Object[0]), this.jsonMapper.writeValueAsBytes((Object)new Worker(worker.getScheme(), worker.getHost(), worker.getIp(), worker.getCapacity(), "", worker.getCategory())));
    }

    void mockWorkerRunningTask(String workerId, Task task) throws Exception {
        this.cf.delete().forPath(JOINER.join((Object)TASKS_PATH, (Object)workerId, new Object[]{task.getId()}));
        String taskStatusPath = JOINER.join((Object)STATUS_PATH, (Object)workerId, new Object[]{task.getId()});
        TaskAnnouncement taskAnnouncement = TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.running((String)task.getId()), (TaskLocation)DUMMY_LOCATION);
        this.cf.create().creatingParentsIfNeeded().forPath(taskStatusPath, this.jsonMapper.writeValueAsBytes((Object)taskAnnouncement));
        Preconditions.checkNotNull((Object)this.cf.checkExists().forPath(taskStatusPath), (String)"Failed to write status on [%s]", (Object[])new Object[]{taskStatusPath});
    }

    void mockWorkerCompleteSuccessfulTask(String workerId, Task task) throws Exception {
        TaskAnnouncement taskAnnouncement = TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.success((String)task.getId()), (TaskLocation)DUMMY_LOCATION);
        this.cf.setData().forPath(JOINER.join((Object)STATUS_PATH, (Object)workerId, new Object[]{task.getId()}), this.jsonMapper.writeValueAsBytes((Object)taskAnnouncement));
    }

    void mockWorkerCompleteFailedTask(String workerId, Task task) throws Exception {
        TaskAnnouncement taskAnnouncement = TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.failure((String)task.getId(), (String)"Dummy task status failure for testing"), (TaskLocation)DUMMY_LOCATION);
        this.cf.setData().forPath(JOINER.join((Object)STATUS_PATH, (Object)workerId, new Object[]{task.getId()}), this.jsonMapper.writeValueAsBytes((Object)taskAnnouncement));
    }

    boolean workerRunningTask(String workerId, String taskId) {
        return this.pathExists(JOINER.join((Object)STATUS_PATH, (Object)workerId, new Object[]{taskId}));
    }

    boolean taskAnnounced(String workerId, String taskId) {
        return this.pathExists(JOINER.join((Object)TASKS_PATH, (Object)workerId, new Object[]{taskId}));
    }

    boolean pathExists(final String path) {
        return TestUtils.conditionValid(new IndexingServiceCondition(){

            @Override
            public boolean isValid() {
                try {
                    return RemoteTaskRunnerTestUtils.this.cf.checkExists().forPath(path) != null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return StringUtils.format((String)"Path[%s] exists", (Object[])new Object[]{path});
            }
        });
    }

    public static class TestableRemoteTaskRunner
    extends RemoteTaskRunner {
        private long currentTimeMillis = System.currentTimeMillis();

        public TestableRemoteTaskRunner(ObjectMapper jsonMapper, RemoteTaskRunnerConfig config, IndexerZkConfig indexerZkConfig, CuratorFramework cf, PathChildrenCacheFactory.Builder pathChildrenCacheFactory, HttpClient httpClient, Supplier<WorkerBehaviorConfig> workerConfigRef, ProvisioningStrategy<WorkerTaskRunner> provisioningStrategy) {
            super(jsonMapper, config, indexerZkConfig, cf, pathChildrenCacheFactory, httpClient, workerConfigRef, provisioningStrategy, (ServiceEmitter)new NoopServiceEmitter());
        }

        void setCurrentTimeMillis(long currentTimeMillis) {
            this.currentTimeMillis = currentTimeMillis;
        }

        protected long getCurrentTimeMillis() {
            return this.currentTimeMillis;
        }
    }
}

