/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.common.guava.DSuppliers;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TestTasks;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.RemoteTaskRunner;
import org.apache.druid.indexing.overlord.RemoteTaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.ZkWorker;
import org.apache.druid.indexing.overlord.autoscaling.AutoScaler;
import org.apache.druid.indexing.overlord.autoscaling.AutoScalingData;
import org.apache.druid.indexing.overlord.autoscaling.PendingTaskBasedWorkerProvisioningConfig;
import org.apache.druid.indexing.overlord.autoscaling.PendingTaskBasedWorkerProvisioningStrategy;
import org.apache.druid.indexing.overlord.autoscaling.Provisioner;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningSchedulerConfig;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.indexing.overlord.autoscaling.SimpleWorkerProvisioningConfig;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.DefaultWorkerBehaviorConfig;
import org.apache.druid.indexing.overlord.setup.FillCapacityWorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.indexing.overlord.setup.WorkerSelectStrategy;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PendingTaskBasedProvisioningStrategyTest {
    private AutoScaler autoScaler;
    private Task testTask;
    private PendingTaskBasedWorkerProvisioningConfig config;
    private PendingTaskBasedWorkerProvisioningStrategy strategy;
    private AtomicReference<WorkerBehaviorConfig> workerConfig;
    private ScheduledExecutorService executorService = Execs.scheduledSingleThreaded((String)"test service");
    private static final String MIN_VERSION = "2014-01-00T00:01:00Z";
    private static final String INVALID_VERSION = "0";

    @Before
    public void setUp() {
        this.autoScaler = (AutoScaler)EasyMock.createMock(AutoScaler.class);
        this.testTask = TestTasks.immediateSuccess("task1");
        this.config = new PendingTaskBasedWorkerProvisioningConfig().setMaxScalingDuration(new Period(1000L)).setNumEventsToTrack(10).setPendingTaskTimeout(new Period(0L)).setWorkerVersion(MIN_VERSION).setMaxScalingStep(2);
        this.workerConfig = new AtomicReference<DefaultWorkerBehaviorConfig>(new DefaultWorkerBehaviorConfig((WorkerSelectStrategy)new FillCapacityWorkerSelectStrategy(null), this.autoScaler));
        this.strategy = new PendingTaskBasedWorkerProvisioningStrategy(this.config, DSuppliers.of(this.workerConfig), new ProvisioningSchedulerConfig(), (Supplier)new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return PendingTaskBasedProvisioningStrategyTest.this.executorService;
            }
        });
    }

    @Test
    public void testGetExpectedWorkerCapacityWithNoWorkerAndHintIsValid() {
        int capacityHint = 10;
        this.config = new PendingTaskBasedWorkerProvisioningConfig().setMaxScalingDuration(new Period(1000L)).setNumEventsToTrack(10).setPendingTaskTimeout(new Period(0L)).setWorkerVersion(MIN_VERSION).setMaxScalingStep(2).setWorkerCapacityHint(capacityHint);
        this.strategy = new PendingTaskBasedWorkerProvisioningStrategy(this.config, DSuppliers.of(this.workerConfig), new ProvisioningSchedulerConfig(), (Supplier)new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return PendingTaskBasedProvisioningStrategyTest.this.executorService;
            }
        });
        int expectedWorkerCapacity = this.strategy.getExpectedWorkerCapacity((Collection)ImmutableList.of());
        Assert.assertEquals((long)capacityHint, (long)expectedWorkerCapacity);
    }

    @Test
    public void testGetExpectedWorkerCapacityWithNoWorkerAndHintIsNotValid() {
        int capacityHint = -1;
        this.config = new PendingTaskBasedWorkerProvisioningConfig().setMaxScalingDuration(new Period(1000L)).setNumEventsToTrack(10).setPendingTaskTimeout(new Period(0L)).setWorkerVersion(MIN_VERSION).setMaxScalingStep(2).setWorkerCapacityHint(capacityHint);
        this.strategy = new PendingTaskBasedWorkerProvisioningStrategy(this.config, DSuppliers.of(this.workerConfig), new ProvisioningSchedulerConfig(), (Supplier)new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return PendingTaskBasedProvisioningStrategyTest.this.executorService;
            }
        });
        int expectedWorkerCapacity = this.strategy.getExpectedWorkerCapacity((Collection)ImmutableList.of());
        Assert.assertEquals((long)1L, (long)expectedWorkerCapacity);
    }

    @Test
    public void testGetExpectedWorkerCapacityWithSingleWorker() {
        int workerCapacity = 3;
        ImmutableList workerInfoCollection = ImmutableList.of((Object)new ImmutableWorkerInfo(new Worker("http", "localhost0", "localhost0", workerCapacity, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()));
        int expectedWorkerCapacity = this.strategy.getExpectedWorkerCapacity((Collection)workerInfoCollection);
        Assert.assertEquals((long)workerCapacity, (long)expectedWorkerCapacity);
    }

    @Test
    public void testGetExpectedWorkerCapacityWithMultipleWorker() {
        int workerOneCapacity = 3;
        int workerTwoCapacity = 6;
        ImmutableList workerInfoCollection = ImmutableList.of((Object)new ImmutableWorkerInfo(new Worker("http", "localhost0", "localhost0", workerOneCapacity, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)new ImmutableWorkerInfo(new Worker("http", "localhost0", "localhost0", workerTwoCapacity + 3, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()));
        int expectedWorkerCapacity = this.strategy.getExpectedWorkerCapacity((Collection)workerInfoCollection);
        Assert.assertEquals((long)workerOneCapacity, (long)expectedWorkerCapacity);
    }

    @Test
    public void testFailIfMinWorkerIsZeroAndWorkerHintNotSet() {
        EmittingLogger mockLogger = (EmittingLogger)EasyMock.createMock(EmittingLogger.class);
        Capture capturedArgument = Capture.newInstance();
        mockLogger.error((String)EasyMock.capture((Capture)capturedArgument), new Object[]{EasyMock.anyInt()});
        PendingTaskBasedWorkerProvisioningConfig config = new PendingTaskBasedWorkerProvisioningConfig().setMaxScalingDuration(new Period(1000L)).setNumEventsToTrack(10).setPendingTaskTimeout(new Period(0L)).setWorkerVersion(MIN_VERSION).setMaxScalingStep(2);
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0);
        EasyMock.replay((Object[])new Object[]{this.autoScaler, mockLogger});
        DefaultWorkerBehaviorConfig defaultWorkerBehaviorConfig = PendingTaskBasedWorkerProvisioningStrategy.getDefaultWorkerBehaviorConfig((Supplier)DSuppliers.of(this.workerConfig), (SimpleWorkerProvisioningConfig)config, (String)"test", (EmittingLogger)mockLogger);
        Assert.assertNull((Object)defaultWorkerBehaviorConfig);
        Assert.assertEquals((Object)"As minNumWorkers is set to 0, workerCapacityHint must be greater than 0. workerCapacityHint value set is %d", (Object)capturedArgument.getValue());
    }

    @Test
    public void testSuccessfulInitialMinWorkersProvision() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)3).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)5);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList());
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(new ArrayList());
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.emptyList());
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig());
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("aNode"))).times(3);
        EasyMock.replay((Object[])new Object[]{runner, this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 3 ? 1 : 0) != 0);
        for (ScalingStats.ScalingEvent event : provisioner.getStats().toList()) {
            Assert.assertTrue((event.getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testProvisionNoCurrentlyRunningWorkerWithCapacityHintSetAndNoPendingTaskShouldProvisionMinimumAsCurrentIsBelowMinimum() {
        PendingTaskBasedWorkerProvisioningConfig config = new PendingTaskBasedWorkerProvisioningConfig().setMaxScalingDuration(new Period(1000L)).setNumEventsToTrack(10).setPendingTaskTimeout(new Period(0L)).setWorkerVersion(MIN_VERSION).setMaxScalingStep(2).setWorkerCapacityHint(30);
        this.strategy = new PendingTaskBasedWorkerProvisioningStrategy(config, DSuppliers.of(this.workerConfig), new ProvisioningSchedulerConfig(), (Supplier)new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return PendingTaskBasedProvisioningStrategyTest.this.executorService;
            }
        });
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)3).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)5);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList());
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(new ArrayList());
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.emptyList());
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig());
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("aNode"))).times(3);
        EasyMock.replay((Object[])new Object[]{runner, this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 3 ? 1 : 0) != 0);
        for (ScalingStats.ScalingEvent event : provisioner.getStats().toList()) {
            Assert.assertTrue((event.getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testProvisionNoCurrentlyRunningWorkerWithCapacityHintSetAndNoPendingTaskShouldNotProvisionAsMinimumIsZero() {
        PendingTaskBasedWorkerProvisioningConfig config = new PendingTaskBasedWorkerProvisioningConfig().setMaxScalingDuration(new Period(1000L)).setNumEventsToTrack(10).setPendingTaskTimeout(new Period(0L)).setWorkerVersion(MIN_VERSION).setMaxScalingStep(2).setWorkerCapacityHint(30);
        this.strategy = new PendingTaskBasedWorkerProvisioningStrategy(config, DSuppliers.of(this.workerConfig), new ProvisioningSchedulerConfig(), (Supplier)new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return PendingTaskBasedProvisioningStrategyTest.this.executorService;
            }
        });
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)5);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList());
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(new ArrayList());
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.emptyList());
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig());
        EasyMock.replay((Object[])new Object[]{runner, this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        Assert.assertEquals((long)0L, (long)provisioner.getStats().toList().size());
    }

    @Test
    public void testSuccessfulMinWorkersProvision() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)3).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)5);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList());
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(new ArrayList());
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).toImmutable()));
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig());
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("aNode"))).times(2);
        EasyMock.replay((Object[])new Object[]{runner, this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 2 ? 1 : 0) != 0);
        for (ScalingStats.ScalingEvent event : provisioner.getStats().toList()) {
            Assert.assertTrue((event.getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSuccessfulMinWorkersProvisionWithOldVersionNodeRunning() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)3).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)5);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList());
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(new ArrayList());
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Arrays.asList(new TestZkWorker(this.testTask).toImmutable(), new TestZkWorker(this.testTask, "http", "h1", "n1", INVALID_VERSION).toImmutable()));
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig());
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("aNode"))).times(2);
        EasyMock.replay((Object[])new Object[]{runner, this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 2 ? 1 : 0) != 0);
        for (ScalingStats.ScalingEvent event : provisioner.getStats().toList()) {
            Assert.assertTrue((event.getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testProvisioning() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)1).times(3);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2).times(1);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList()).times(2);
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("fake")));
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(Collections.singletonList(NoopTask.create())).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Arrays.asList(new TestZkWorker(this.testTask).toImmutable(), new TestZkWorker(this.testTask, "http", "h1", "n1", INVALID_VERSION).toImmutable())).times(2);
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig()).times(1);
        EasyMock.replay((Object[])new Object[]{runner});
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        DateTime createdTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        DateTime anotherCreatedTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((boolean)createdTime.equals((Object)anotherCreatedTime));
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testProvisionWithPendingTaskAndWorkerCapacityHintSetButNonEmptyCurrentlyRunningWorkerShouldUseCapcityFromRunningWorker() {
        PendingTaskBasedWorkerProvisioningConfig config = new PendingTaskBasedWorkerProvisioningConfig().setMaxScalingDuration(new Period(1000L)).setNumEventsToTrack(10).setPendingTaskTimeout(new Period(0L)).setWorkerVersion(MIN_VERSION).setMaxScalingStep(2).setWorkerCapacityHint(30);
        this.strategy = new PendingTaskBasedWorkerProvisioningStrategy(config, DSuppliers.of(this.workerConfig), new ProvisioningSchedulerConfig(), (Supplier)new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return PendingTaskBasedProvisioningStrategyTest.this.executorService;
            }
        });
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0).times(3);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)3).times(1);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList()).times(2);
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("fake"))).times(2);
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn((Object)ImmutableList.of((Object)NoopTask.create(), (Object)NoopTask.create())).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Arrays.asList(new TestZkWorker(this.testTask).toImmutable(), new TestZkWorker(this.testTask, "http", "h1", "n1", INVALID_VERSION).toImmutable())).times(2);
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig()).times(1);
        EasyMock.replay((Object[])new Object[]{runner});
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertEquals((long)2L, (long)provisioner.getStats().toList().size());
        DateTime createdTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertEquals((Object)ScalingStats.EVENT.PROVISION, (Object)((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent());
        Assert.assertEquals((Object)ScalingStats.EVENT.PROVISION, (Object)((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(1)).getEvent());
        provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        DateTime anotherCreatedTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((boolean)createdTime.equals((Object)anotherCreatedTime));
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testProvisionWithPendingTaskAndWorkerCapacityHintSetButEmptyCurrentlyRunningWorkerShouldUseCapcityFromHintConfig() {
        PendingTaskBasedWorkerProvisioningConfig config = new PendingTaskBasedWorkerProvisioningConfig().setMaxScalingDuration(new Period(1000L)).setNumEventsToTrack(10).setPendingTaskTimeout(new Period(0L)).setWorkerVersion(MIN_VERSION).setMaxScalingStep(2).setWorkerCapacityHint(30);
        this.strategy = new PendingTaskBasedWorkerProvisioningStrategy(config, DSuppliers.of(this.workerConfig), new ProvisioningSchedulerConfig(), (Supplier)new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return PendingTaskBasedProvisioningStrategyTest.this.executorService;
            }
        });
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0).times(3);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)3).times(1);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList()).times(2);
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("fake"))).times(1);
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn((Object)ImmutableList.of((Object)NoopTask.create(), (Object)NoopTask.create())).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.emptyList()).times(2);
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig()).times(1);
        EasyMock.replay((Object[])new Object[]{runner});
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertEquals((long)1L, (long)provisioner.getStats().toList().size());
        DateTime createdTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertEquals((Object)ScalingStats.EVENT.PROVISION, (Object)((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent());
        provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        DateTime anotherCreatedTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((boolean)createdTime.equals((Object)anotherCreatedTime));
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testProvisionAlert() throws Exception {
        ServiceEmitter emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        EmittingLogger.registerEmitter((ServiceEmitter)emitter);
        emitter.emit((ServiceEventBuilder)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{emitter});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)1).times(3);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2).times(1);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList()).times(2);
        EasyMock.expect((Object)this.autoScaler.terminateWithIds((List)EasyMock.anyObject())).andReturn(null);
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("fake")));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(Collections.singletonList(NoopTask.create())).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Arrays.asList(new TestZkWorker(this.testTask, "http", "hi", "lo", MIN_VERSION, 1).toImmutable(), new TestZkWorker(this.testTask, "http", "h1", "n1", INVALID_VERSION).toImmutable(), new TestZkWorker(this.testTask, "http", "h2", "n1", INVALID_VERSION).toImmutable())).times(2);
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig());
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        DateTime createdTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        Thread.sleep(2000L);
        provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        DateTime anotherCreatedTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((boolean)createdTime.equals((Object)anotherCreatedTime));
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{emitter});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testDoSuccessfulTerminate() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList());
        EasyMock.expect((Object)this.autoScaler.terminate((List)EasyMock.anyObject())).andReturn((Object)new AutoScalingData(new ArrayList()));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTasks()).andReturn(Collections.singletonList(new RemoteTaskRunnerWorkItem(this.testTask.getId(), this.testTask.getType(), null, TaskLocation.unknown(), this.testTask.getDataSource()).withQueueInsertionTime(DateTimes.nowUtc()))).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn((Object)ImmutableList.of((Object)new TestZkWorker(this.testTask).toImmutable(), (Object)new TestZkWorker(this.testTask).toImmutable())).times(2);
        EasyMock.expect((Object)runner.markWorkersLazy((Predicate)EasyMock.anyObject(), EasyMock.anyInt())).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).getWorker()));
        EasyMock.expect((Object)runner.getLazyWorkers()).andReturn(new ArrayList());
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        Assert.assertTrue((boolean)terminatedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.TERMINATE ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
    }

    @Test
    public void testSomethingTerminating() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)1).times(3);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip")).times(2);
        EasyMock.expect((Object)this.autoScaler.terminate((List)EasyMock.anyObject())).andReturn((Object)new AutoScalingData(Collections.singletonList("ip")));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getWorkers()).andReturn((Object)ImmutableList.of((Object)new TestZkWorker(this.testTask).toImmutable(), (Object)new TestZkWorker(this.testTask).toImmutable(), (Object)new TestZkWorker(this.testTask).toImmutable())).times(2);
        EasyMock.expect((Object)runner.getLazyWorkers()).andReturn(new ArrayList()).times(2);
        EasyMock.expect((Object)runner.markWorkersLazy((Predicate)EasyMock.anyObject(), EasyMock.anyInt())).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).toImmutable().getWorker()));
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        Assert.assertTrue((boolean)terminatedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.TERMINATE ? 1 : 0) != 0);
        terminatedSomething = provisioner.doTerminate();
        Assert.assertFalse((boolean)terminatedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.TERMINATE ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testNoActionNeeded() {
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(Collections.singletonList(NoopTask.create())).times(1);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Arrays.asList(new TestZkWorker((Task)NoopTask.create()).toImmutable(), new TestZkWorker((Task)NoopTask.create()).toImmutable())).times(2);
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig());
        EasyMock.expect((Object)runner.getLazyWorkers()).andReturn(new ArrayList());
        EasyMock.expect((Object)runner.markWorkersLazy((Predicate)EasyMock.anyObject(), EasyMock.anyInt())).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        Assert.assertFalse((boolean)terminatedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testMinCountIncrease() {
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(Collections.emptyList()).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker((Task)NoopTask.create(), "http", "h1", "i1", MIN_VERSION).toImmutable())).times(3);
        EasyMock.expect((Object)runner.getConfig()).andReturn((Object)new RemoteTaskRunnerConfig()).times(2);
        EasyMock.expect((Object)runner.getLazyWorkers()).andReturn(new ArrayList());
        EasyMock.expect((Object)runner.markWorkersLazy((Predicate)EasyMock.anyObject(), EasyMock.anyInt())).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        Assert.assertFalse((boolean)terminatedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)3).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)5);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("h3")));
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("h4")));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testNullWorkerConfig() {
        this.workerConfig.set(null);
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTaskPayloads()).andReturn(Collections.singletonList(NoopTask.create())).times(1);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker(null).toImmutable())).times(2);
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)terminatedSomething);
        Assert.assertFalse((boolean)provisionedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    private static class TestZkWorker
    extends ZkWorker {
        private final Task testTask;

        public TestZkWorker(Task testTask) {
            this(testTask, "http", "host", "ip", PendingTaskBasedProvisioningStrategyTest.MIN_VERSION);
        }

        public TestZkWorker(Task testTask, String scheme, String host, String ip, String version) {
            this(testTask, scheme, host, ip, version, 1);
        }

        public TestZkWorker(Task testTask, String scheme, String host, String ip, String version, int capacity) {
            super(new Worker(scheme, host, ip, capacity, version, "_default_worker_category"), null, (ObjectMapper)new DefaultObjectMapper());
            this.testTask = testTask;
        }

        public Map<String, TaskAnnouncement> getRunningTasks() {
            if (this.testTask == null) {
                return new HashMap<String, TaskAnnouncement>();
            }
            return ImmutableMap.of((Object)this.testTask.getId(), (Object)TaskAnnouncement.create((Task)this.testTask, (TaskStatus)TaskStatus.running((String)this.testTask.getId()), (TaskLocation)TaskLocation.unknown()));
        }
    }
}

