/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http.security;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.sun.jersey.spi.container.ResourceFilter;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskStorageQueryAdapter;
import org.apache.druid.indexing.overlord.http.OverlordResource;
import org.apache.druid.indexing.overlord.http.security.SupervisorResourceFilter;
import org.apache.druid.indexing.overlord.http.security.TaskResourceFilter;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorResource;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.NoopTaskAutoScaler;
import org.apache.druid.indexing.worker.http.WorkerResource;
import org.apache.druid.server.http.security.ResourceFilterTestHelper;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OverlordSecurityResourceFilterTest
extends ResourceFilterTestHelper {
    private static final Pattern WORD = Pattern.compile("\\w+");
    private final String requestPath;
    private final String requestMethod;
    private final ResourceFilter resourceFilter;
    private final Injector injector;
    private final Task noopTask = NoopTask.create();
    private static boolean mockedOnceTsqa;
    private static boolean mockedOnceSM;
    private TaskStorageQueryAdapter tsqa;
    private SupervisorManager supervisorManager;

    @Parameterized.Parameters(name="{index}: requestPath={0}, requestMethod={1}, resourceFilter={2}")
    public static Collection<Object[]> data() {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)OverlordSecurityResourceFilterTest.getRequestPaths(OverlordResource.class, (Iterable)ImmutableList.of(TaskStorageQueryAdapter.class, AuthorizerMapper.class)), (Iterable)OverlordSecurityResourceFilterTest.getRequestPaths(WorkerResource.class, (Iterable)ImmutableList.of(AuthorizerMapper.class)), (Iterable)OverlordSecurityResourceFilterTest.getRequestPaths(SupervisorResource.class, (Iterable)ImmutableList.of(SupervisorManager.class, AuthorizerMapper.class))));
    }

    public OverlordSecurityResourceFilterTest(String requestPath, String requestMethod, ResourceFilter resourceFilter, Injector injector) {
        this.requestPath = requestPath;
        this.requestMethod = requestMethod;
        this.resourceFilter = resourceFilter;
        this.injector = injector;
    }

    @Before
    public void setUp() {
        if (this.resourceFilter instanceof TaskResourceFilter && !mockedOnceTsqa) {
            this.tsqa = (TaskStorageQueryAdapter)this.injector.getInstance(TaskStorageQueryAdapter.class);
            EasyMock.expect((Object)this.tsqa.getTask(EasyMock.anyString())).andReturn((Object)Optional.of((Object)this.noopTask)).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.tsqa});
            mockedOnceTsqa = true;
        }
        if (this.resourceFilter instanceof SupervisorResourceFilter && !mockedOnceSM) {
            this.supervisorManager = (SupervisorManager)this.injector.getInstance(SupervisorManager.class);
            SupervisorSpec supervisorSpec = new SupervisorSpec(){

                public String getId() {
                    return "id";
                }

                public Supervisor createSupervisor() {
                    return null;
                }

                public SupervisorTaskAutoScaler createAutoscaler(Supervisor supervisor) {
                    return new NoopTaskAutoScaler();
                }

                public List<String> getDataSources() {
                    return ImmutableList.of((Object)"test");
                }

                public SupervisorSpec createSuspendedSpec() {
                    return null;
                }

                public SupervisorSpec createRunningSpec() {
                    return null;
                }

                public boolean isSuspended() {
                    return false;
                }

                public String getType() {
                    return null;
                }

                public String getSource() {
                    return null;
                }
            };
            EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(EasyMock.anyString())).andReturn((Object)Optional.of((Object)supervisorSpec)).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.supervisorManager});
            mockedOnceSM = true;
        }
        this.setUp(this.resourceFilter);
    }

    @Test
    public void testResourcesFilteringAccess() {
        this.setUpMockExpectations(this.requestPath, true, this.requestMethod);
        EasyMock.expect((Object)this.request.getEntity(Task.class)).andReturn((Object)this.noopTask).anyTimes();
        EasyMock.expect((Object)this.request.getMethod()).andReturn((Object)this.requestMethod).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
        this.resourceFilter.getRequestFilter().filter(this.request);
    }

    @Test(expected=ForbiddenException.class)
    public void testDatasourcesResourcesFilteringNoAccess() {
        this.setUpMockExpectations(this.requestPath, false, this.requestMethod);
        EasyMock.expect((Object)this.request.getEntity(Task.class)).andReturn((Object)this.noopTask).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
        this.resourceFilter.getRequestFilter().filter(this.request);
    }

    @Test
    public void testDatasourcesResourcesFilteringBadPath() {
        String badRequestPath = WORD.matcher(this.requestPath).replaceAll("droid");
        EasyMock.expect((Object)this.request.getPath()).andReturn((Object)badRequestPath).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
        if (this.tsqa != null) {
            EasyMock.verify((Object[])new Object[]{this.tsqa});
        }
        if (this.supervisorManager != null) {
            EasyMock.verify((Object[])new Object[]{this.supervisorManager});
        }
    }
}

