/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.EqualDistributionWithCategorySpecWorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.WorkerCategorySpec;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.DateTimes;
import org.junit.Assert;
import org.junit.Test;

public class EqualDistributionWithCategorySpecWorkerSelectStrategyTest {
    private static final ImmutableMap<String, ImmutableWorkerInfo> WORKERS_FOR_TIER_TESTS = ImmutableMap.of((Object)"localhost0", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost0", "localhost0", 1, "v1", "c1"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost1", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost1", "localhost1", 2, "v1", "c1"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost2", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost2", "localhost2", 3, "v1", "c2"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost3", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost3", "localhost3", 4, "v1", "c2"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()));

    @Test
    public void testFindWorkerForTaskWithNullWorkerTierSpec() {
        ImmutableWorkerInfo worker = this.selectWorker(null);
        Assert.assertEquals((Object)"localhost3", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testFindWorkerForTaskWithPreferredTier() {
        WorkerCategorySpec workerCategorySpec1 = new WorkerCategorySpec((Map)ImmutableMap.of((Object)"noop", (Object)new WorkerCategorySpec.CategoryConfig("c2", (Map)ImmutableMap.of((Object)"ds1", (Object)"c2"))), false);
        ImmutableWorkerInfo worker1 = this.selectWorker(workerCategorySpec1);
        Assert.assertEquals((Object)"localhost3", (Object)worker1.getWorker().getHost());
        WorkerCategorySpec workerCategorySpec2 = new WorkerCategorySpec((Map)ImmutableMap.of((Object)"noop", (Object)new WorkerCategorySpec.CategoryConfig(null, (Map)ImmutableMap.of((Object)"ds1", (Object)"c2"))), false);
        ImmutableWorkerInfo worker2 = this.selectWorker(workerCategorySpec2);
        Assert.assertEquals((Object)"localhost3", (Object)worker2.getWorker().getHost());
        WorkerCategorySpec workerCategorySpec3 = new WorkerCategorySpec((Map)ImmutableMap.of((Object)"noop", (Object)new WorkerCategorySpec.CategoryConfig("c2", null)), false);
        ImmutableWorkerInfo worker3 = this.selectWorker(workerCategorySpec3);
        Assert.assertEquals((Object)"localhost3", (Object)worker3.getWorker().getHost());
    }

    @Test
    public void testFindWorkerForTaskWithNullPreferredTier() {
        WorkerCategorySpec workerCategorySpec = new WorkerCategorySpec((Map)ImmutableMap.of((Object)"noop", (Object)new WorkerCategorySpec.CategoryConfig(null, null)), false);
        ImmutableWorkerInfo worker = this.selectWorker(workerCategorySpec);
        Assert.assertEquals((Object)"localhost3", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testWeakTierSpec() {
        WorkerCategorySpec workerCategorySpec = new WorkerCategorySpec((Map)ImmutableMap.of((Object)"noop", (Object)new WorkerCategorySpec.CategoryConfig("c1", (Map)ImmutableMap.of((Object)"ds1", (Object)"c3"))), false);
        ImmutableWorkerInfo worker = this.selectWorker(workerCategorySpec);
        Assert.assertEquals((Object)"localhost3", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testStrongTierSpec() {
        WorkerCategorySpec workerCategorySpec = new WorkerCategorySpec((Map)ImmutableMap.of((Object)"noop", (Object)new WorkerCategorySpec.CategoryConfig("c1", (Map)ImmutableMap.of((Object)"ds1", (Object)"c3"))), true);
        ImmutableWorkerInfo worker = this.selectWorker(workerCategorySpec);
        Assert.assertNull((Object)worker);
    }

    private ImmutableWorkerInfo selectWorker(WorkerCategorySpec workerCategorySpec) {
        EqualDistributionWithCategorySpecWorkerSelectStrategy strategy = new EqualDistributionWithCategorySpecWorkerSelectStrategy(workerCategorySpec);
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), WORKERS_FOR_TIER_TESTS, (Task)new NoopTask(null, null, "ds1", 1L, 0L, null, null, null));
        return worker;
    }
}

