/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.seekablestream.SeekableStreamDataSourceMetadata;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SequenceMetadata;
import org.apache.druid.indexing.seekablestream.common.OrderedPartitionableRecord;
import org.apache.druid.indexing.seekablestream.common.OrderedSequenceNumber;
import org.apache.druid.indexing.seekablestream.common.RecordSupplier;
import org.apache.druid.indexing.seekablestream.common.StreamPartition;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.AllGranularity;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SeekableStreamIndexTaskRunnerAuthTest {
    private TestSeekableStreamIndexTaskRunner taskRunner;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        AuthorizerMapper authorizerMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return (authenticationResult, resource, action) -> {
                    String username = authenticationResult.getIdentity();
                    if (resource.getType().equals("DATASOURCE")) {
                        return new Access(action == Action.READ && username.equals("datasourceRead") || action == Action.WRITE && username.equals("datasourceWrite"));
                    }
                    return new Access(false);
                };
            }
        };
        DataSchema dataSchema = new DataSchema("datasource", new TimestampSpec(null, null, null), new DimensionsSpec(Collections.emptyList()), new AggregatorFactory[0], (GranularitySpec)new ArbitraryGranularitySpec((Granularity)new AllGranularity(), Collections.emptyList()), TransformSpec.NONE, null, null);
        SeekableStreamIndexTaskTuningConfig tuningConfig = (SeekableStreamIndexTaskTuningConfig)EasyMock.mock(SeekableStreamIndexTaskTuningConfig.class);
        TestSeekableStreamIndexTaskIOConfig ioConfig = new TestSeekableStreamIndexTaskIOConfig();
        TestSeekableStreamIndexTask indexTask = new TestSeekableStreamIndexTask("id", dataSchema, tuningConfig, ioConfig);
        this.taskRunner = new TestSeekableStreamIndexTaskRunner(indexTask, authorizerMapper);
    }

    @Test
    public void testGetStatusHttp() {
        this.verifyOnlyDatasourceReadUserCanAccess(arg_0 -> ((TestSeekableStreamIndexTaskRunner)this.taskRunner).getStatusHTTP(arg_0));
    }

    @Test
    public void testGetStartTime() {
        this.verifyOnlyDatasourceWriteUserCanAccess(arg_0 -> ((TestSeekableStreamIndexTaskRunner)this.taskRunner).getStartTime(arg_0));
    }

    @Test
    public void testStop() {
        this.verifyOnlyDatasourceWriteUserCanAccess(arg_0 -> ((TestSeekableStreamIndexTaskRunner)this.taskRunner).stop(arg_0));
    }

    @Test
    public void testPauseHttp() {
        this.verifyOnlyDatasourceWriteUserCanAccess(req -> {
            try {
                this.taskRunner.pauseHTTP((HttpServletRequest)req);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testResumeHttp() {
        this.verifyOnlyDatasourceWriteUserCanAccess(req -> {
            try {
                this.taskRunner.resumeHTTP((HttpServletRequest)req);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testGetEndOffsets() {
        this.verifyOnlyDatasourceReadUserCanAccess(arg_0 -> ((TestSeekableStreamIndexTaskRunner)this.taskRunner).getCurrentOffsets(arg_0));
    }

    @Test
    public void testSetEndOffsetsHttp() {
        this.verifyOnlyDatasourceWriteUserCanAccess(request -> {
            try {
                this.taskRunner.setEndOffsetsHTTP(Collections.emptyMap(), false, (HttpServletRequest)request);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testGetCheckpointsHttp() {
        this.verifyOnlyDatasourceReadUserCanAccess(arg_0 -> ((TestSeekableStreamIndexTaskRunner)this.taskRunner).getCheckpointsHTTP(arg_0));
    }

    private void verifyOnlyDatasourceWriteUserCanAccess(Consumer<HttpServletRequest> method) {
        HttpServletRequest allowedRequest = this.createRequest("datasourceWrite");
        EasyMock.replay((Object[])new Object[]{allowedRequest});
        method.accept(allowedRequest);
        HttpServletRequest blockedRequest = this.createRequest("datasourceRead");
        EasyMock.replay((Object[])new Object[]{blockedRequest});
        this.expectedException.expect(ForbiddenException.class);
        method.accept(blockedRequest);
    }

    private void verifyOnlyDatasourceReadUserCanAccess(Consumer<HttpServletRequest> method) {
        HttpServletRequest allowedRequest = this.createRequest("datasourceRead");
        EasyMock.replay((Object[])new Object[]{allowedRequest});
        method.accept(allowedRequest);
        HttpServletRequest blockedRequest = this.createRequest("datasourceWrite");
        EasyMock.replay((Object[])new Object[]{blockedRequest});
        this.expectedException.expect(ForbiddenException.class);
        method.accept(blockedRequest);
    }

    private HttpServletRequest createRequest(String username) {
        HttpServletRequest request = (HttpServletRequest)EasyMock.mock(HttpServletRequest.class);
        AuthenticationResult authenticationResult = new AuthenticationResult(username, "druid", null, null);
        EasyMock.expect((Object)request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)request.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).atLeastOnce();
        request.setAttribute("Druid-Authorization-Checked", (Object)false);
        EasyMock.expectLastCall().anyTimes();
        request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        return request;
    }

    private static class Users {
        private static final String DATASOURCE_READ = "datasourceRead";
        private static final String DATASOURCE_WRITE = "datasourceWrite";

        private Users() {
        }
    }

    private static class TestSeekableStreamIndexTaskIOConfig
    extends SeekableStreamIndexTaskIOConfig<String, String> {
        public TestSeekableStreamIndexTaskIOConfig() {
            super(null, "someSequence", new SeekableStreamStartSequenceNumbers("abc", "def", Collections.emptyMap(), Collections.emptyMap(), null), new SeekableStreamEndSequenceNumbers("abc", "def", Collections.emptyMap(), Collections.emptyMap()), Boolean.valueOf(false), DateTimes.nowUtc().minusDays(2), DateTimes.nowUtc(), (InputFormat)new CsvInputFormat(null, null, Boolean.valueOf(true), null, 0));
        }
    }

    private static class TestSeekableStreamIndexTask
    extends SeekableStreamIndexTask<String, String, ByteEntity> {
        public TestSeekableStreamIndexTask(String id, DataSchema dataSchema, SeekableStreamIndexTaskTuningConfig tuningConfig, SeekableStreamIndexTaskIOConfig<String, String> ioConfig) {
            super(id, null, dataSchema, tuningConfig, ioConfig, null, null);
        }

        public String getType() {
            return null;
        }

        protected SeekableStreamIndexTaskRunner<String, String, ByteEntity> createTaskRunner() {
            return null;
        }

        protected RecordSupplier<String, String, ByteEntity> newTaskRecordSupplier() {
            return null;
        }
    }

    private static class TestSeekableStreamIndexTaskRunner
    extends SeekableStreamIndexTaskRunner<String, String, ByteEntity> {
        private TestSeekableStreamIndexTaskRunner(SeekableStreamIndexTask<String, String, ByteEntity> task, AuthorizerMapper authorizerMapper) {
            super(task, null, authorizerMapper, LockGranularity.SEGMENT);
        }

        protected boolean isEndOfShard(String seqNum) {
            return false;
        }

        @Nullable
        protected TreeMap<Integer, Map<String, String>> getCheckPointsFromContext(TaskToolbox toolbox, String checkpointsString) {
            return null;
        }

        protected String getNextStartOffset(String sequenceNumber) {
            return null;
        }

        protected SeekableStreamEndSequenceNumbers<String, String> deserializePartitionsFromMetadata(ObjectMapper mapper, Object object) {
            return null;
        }

        @Nonnull
        protected List<OrderedPartitionableRecord<String, String, ByteEntity>> getRecords(RecordSupplier<String, String, ByteEntity> recordSupplier, TaskToolbox toolbox) {
            return null;
        }

        protected SeekableStreamDataSourceMetadata<String, String> createDataSourceMetadata(SeekableStreamSequenceNumbers<String, String> partitions) {
            return null;
        }

        protected OrderedSequenceNumber<String> createSequenceNumber(String sequenceNumber) {
            return null;
        }

        protected void possiblyResetDataSourceMetadata(TaskToolbox toolbox, RecordSupplier<String, String, ByteEntity> recordSupplier, Set<StreamPartition<String>> assignment) {
        }

        protected boolean isEndOffsetExclusive() {
            return false;
        }

        protected TypeReference<List<SequenceMetadata<String, String>>> getSequenceMetadataTypeReference() {
            return null;
        }
    }
}

