/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.indexing.worker.shuffle.LocalIntermediaryDataManager;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalIntermediaryDataManagerAutoCleanupTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private TaskConfig taskConfig;
    private OverlordClient overlordClient;

    @Before
    public void setup() throws IOException {
        this.taskConfig = new TaskConfig(null, null, null, null, null, false, null, null, (List)ImmutableList.of((Object)new StorageLocationConfig(this.tempDir.newFolder(), null, null)), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null);
        this.overlordClient = new NoopOverlordClient(){

            public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> taskIds) {
                HashMap<String, TaskStatus> result = new HashMap<String, TaskStatus>();
                for (String taskId : taskIds) {
                    TaskState state = taskId.startsWith("running_") ? TaskState.RUNNING : TaskState.SUCCESS;
                    result.put(taskId, new TaskStatus(taskId, state, 10L, null, null));
                }
                return Futures.immediateFuture(result);
            }
        };
    }

    @Test
    public void testCompletedExpiredSupervisor() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.isCleanedUpAfter3s("supervisor_1", new Period((Object)"PT1S")));
    }

    @Test
    public void testCompletedNotExpiredSupervisor() throws IOException, InterruptedException {
        Assert.assertFalse((boolean)this.isCleanedUpAfter3s("supervisor_2", new Period((Object)"PT10S")));
    }

    @Test
    public void testRunningSupervisor() throws IOException, InterruptedException {
        Assert.assertFalse((boolean)this.isCleanedUpAfter3s("running_supervisor_1", new Period((Object)"PT1S")));
    }

    private boolean isCleanedUpAfter3s(String supervisorTaskId, Period timeoutPeriod) throws IOException, InterruptedException {
        String subTaskId = "subTaskId";
        Interval interval = Intervals.of((String)"2018/2019");
        File segmentFile = this.generateSegmentDir("test");
        DataSegment segment = this.newSegment(interval);
        TestWorkerConfig workerConfig = new TestWorkerConfig(1L, 1L, timeoutPeriod);
        LocalIntermediaryDataManager intermediaryDataManager = new LocalIntermediaryDataManager((WorkerConfig)workerConfig, this.taskConfig, this.overlordClient);
        intermediaryDataManager.addSegment(supervisorTaskId, "subTaskId", segment, segmentFile);
        intermediaryDataManager.findPartitionFile(supervisorTaskId, "subTaskId", interval, 0);
        intermediaryDataManager.start();
        Thread.sleep(3000L);
        boolean partitionFileExists = intermediaryDataManager.findPartitionFile(supervisorTaskId, "subTaskId", interval, 0).isPresent();
        intermediaryDataManager.stop();
        return !partitionFileExists;
    }

    private File generateSegmentDir(String fileName) throws IOException {
        File segmentDir = this.tempDir.newFolder();
        FileUtils.write((File)new File(segmentDir, fileName), (CharSequence)"test data.", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile((File)new File(segmentDir, "version.bin"), (byte[])Ints.toByteArray((int)9));
        return segmentDir;
    }

    private DataSegment newSegment(Interval interval) {
        return new DataSegment("dataSource", interval, "version", null, null, null, (ShardSpec)new TestShardSpec(), Integer.valueOf(9), 10L);
    }

    private static class TestWorkerConfig
    extends WorkerConfig {
        private final long cleanupPeriodSeconds;
        private final long discoveryPeriodSeconds;
        private final Period timeoutPeriod;

        private TestWorkerConfig(long cleanupPeriodSeconds, long discoveryPeriodSeconds, Period timeoutPeriod) {
            this.cleanupPeriodSeconds = cleanupPeriodSeconds;
            this.discoveryPeriodSeconds = discoveryPeriodSeconds;
            this.timeoutPeriod = timeoutPeriod;
        }

        public long getIntermediaryPartitionCleanupPeriodSec() {
            return this.cleanupPeriodSeconds;
        }

        public long getIntermediaryPartitionDiscoveryPeriodSec() {
            return this.discoveryPeriodSeconds;
        }

        public Period getIntermediaryPartitionTimeout() {
            return this.timeoutPeriod;
        }
    }

    private static class TestShardSpec
    implements BucketNumberedShardSpec<BuildingShardSpec<ShardSpec>> {
        private TestShardSpec() {
        }

        public int getBucketId() {
            return 0;
        }

        public BuildingShardSpec<ShardSpec> convert(int partitionId) {
            throw new UnsupportedOperationException();
        }

        public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
            throw new UnsupportedOperationException();
        }
    }
}

