/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.indexing.worker.shuffle.LocalIntermediaryDataManager;
import org.apache.druid.indexing.worker.shuffle.ShuffleMetrics;
import org.apache.druid.indexing.worker.shuffle.ShuffleResource;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class ShuffleResourceTest {
    private static final String DATASOURCE = "datasource";
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private LocalIntermediaryDataManager intermediaryDataManager;
    private ShuffleMetrics shuffleMetrics;
    private ShuffleResource shuffleResource;

    @Before
    public void setup() throws IOException {
        WorkerConfig workerConfig = new WorkerConfig(){

            public long getIntermediaryPartitionDiscoveryPeriodSec() {
                return 1L;
            }

            public long getIntermediaryPartitionCleanupPeriodSec() {
                return 2L;
            }

            public Period getIntermediaryPartitionTimeout() {
                return new Period((Object)"PT2S");
            }
        };
        TaskConfig taskConfig = new TaskConfig(null, null, null, null, null, false, null, null, (List)ImmutableList.of((Object)new StorageLocationConfig(this.tempDir.newFolder(), null, null)), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null);
        NoopOverlordClient overlordClient = new NoopOverlordClient(){

            public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> taskIds) {
                HashMap<String, TaskStatus> result = new HashMap<String, TaskStatus>();
                for (String taskId : taskIds) {
                    result.put(taskId, new TaskStatus(taskId, TaskState.SUCCESS, 10L, null, null));
                }
                return Futures.immediateFuture(result);
            }
        };
        this.intermediaryDataManager = new LocalIntermediaryDataManager(workerConfig, taskConfig, (OverlordClient)overlordClient);
        this.shuffleMetrics = new ShuffleMetrics();
        this.shuffleResource = new ShuffleResource((IntermediaryDataManager)this.intermediaryDataManager, Optional.of(this.shuffleMetrics));
    }

    @Test
    public void testGetUnknownPartitionReturnNotFound() {
        Response response = this.shuffleResource.getPartition("unknownSupervisorTask", "unknownSubtask", "2020-01-01", "2020-01-02", 0);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        String errorMessage = (String)response.getEntity();
        Assert.assertTrue((boolean)errorMessage.contains("Can't find the partition for supervisorTask"));
    }

    @Test
    public void testGetPartitionWithValidParamsReturnOk() throws IOException {
        String supervisorTaskId = "supervisorTask";
        String subtaskId = "subtaskId";
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        DataSegment segment = ShuffleResourceTest.newSegment(interval);
        File segmentDir = this.generateSegmentDir("test");
        this.intermediaryDataManager.addSegment("supervisorTask", "subtaskId", segment, segmentDir);
        Response response = this.shuffleResource.getPartition("supervisorTask", "subtaskId", interval.getStart().toString(), interval.getEnd().toString(), segment.getId().getPartitionNum());
        Map snapshot = this.shuffleMetrics.snapshotAndReset();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((long)1L, (long)((ShuffleMetrics.PerDatasourceShuffleMetrics)snapshot.get("supervisorTask")).getShuffleRequests());
        Assert.assertEquals((long)254L, (long)((ShuffleMetrics.PerDatasourceShuffleMetrics)snapshot.get("supervisorTask")).getShuffleBytes());
    }

    @Test
    public void testDeleteUnknownPartitionReturnOk() {
        Response response = this.shuffleResource.deletePartitions("unknownSupervisorTask");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testDeletePartitionWithValidParamsReturnOk() throws IOException {
        String supervisorTaskId = "supervisorTask";
        String subtaskId = "subtaskId";
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        DataSegment segment = ShuffleResourceTest.newSegment(interval);
        File segmentDir = this.generateSegmentDir("test");
        this.intermediaryDataManager.addSegment("supervisorTask", "subtaskId", segment, segmentDir);
        Response response = this.shuffleResource.deletePartitions("supervisorTask");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testDeletePartitionThrowingExceptionReturnIntervalServerError() throws IOException {
        IntermediaryDataManager exceptionThrowingManager = (IntermediaryDataManager)EasyMock.niceMock(IntermediaryDataManager.class);
        exceptionThrowingManager.deletePartitions(EasyMock.anyString());
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("test"));
        EasyMock.replay((Object[])new Object[]{exceptionThrowingManager});
        ShuffleResource shuffleResource = new ShuffleResource(exceptionThrowingManager, Optional.of(this.shuffleMetrics));
        Response response = shuffleResource.deletePartitions("supervisorTask");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    private static DataSegment newSegment(Interval interval) {
        BucketNumberedShardSpec shardSpec = (BucketNumberedShardSpec)Mockito.mock(BucketNumberedShardSpec.class);
        Mockito.when((Object)shardSpec.getBucketId()).thenReturn((Object)0);
        return new DataSegment(DATASOURCE, interval, "version", null, null, null, (ShardSpec)shardSpec, Integer.valueOf(0), 10L);
    }

    private File generateSegmentDir(String fileName) throws IOException {
        File segmentDir = this.tempDir.newFolder();
        FileUtils.write((File)new File(segmentDir, fileName), (CharSequence)"test data.", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile((File)new File(segmentDir, "version.bin"), (byte[])Ints.toByteArray((int)9));
        return segmentDir;
    }
}

