/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.MarkSegmentsAsUnusedAction;
import org.apache.druid.indexing.common.actions.RetrieveUnusedSegmentsAction;
import org.apache.druid.indexing.common.actions.SegmentNukeAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.task.AbstractFixedIntervalTask;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class KillUnusedSegmentsTask
extends AbstractFixedIntervalTask {
    private static final Logger LOG = new Logger(KillUnusedSegmentsTask.class);
    private final boolean markAsUnused;

    @JsonCreator
    public KillUnusedSegmentsTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="markAsUnused") Boolean markAsUnused) {
        super(KillUnusedSegmentsTask.getOrMakeId(id, "kill", dataSource, interval), dataSource, interval, context);
        this.markAsUnused = markAsUnused != null && markAsUnused != false;
    }

    @JsonProperty
    public boolean isMarkAsUnused() {
        return this.markAsUnused;
    }

    @Override
    public String getType() {
        return "kill";
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        List<DataSegment> unusedSegments;
        NavigableMap<DateTime, List<TaskLock>> taskLockMap = this.getTaskLockMap(toolbox.getTaskActionClient());
        if (this.markAsUnused) {
            int numMarked = toolbox.getTaskActionClient().submit(new MarkSegmentsAsUnusedAction(this.getDataSource(), this.getInterval()));
            LOG.info("Marked %d segments as unused.", new Object[]{numMarked});
        }
        if (!TaskLocks.isLockCoversSegments(taskLockMap, unusedSegments = toolbox.getTaskActionClient().submit(new RetrieveUnusedSegmentsAction(this.getDataSource(), this.getInterval())))) {
            throw new ISE("Locks[%s] for task[%s] can't cover segments[%s]", new Object[]{taskLockMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()), this.getId(), unusedSegments});
        }
        toolbox.getTaskActionClient().submit(new SegmentNukeAction(new HashSet<DataSegment>(unusedSegments)));
        for (DataSegment segment : unusedSegments) {
            toolbox.getDataSegmentKiller().kill(segment);
        }
        return TaskStatus.success((String)this.getId());
    }

    private NavigableMap<DateTime, List<TaskLock>> getTaskLockMap(TaskActionClient client) throws IOException {
        TreeMap<DateTime, List<TaskLock>> taskLockMap = new TreeMap<DateTime, List<TaskLock>>();
        KillUnusedSegmentsTask.getTaskLocks(client).forEach(taskLock -> taskLockMap.computeIfAbsent(taskLock.getInterval().getStart(), k -> new ArrayList()).add(taskLock));
        return taskLockMap;
    }
}

