/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class NoopTask
extends AbstractTask {
    private static final Logger log = new Logger(NoopTask.class);
    private static final int DEFAULT_RUN_TIME = 2500;
    private static final int DEFAULT_IS_READY_TIME = 0;
    private static final IsReadyResult DEFAULT_IS_READY_RESULT = IsReadyResult.YES;
    @JsonIgnore
    private final long runTime;
    @JsonIgnore
    private final long isReadyTime;
    @JsonIgnore
    private final IsReadyResult isReadyResult;
    @JsonIgnore
    private final FirehoseFactory firehoseFactory;

    @JsonCreator
    public NoopTask(@JsonProperty(value="id") String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="runTime") long runTime, @JsonProperty(value="isReadyTime") long isReadyTime, @JsonProperty(value="isReadyResult") String isReadyResult, @JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="context") Map<String, Object> context) {
        super(id == null ? StringUtils.format((String)"noop_%s_%s", (Object[])new Object[]{DateTimes.nowUtc(), UUID.randomUUID().toString()}) : id, groupId, null, dataSource == null ? "none" : dataSource, context);
        this.runTime = runTime == 0L ? 2500L : runTime;
        this.isReadyTime = isReadyTime == 0L ? 0L : isReadyTime;
        this.isReadyResult = isReadyResult == null ? DEFAULT_IS_READY_RESULT : IsReadyResult.valueOf(StringUtils.toUpperCase((String)isReadyResult));
        this.firehoseFactory = firehoseFactory;
    }

    @Override
    public String getType() {
        return "noop";
    }

    @JsonProperty
    public long getRunTime() {
        return this.runTime;
    }

    @JsonProperty
    public long getIsReadyTime() {
        return this.isReadyTime;
    }

    @JsonProperty
    public IsReadyResult getIsReadyResult() {
        return this.isReadyResult;
    }

    @JsonProperty(value="firehose")
    public FirehoseFactory getFirehoseFactory() {
        return this.firehoseFactory;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) {
        switch (this.isReadyResult) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case EXCEPTION: {
                throw new ISE("Not ready. Never will be ready. Go away!", new Object[0]);
            }
        }
        throw new AssertionError((Object)"#notreached");
    }

    @Override
    public void stopGracefully(TaskConfig taskConfig) {
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        if (this.firehoseFactory != null) {
            log.info("Connecting firehose", new Object[0]);
        }
        try (Firehose firehose = this.firehoseFactory != null ? this.firehoseFactory.connect(null, null) : null;){
            log.info("Running noop task[%s]", new Object[]{this.getId()});
            log.info("Sleeping for %,d millis.", new Object[]{this.runTime});
            Thread.sleep(this.runTime);
            log.info("Woke up!", new Object[0]);
            TaskStatus taskStatus = TaskStatus.success((String)this.getId());
            return taskStatus;
        }
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 50);
    }

    public static NoopTask create() {
        return new NoopTask(null, null, null, 0L, 0L, null, null, null);
    }

    public static NoopTask withGroupId(String groupId) {
        return new NoopTask(null, groupId, null, 0L, 0L, null, null, null);
    }

    @VisibleForTesting
    public static NoopTask create(String dataSource) {
        return new NoopTask(null, null, dataSource, 0L, 0L, null, null, null);
    }

    @VisibleForTesting
    public static NoopTask create(int priority) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("priority", priority);
        return new NoopTask(null, null, null, 0L, 0L, null, null, context);
    }

    @VisibleForTesting
    public static NoopTask create(String id, int priority) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("priority", priority);
        return new NoopTask(id, null, null, 0L, 0L, null, null, context);
    }

    static enum IsReadyResult {
        YES,
        NO,
        EXCEPTION;

    }
}

