/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.firehose;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.indexing.common.ReingestionTimelineUtils;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.firehose.WindowedSegmentId;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.realtime.firehose.IngestSegmentFirehose;
import org.apache.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

@Deprecated
public class IngestSegmentFirehoseFactory
implements FiniteFirehoseFactory<InputRowParser, List<WindowedSegmentId>> {
    private static final EmittingLogger log = new EmittingLogger(IngestSegmentFirehoseFactory.class);
    private final String dataSource;
    @Nullable
    private final Interval interval;
    @Nullable
    private final List<WindowedSegmentId> segmentIds;
    private final DimFilter dimFilter;
    private final List<String> dimensions;
    private final List<String> metrics;
    @Nullable
    private final Long maxInputSegmentBytesPerTask;
    private final IndexIO indexIO;
    private final CoordinatorClient coordinatorClient;
    private final SegmentCacheManagerFactory segmentCacheManagerFactory;
    private final RetryPolicyFactory retryPolicyFactory;
    private List<InputSplit<List<WindowedSegmentId>>> splits;

    @JsonCreator
    public IngestSegmentFirehoseFactory(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") @Nullable Interval interval, @JsonProperty(value="segments") @Nullable List<WindowedSegmentId> segmentIds, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="metrics") List<String> metrics, @JsonProperty(value="maxInputSegmentBytesPerTask") @Deprecated @Nullable Long maxInputSegmentBytesPerTask, @JacksonInject IndexIO indexIO, @JacksonInject CoordinatorClient coordinatorClient, @JacksonInject SegmentCacheManagerFactory segmentCacheManagerFactory, @JacksonInject RetryPolicyFactory retryPolicyFactory) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        if (interval == null && segmentIds == null || interval != null && segmentIds != null) {
            throw new IAE("Specify exactly one of 'interval' and 'segments'", new Object[0]);
        }
        this.dataSource = dataSource;
        this.interval = interval;
        this.segmentIds = segmentIds;
        this.dimFilter = dimFilter;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.maxInputSegmentBytesPerTask = maxInputSegmentBytesPerTask;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"null IndexIO");
        this.coordinatorClient = (CoordinatorClient)Preconditions.checkNotNull((Object)coordinatorClient, (Object)"null CoordinatorClient");
        this.segmentCacheManagerFactory = (SegmentCacheManagerFactory)Preconditions.checkNotNull((Object)segmentCacheManagerFactory, (Object)"null segmentCacheManagerFactory");
        this.retryPolicyFactory = (RetryPolicyFactory)Preconditions.checkNotNull((Object)retryPolicyFactory, (Object)"null RetryPolicyFactory");
    }

    public FiniteFirehoseFactory<InputRowParser, List<WindowedSegmentId>> withSplit(InputSplit<List<WindowedSegmentId>> split) {
        return new IngestSegmentFirehoseFactory(this.dataSource, null, (List)split.get(), this.dimFilter, this.dimensions, this.metrics, this.maxInputSegmentBytesPerTask, this.indexIO, this.coordinatorClient, this.segmentCacheManagerFactory, this.retryPolicyFactory);
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    @Nullable
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    @Nullable
    public List<WindowedSegmentId> getSegments() {
        return this.segmentIds;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    @Nullable
    @JsonProperty
    public Long getMaxInputSegmentBytesPerTask() {
        return this.maxInputSegmentBytesPerTask;
    }

    public Firehose connect(InputRowParser inputRowParser, File temporaryDirectory) throws ParseException {
        log.debug("Connecting firehose: dataSource[%s], interval[%s], segmentIds[%s]", new Object[]{this.dataSource, this.interval, this.segmentIds});
        List<TimelineObjectHolder<String, DataSegment>> timeLineSegments = this.getTimeline();
        SegmentCacheManager segmentCacheManager = this.segmentCacheManagerFactory.manufacturate(temporaryDirectory);
        final LinkedHashMap segmentFileMap = Maps.newLinkedHashMap();
        for (TimelineObjectHolder<String, DataSegment> holder : timeLineSegments) {
            for (PartitionChunk chunk : holder.getObject()) {
                DataSegment segment = (DataSegment)chunk.getObject();
                segmentFileMap.computeIfAbsent(segment, k -> {
                    try {
                        return segmentCacheManager.getSegmentFiles(segment);
                    }
                    catch (SegmentLoadingException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        List<String> dims = ReingestionTimelineUtils.getDimensionsToReingest(this.dimensions, inputRowParser.getParseSpec().getDimensionsSpec(), timeLineSegments);
        List<String> metricsList = this.metrics == null ? ReingestionTimelineUtils.getUniqueMetrics(timeLineSegments) : this.metrics;
        ArrayList adapters = Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(timeLineSegments, (Function)new Function<TimelineObjectHolder<String, DataSegment>, Iterable<WindowedStorageAdapter>>(){

            public Iterable<WindowedStorageAdapter> apply(final TimelineObjectHolder<String, DataSegment> holder) {
                return Iterables.transform((Iterable)holder.getObject(), (Function)new Function<PartitionChunk<DataSegment>, WindowedStorageAdapter>(){

                    public WindowedStorageAdapter apply(PartitionChunk<DataSegment> input) {
                        DataSegment segment = (DataSegment)input.getObject();
                        try {
                            return new WindowedStorageAdapter((StorageAdapter)new QueryableIndexStorageAdapter(IngestSegmentFirehoseFactory.this.indexIO.loadIndex((File)Preconditions.checkNotNull(segmentFileMap.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getId()}))), holder.getInterval());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        })));
        TransformSpec transformSpec = TransformSpec.fromInputRowParser((InputRowParser)inputRowParser);
        return new IngestSegmentFirehose((List)adapters, transformSpec, dims, metricsList, this.dimFilter);
    }

    private List<TimelineObjectHolder<String, DataSegment>> getTimeline() {
        if (this.interval == null) {
            return DruidInputSource.getTimelineForSegmentIds(this.coordinatorClient, this.dataSource, this.segmentIds);
        }
        return DruidInputSource.getTimelineForInterval(this.coordinatorClient, this.retryPolicyFactory, this.dataSource, this.interval);
    }

    private void initializeSplitsIfNeeded(@Nullable SplitHintSpec splitHintSpec) {
        if (this.splits != null) {
            return;
        }
        this.splits = Lists.newArrayList(DruidInputSource.createSplits(this.coordinatorClient, this.retryPolicyFactory, this.dataSource, this.interval, (SplitHintSpec)(splitHintSpec == null ? new SegmentsSplitHintSpec(this.maxInputSegmentBytesPerTask == null ? null : new HumanReadableBytes(this.maxInputSegmentBytesPerTask.longValue()), null) : splitHintSpec)));
    }

    public boolean isSplittable() {
        return this.interval != null;
    }

    public Stream<InputSplit<List<WindowedSegmentId>>> getSplits(@Nullable SplitHintSpec splitHintSpec) {
        this.initializeSplitsIfNeeded(splitHintSpec);
        return this.splits.stream();
    }

    public int getNumSplits(@Nullable SplitHintSpec splitHintSpec) {
        this.initializeSplitsIfNeeded(splitHintSpec);
        return this.splits.size();
    }
}

