/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class TaskReportData<PartitionIdType, SequenceOffsetType> {
    private final String id;
    private final Map<PartitionIdType, SequenceOffsetType> startingOffsets;
    private final DateTime startTime;
    private final Long remainingSeconds;
    private final TaskType type;
    private final Map<PartitionIdType, SequenceOffsetType> currentOffsets;
    private final Map<PartitionIdType, Long> lag;
    private final Map<PartitionIdType, Long> lagMillis;

    public TaskReportData(String id, @Nullable Map<PartitionIdType, SequenceOffsetType> startingOffsets, @Nullable Map<PartitionIdType, SequenceOffsetType> currentOffsets, @Nullable DateTime startTime, Long remainingSeconds, TaskType type, @Nullable Map<PartitionIdType, Long> lag, @Nullable Map<PartitionIdType, Long> lagMillis) {
        this.id = id;
        this.startingOffsets = startingOffsets;
        this.currentOffsets = currentOffsets;
        this.startTime = startTime;
        this.remainingSeconds = remainingSeconds;
        this.type = type;
        this.lag = lag;
        this.lagMillis = lagMillis;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<PartitionIdType, SequenceOffsetType> getStartingOffsets() {
        return this.startingOffsets;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<PartitionIdType, SequenceOffsetType> getCurrentOffsets() {
        return this.currentOffsets;
    }

    @JsonProperty
    public DateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Long getRemainingSeconds() {
        return this.remainingSeconds;
    }

    @JsonProperty
    public TaskType getType() {
        return this.type;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<PartitionIdType, Long> getLag() {
        return this.lag;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<PartitionIdType, Long> getLagMillis() {
        return this.lagMillis;
    }

    public String toString() {
        return "{id='" + this.id + '\'' + (this.startingOffsets != null ? ", startingOffsets=" + this.startingOffsets : "") + (this.currentOffsets != null ? ", currentOffsets=" + this.currentOffsets : "") + ", startTime=" + this.startTime + ", remainingSeconds=" + this.remainingSeconds + (this.lag != null ? ", lag=" + this.lag : "") + (this.lagMillis != null ? ", lagMillis=" + this.lagMillis : "") + '}';
    }

    public static enum TaskType {
        ACTIVE,
        PUBLISHING,
        UNKNOWN;

    }
}

