/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolboxFactory;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.stats.DropwizardRowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.NoopTestTaskReportFileWriter;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexMergerV9Factory;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.security.AuthTestUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskToolboxTest {
    private TaskToolboxFactory taskToolbox = null;
    private TaskActionClientFactory mockTaskActionClientFactory = (TaskActionClientFactory)EasyMock.createMock(TaskActionClientFactory.class);
    private ServiceEmitter mockEmitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
    private DataSegmentPusher mockSegmentPusher = (DataSegmentPusher)EasyMock.createMock(DataSegmentPusher.class);
    private DataSegmentKiller mockDataSegmentKiller = (DataSegmentKiller)EasyMock.createMock(DataSegmentKiller.class);
    private DataSegmentMover mockDataSegmentMover = (DataSegmentMover)EasyMock.createMock(DataSegmentMover.class);
    private DataSegmentArchiver mockDataSegmentArchiver = (DataSegmentArchiver)EasyMock.createMock(DataSegmentArchiver.class);
    private DataSegmentAnnouncer mockSegmentAnnouncer = (DataSegmentAnnouncer)EasyMock.createMock(DataSegmentAnnouncer.class);
    private SegmentHandoffNotifierFactory mockHandoffNotifierFactory = (SegmentHandoffNotifierFactory)EasyMock.createNiceMock(SegmentHandoffNotifierFactory.class);
    private QueryRunnerFactoryConglomerate mockQueryRunnerFactoryConglomerate = (QueryRunnerFactoryConglomerate)EasyMock.createMock(QueryRunnerFactoryConglomerate.class);
    private MonitorScheduler mockMonitorScheduler = (MonitorScheduler)EasyMock.createMock(MonitorScheduler.class);
    private QueryProcessingPool mockQueryProcessingPool = (QueryProcessingPool)EasyMock.createMock(QueryProcessingPool.class);
    private ObjectMapper ObjectMapper = new ObjectMapper();
    private SegmentCacheManagerFactory mockSegmentCacheManagerFactory = (SegmentCacheManagerFactory)EasyMock.createMock(SegmentCacheManagerFactory.class);
    private SegmentLocalCacheManager mockSegmentLoaderLocalCacheManager = (SegmentLocalCacheManager)EasyMock.createMock(SegmentLocalCacheManager.class);
    private Task task = (Task)EasyMock.createMock(Task.class);
    private IndexMergerV9Factory mockIndexMergerV9 = (IndexMergerV9Factory)EasyMock.createMock(IndexMergerV9Factory.class);
    private IndexIO mockIndexIO = (IndexIO)EasyMock.createMock(IndexIO.class);
    private Cache mockCache = (Cache)EasyMock.createMock(Cache.class);
    private CacheConfig mockCacheConfig = (CacheConfig)EasyMock.createMock(CacheConfig.class);
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        EasyMock.expect((Object)this.task.getId()).andReturn((Object)"task_id").anyTimes();
        EasyMock.expect((Object)this.task.getDataSource()).andReturn((Object)"task_ds").anyTimes();
        EasyMock.expect((Object)this.task.getContextValue("storeEmptyColumns", (Object)true)).andReturn((Object)true).anyTimes();
        IndexMergerV9 indexMergerV9 = (IndexMergerV9)EasyMock.createMock(IndexMergerV9.class);
        EasyMock.expect((Object)this.mockIndexMergerV9.create(true)).andReturn((Object)indexMergerV9).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.task, this.mockHandoffNotifierFactory, this.mockIndexMergerV9});
        this.taskToolbox = new TaskToolboxFactory(new TaskConfig(this.temporaryFolder.newFile().toString(), null, null, Integer.valueOf(50000), null, false, null, null, null, false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null, false), new DruidNode("druid/middlemanager", "localhost", false, Integer.valueOf(8091), null, true, false), this.mockTaskActionClientFactory, this.mockEmitter, this.mockSegmentPusher, this.mockDataSegmentKiller, this.mockDataSegmentMover, this.mockDataSegmentArchiver, this.mockSegmentAnnouncer, (DataSegmentServerAnnouncer)EasyMock.createNiceMock(DataSegmentServerAnnouncer.class), this.mockHandoffNotifierFactory, () -> this.mockQueryRunnerFactoryConglomerate, this.mockQueryProcessingPool, (JoinableFactory)NoopJoinableFactory.INSTANCE, () -> this.mockMonitorScheduler, this.mockSegmentCacheManagerFactory, this.ObjectMapper, this.mockIndexIO, this.mockCache, this.mockCacheConfig, new CachePopulatorStats(), this.mockIndexMergerV9, null, null, null, null, (TaskReportFileWriter)new NoopTestTaskReportFileWriter(), null, AuthTestUtils.TEST_AUTHORIZER_MAPPER, (ChatHandlerProvider)new NoopChatHandlerProvider(), (RowIngestionMetersFactory)new DropwizardRowIngestionMetersFactory(), (AppenderatorsManager)new TestAppenderatorsManager(), (OverlordClient)new NoopOverlordClient(), null, null, null, null, "1");
    }

    @Test
    public void testGetDataSegmentArchiver() {
        Assert.assertEquals((Object)this.mockDataSegmentArchiver, (Object)this.taskToolbox.build(this.task).getDataSegmentArchiver());
    }

    @Test
    public void testGetSegmentAnnouncer() {
        Assert.assertEquals((Object)this.mockSegmentAnnouncer, (Object)this.taskToolbox.build(this.task).getSegmentAnnouncer());
    }

    @Test
    public void testGetQueryRunnerFactoryConglomerate() {
        Assert.assertEquals((Object)this.mockQueryRunnerFactoryConglomerate, (Object)this.taskToolbox.build(this.task).getQueryRunnerFactoryConglomerate());
    }

    @Test
    public void testGetQueryProcessingPool() {
        Assert.assertEquals((Object)this.mockQueryProcessingPool, (Object)this.taskToolbox.build(this.task).getQueryProcessingPool());
    }

    @Test
    public void testGetMonitorScheduler() {
        Assert.assertEquals((Object)this.mockMonitorScheduler, (Object)this.taskToolbox.build(this.task).getMonitorScheduler());
    }

    @Test
    public void testGetObjectMapper() {
        Assert.assertEquals((Object)this.ObjectMapper, (Object)this.taskToolbox.build(this.task).getJsonMapper());
    }

    @Test
    public void testGetEmitter() {
        Assert.assertEquals((Object)this.mockEmitter, (Object)this.taskToolbox.build(this.task).getEmitter());
    }

    @Test
    public void testGetDataSegmentKiller() {
        Assert.assertEquals((Object)this.mockDataSegmentKiller, (Object)this.taskToolbox.build(this.task).getDataSegmentKiller());
    }

    @Test
    public void testGetDataSegmentMover() {
        Assert.assertEquals((Object)this.mockDataSegmentMover, (Object)this.taskToolbox.build(this.task).getDataSegmentMover());
    }

    @Test
    public void testGetCache() {
        Assert.assertEquals((Object)this.mockCache, (Object)this.taskToolbox.build(this.task).getCache());
    }

    @Test
    public void testGetCacheConfig() {
        Assert.assertEquals((Object)this.mockCacheConfig, (Object)this.taskToolbox.build(this.task).getCacheConfig());
    }
}

