/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.java.util.common.parsers.ParseException;

public class TestFirehose
implements Firehose {
    public static final String FAIL_DIM = "__fail__";
    private final Deque<Optional<Object>> queue = new ArrayDeque<Optional<Object>>();
    private InputRowParser parser;
    private boolean closed;

    private TestFirehose(InputRowParser parser, boolean waitForClose, List<Object> seedRows) {
        this.parser = parser;
        boolean bl = this.closed = !waitForClose;
        if (parser instanceof StringInputRowParser) {
            ((StringInputRowParser)parser).startFileFromBeginning();
        }
        if (seedRows != null) {
            seedRows.stream().map(Optional::ofNullable).forEach(this.queue::add);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRows(List<Object> rows) {
        TestFirehose testFirehose = this;
        synchronized (testFirehose) {
            rows.stream().map(Optional::ofNullable).forEach(this.queue::add);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMore() {
        try {
            TestFirehose testFirehose = this;
            synchronized (testFirehose) {
                while (this.queue.isEmpty() && !this.closed) {
                    this.wait();
                }
                return !this.queue.isEmpty();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputRow nextRow() {
        TestFirehose testFirehose = this;
        synchronized (testFirehose) {
            InputRow row;
            InputRow inputRow = row = this.parser instanceof StringInputRowParser ? ((StringInputRowParser)this.parser).parse((String)this.queue.removeFirst().orElse(null)) : (InputRow)this.parser.parseBatch(this.queue.removeFirst().orElse(null)).get(0);
            if (row != null && row.getRaw(FAIL_DIM) != null) {
                throw new ParseException(null, FAIL_DIM, new Object[0]);
            }
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        TestFirehose testFirehose = this;
        synchronized (testFirehose) {
            this.closed = true;
            this.notifyAll();
        }
    }

    public static class TestFirehoseFactory
    implements FirehoseFactory<InputRowParser> {
        private boolean waitForClose = true;

        public Firehose connect(InputRowParser parser, File temporaryDirectory) throws ParseException {
            return new TestFirehose(parser, this.waitForClose, Collections.emptyList());
        }
    }
}

