/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.SegmentAllocateRequest;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.joda.time.DateTime;

public class SegmentAllocateActionBuilder {
    private String dataSource;
    private DateTime timestamp;
    private Granularity queryGranularity;
    private Granularity preferredSegmentGranularity;
    private String sequenceName;
    private String previousSegmentId;
    private boolean skipSegmentLineageCheck;
    private PartialShardSpec partialShardSpec;
    private LockGranularity lockGranularity;
    private TaskLockType taskLockType;
    private Task task;

    public SegmentAllocateActionBuilder forDatasource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public SegmentAllocateActionBuilder forTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public SegmentAllocateActionBuilder forTimestamp(String instant) {
        this.timestamp = DateTimes.of((String)instant);
        return this;
    }

    public SegmentAllocateActionBuilder withQueryGranularity(Granularity queryGranularity) {
        this.queryGranularity = queryGranularity;
        return this;
    }

    public SegmentAllocateActionBuilder withSegmentGranularity(Granularity segmentGranularity) {
        this.preferredSegmentGranularity = segmentGranularity;
        return this;
    }

    public SegmentAllocateActionBuilder withSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
        return this;
    }

    public SegmentAllocateActionBuilder withPreviousSegmentId(String previousSegmentId) {
        this.previousSegmentId = previousSegmentId;
        return this;
    }

    public SegmentAllocateActionBuilder withSkipLineageCheck(boolean skipLineageCheck) {
        this.skipSegmentLineageCheck = skipLineageCheck;
        return this;
    }

    public SegmentAllocateActionBuilder withPartialShardSpec(PartialShardSpec partialShardSpec) {
        this.partialShardSpec = partialShardSpec;
        return this;
    }

    public SegmentAllocateActionBuilder withLockGranularity(LockGranularity lockGranularity) {
        this.lockGranularity = lockGranularity;
        return this;
    }

    public SegmentAllocateActionBuilder withTaskLockType(TaskLockType taskLockType) {
        this.taskLockType = taskLockType;
        return this;
    }

    public SegmentAllocateActionBuilder forTask(Task task) {
        this.dataSource = task.getDataSource();
        this.sequenceName = task.getId();
        this.task = task;
        return this;
    }

    public SegmentAllocateRequest build() {
        return new SegmentAllocateRequest(this.task, this.buildAction(), 1);
    }

    public SegmentAllocateAction buildAction() {
        return new SegmentAllocateAction(this.dataSource, this.timestamp, this.queryGranularity, this.preferredSegmentGranularity, this.sequenceName, this.previousSegmentId, this.skipSegmentLineageCheck, this.partialShardSpec, this.lockGranularity, this.taskLockType);
    }
}

